/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.util;

import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.drools.model.util.OperatorUtils;
import org.junit.jupiter.api.Test;

public class OperatorUtilsTest {
    @Test
    public void areEqualWithNumbers() {
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)1, (Object)1)).isTrue();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)1L, (Object)1L)).isTrue();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f))).isTrue();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)1.0, (Object)1.0)).isTrue();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)1, (Object)2)).isFalse();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)1L, (Object)2L)).isFalse();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f))).isFalse();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)1.0, (Object)2.0)).isFalse();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)1, (Object)"1")).isFalse();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)1L, (Object)"1")).isFalse();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)Float.valueOf(1.0f), (Object)"1")).isFalse();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)1.0, (Object)"1")).isFalse();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)1, (Object)new BigDecimal("1"))).isTrue();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)1, (Object)new BigDecimal("1.0"))).isTrue();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)1, (Object)new BigDecimal("1.00"))).isTrue();
    }

    @Test
    public void areEqualWithObjects() {
        Assertions.assertThat((boolean)OperatorUtils.areEqual(null, null)).isTrue();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)"test", (Object)"test")).isTrue();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)new Object(), (Object)new Object())).isFalse();
        Assertions.assertThat((boolean)OperatorUtils.areEqual(null, (Object)"test")).isFalse();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)"test", null)).isFalse();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)new Object(), null)).isFalse();
        Assertions.assertThat((boolean)OperatorUtils.areEqual(null, (Object)new Object())).isFalse();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)new Object(), (Object)"test")).isFalse();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)"test", (Object)new Object())).isFalse();
    }

    @Test
    public void areNumericEqualWithNumbers() {
        Assertions.assertThat((boolean)OperatorUtils.areNumericEqual((Number)1, (Number)1)).isTrue();
        Assertions.assertThat((boolean)OperatorUtils.areNumericEqual((Number)1L, (Number)1L)).isTrue();
        Assertions.assertThat((boolean)OperatorUtils.areNumericEqual((Number)Float.valueOf(1.0f), (Number)Float.valueOf(1.0f))).isTrue();
        Assertions.assertThat((boolean)OperatorUtils.areNumericEqual((Number)1.0, (Number)1.0)).isTrue();
        Assertions.assertThat((boolean)OperatorUtils.areNumericEqual((Number)1, (Number)2)).isFalse();
        Assertions.assertThat((boolean)OperatorUtils.areNumericEqual((Number)1L, (Number)2L)).isFalse();
        Assertions.assertThat((boolean)OperatorUtils.areNumericEqual((Number)Float.valueOf(1.0f), (Number)Float.valueOf(2.0f))).isFalse();
        Assertions.assertThat((boolean)OperatorUtils.areNumericEqual((Number)1.0, (Number)2.0)).isFalse();
        Assertions.assertThat((boolean)OperatorUtils.areNumericEqual((Number)1, (Number)new BigDecimal("1"))).isTrue();
        Assertions.assertThat((boolean)OperatorUtils.areNumericEqual((Number)1, (Number)new BigDecimal("1.0"))).isTrue();
        Assertions.assertThat((boolean)OperatorUtils.areNumericEqual((Number)1, (Number)new BigDecimal("1.00"))).isTrue();
        Assertions.assertThat((boolean)OperatorUtils.areNumericEqual((Number)BigDecimal.valueOf(0.1), (Number)BigDecimal.valueOf(0.1))).isTrue();
        Assertions.assertThat((boolean)OperatorUtils.areNumericEqual((Number)BigDecimal.valueOf(0.1), (Number)BigDecimal.valueOf(0.100000001))).isFalse();
        Assertions.assertThat((boolean)OperatorUtils.areNumericEqual((Number)new BigDecimal("1.0"), (Number)new BigDecimal("1.00"))).isTrue();
    }

    @Test
    public void compareWithNumbers() {
        Assertions.assertThat((int)OperatorUtils.compare((Object)1, (Object)1)).isZero();
        Assertions.assertThat((int)OperatorUtils.compare((Object)1L, (Object)1L)).isZero();
        Assertions.assertThat((int)OperatorUtils.compare((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f))).isZero();
        Assertions.assertThat((int)OperatorUtils.compare((Object)1.0, (Object)1.0)).isZero();
        Assertions.assertThat((int)OperatorUtils.compare((Object)1, (Object)2)).isNegative();
        Assertions.assertThat((int)OperatorUtils.compare((Object)1L, (Object)2L)).isNegative();
        Assertions.assertThat((int)OperatorUtils.compare((Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f))).isNegative();
        Assertions.assertThat((int)OperatorUtils.compare((Object)1.0, (Object)2.0)).isNegative();
        Assertions.assertThat((int)OperatorUtils.compare((Object)2, (Object)1)).isPositive();
        Assertions.assertThat((int)OperatorUtils.compare((Object)2L, (Object)1L)).isPositive();
        Assertions.assertThat((int)OperatorUtils.compare((Object)Float.valueOf(2.0f), (Object)Float.valueOf(1.0f))).isPositive();
        Assertions.assertThat((int)OperatorUtils.compare((Object)2.0, (Object)1.0)).isPositive();
        Assertions.assertThat((int)OperatorUtils.compare((Object)1, (Object)new BigDecimal("0.99"))).isPositive();
        Assertions.assertThat((int)OperatorUtils.compare((Object)1, (Object)new BigDecimal("1.0"))).isZero();
        Assertions.assertThat((int)OperatorUtils.compare((Object)1, (Object)new BigDecimal("1.01"))).isNegative();
        Assertions.assertThat((int)OperatorUtils.compare((Object)new BigDecimal("1.00"), (Object)new BigDecimal("0.99"))).isPositive();
        Assertions.assertThat((int)OperatorUtils.compare((Object)new BigDecimal("1.00"), (Object)new BigDecimal("1.0"))).isZero();
        Assertions.assertThat((int)OperatorUtils.compare((Object)new BigDecimal("1.00"), (Object)new BigDecimal("1.01"))).isNegative();
    }

    @Test
    public void compareWithString() {
        Assertions.assertThat((int)OperatorUtils.compare((Object)"ABC", (Object)"AAA")).isPositive();
        Assertions.assertThat((int)OperatorUtils.compare((Object)"ABC", (Object)"ABC")).isZero();
        Assertions.assertThat((int)OperatorUtils.compare((Object)"ABC", (Object)"XYZ")).isNegative();
    }

    @Test
    public void asBigDecimal() {
        Assertions.assertThat((BigDecimal)OperatorUtils.asBigDecimal((Number)1)).isEqualTo((Object)new BigDecimal("1.0"));
        Assertions.assertThat((BigDecimal)OperatorUtils.asBigDecimal((Number)1.0)).isEqualTo((Object)new BigDecimal("1.0"));
        Assertions.assertThat((BigDecimal)OperatorUtils.asBigDecimal((Number)new BigDecimal("1.0"))).isEqualTo((Object)new BigDecimal("1.0"));
    }
}

