/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.constraints;

import java.util.ArrayList;
import java.util.List;
import org.drools.model.Constraint;
import org.drools.model.constraints.AbstractConstraint;
import org.drools.model.impl.ModelComponent;

public class OrConstraints
extends AbstractConstraint
implements ModelComponent {
    private final List<Constraint> constraints;

    public OrConstraints(List<Constraint> constraints) {
        this.constraints = constraints;
    }

    public OrConstraints(Constraint ... constraints) {
        this.constraints = new ArrayList<Constraint>();
        for (Constraint constraint : constraints) {
            this.or(constraint);
        }
    }

    @Override
    public OrConstraints or(Constraint constraint) {
        this.constraints.add(constraint);
        return this;
    }

    @Override
    public List<Constraint> getChildren() {
        return this.constraints;
    }

    @Override
    public Constraint.Type getType() {
        return Constraint.Type.OR;
    }

    @Override
    public boolean isEqualTo(ModelComponent o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrConstraints)) {
            return false;
        }
        OrConstraints that = (OrConstraints)o;
        return ModelComponent.areEqualInModel(this.constraints, that.constraints);
    }
}

