/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.operators;

import java.util.Collection;
import org.drools.model.functions.Operator;

public enum ContainsOperator implements Operator.SingleValue<Object, Object>
{
    INSTANCE;


    @Override
    public boolean eval(Object a, Object b) {
        if (a instanceof Collection) {
            return ((Collection)a).contains(b);
        }
        return a.getClass().isArray() && this.evalArray(a, b);
    }

    private boolean evalArray(Object a, Object b) {
        if (a instanceof Object[]) {
            for (Object o : (Object[])a) {
                if (!o.equals(b)) continue;
                return true;
            }
        }
        if (a instanceof int[]) {
            for (int o : (int[])a) {
                if (o != (Integer)b) continue;
                return true;
            }
        }
        if (a instanceof long[]) {
            for (long o : (long[])a) {
                if (o != (Long)b) continue;
                return true;
            }
        }
        if (a instanceof double[]) {
            for (double o : (double[])a) {
                if (o != (Double)b) continue;
                return true;
            }
        }
        if (a instanceof float[]) {
            for (float o : (float[])a) {
                if (o != ((Float)b).floatValue()) continue;
                return true;
            }
        }
        if (a instanceof boolean[]) {
            for (boolean o : (boolean[])a) {
                if (o != (Boolean)b) continue;
                return true;
            }
        }
        if (a instanceof char[]) {
            for (char o : (char[])a) {
                if (o != ((Character)b).charValue()) continue;
                return true;
            }
        }
        if (a instanceof byte[]) {
            for (byte o : (byte[])a) {
                if (o != (Byte)b) continue;
                return true;
            }
        }
        if (a instanceof short[]) {
            for (short o : (short[])a) {
                if (o != (Short)b) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getOperatorName() {
        return "contains";
    }
}

