/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.consequences;

import java.util.Arrays;
import java.util.stream.Stream;
import org.drools.model.Consequence;
import org.drools.model.Variable;
import org.drools.model.functions.BlockN;
import org.drools.model.functions.FunctionN;
import org.drools.model.impl.ModelComponent;

public class ConsequenceImpl
implements Consequence,
ModelComponent {
    private final Variable[] variables;
    private final Variable[] declarations;
    private final BlockN block;
    private final FunctionN[] inserts;
    private final Consequence.Update[] updates;
    private final Variable[] deletes;
    private final boolean usingDrools;
    private final boolean breaking;
    private final String language;

    ConsequenceImpl(BlockN block, Variable[] variables, FunctionN[] inserts, Consequence.Update[] updates, Variable[] deletes, boolean usingDrools, boolean breaking, String language) {
        this.variables = variables;
        this.declarations = (Variable[])Stream.of(variables).filter(Variable::isFact).toArray(Variable[]::new);
        this.block = block;
        this.inserts = inserts == null ? new FunctionN[]{} : inserts;
        this.updates = updates == null ? new Consequence.Update[]{} : updates;
        this.deletes = deletes == null ? new Variable[]{} : deletes;
        this.usingDrools = usingDrools;
        this.breaking = breaking;
        this.language = language;
    }

    @Override
    public Variable[] getVariables() {
        return this.variables;
    }

    @Override
    public Variable[] getDeclarations() {
        return this.declarations;
    }

    @Override
    public BlockN getBlock() {
        return this.block;
    }

    @Override
    public FunctionN[] getInserts() {
        return this.inserts;
    }

    @Override
    public Consequence.Update[] getUpdates() {
        return this.updates;
    }

    @Override
    public Variable[] getDeletes() {
        return this.deletes;
    }

    @Override
    public boolean isUsingDrools() {
        return this.usingDrools;
    }

    @Override
    public boolean isBreaking() {
        return this.breaking;
    }

    @Override
    public boolean isChangingWorkingMemory() {
        return this.inserts.length > 0 || this.updates.length > 0 || this.deletes.length > 0;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public boolean isEqualTo(ModelComponent o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConsequenceImpl)) {
            return false;
        }
        ConsequenceImpl that = (ConsequenceImpl)o;
        if (this.usingDrools != that.usingDrools) {
            return false;
        }
        if (this.breaking != that.breaking) {
            return false;
        }
        if (!ModelComponent.areEqualInModel(this.variables, that.variables)) {
            return false;
        }
        if (!ModelComponent.areEqualInModel(this.declarations, that.declarations)) {
            return false;
        }
        if (this.block != null ? !this.block.equals(that.block) : that.block != null) {
            return false;
        }
        if (!Arrays.equals(this.inserts, that.inserts)) {
            return false;
        }
        if (!Arrays.equals(this.updates, that.updates)) {
            return false;
        }
        if (!ModelComponent.areEqualInModel(this.deletes, that.deletes)) {
            return false;
        }
        return this.language != null ? this.language.equals(that.language) : that.language == null;
    }

    public static class UpdateImpl
    implements Consequence.Update {
        private final Variable updatedVariable;
        private final String[] updatedFields;

        public UpdateImpl(Variable updatedVariable, String ... updatedFields) {
            this.updatedVariable = updatedVariable;
            this.updatedFields = updatedFields;
        }

        public Variable getUpdatedVariable() {
            return this.updatedVariable;
        }

        @Override
        public String[] getUpdatedFields() {
            return this.updatedFields;
        }
    }
}

