/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions.temporal;

import org.drools.model.functions.temporal.AbstractTemporalPredicate;
import org.drools.model.functions.temporal.Interval;

public class IncludesPredicate
extends AbstractTemporalPredicate {
    private final long startMinDev;
    private final long startMaxDev = Long.MAX_VALUE;
    private final long endMinDev;
    private final long endMaxDev = Long.MAX_VALUE;

    public IncludesPredicate() {
        super(new Interval(Long.MIN_VALUE, 0L));
        this.startMinDev = 1L;
        this.endMinDev = 1L;
    }

    public String toString() {
        return "during " + this.interval;
    }

    @Override
    public boolean evaluate(long start1, long duration1, long end1, long start2, long duration2, long end2) {
        long distStart = start2 - start1;
        long distEnd = end1 - end2;
        return distStart >= this.startMinDev && distStart <= this.startMaxDev && distEnd >= this.endMinDev && distEnd <= this.endMaxDev;
    }
}

