/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions.temporal;

import java.util.concurrent.TimeUnit;
import org.drools.model.functions.temporal.AbstractTemporalPredicate;
import org.drools.model.functions.temporal.Interval;
import org.drools.model.functions.temporal.TimeUtil;

public class OverlappedbyPredicate
extends AbstractTemporalPredicate {
    long minDev;
    long maxDev;

    public OverlappedbyPredicate() {
        super(new Interval(0L, Long.MAX_VALUE));
        this.minDev = 1L;
        this.maxDev = Long.MAX_VALUE;
    }

    public OverlappedbyPredicate(long maxDev, TimeUnit maxDevTimeUnit) {
        super(new Interval(0L, Long.MAX_VALUE));
        this.minDev = 1L;
        this.maxDev = TimeUtil.unitToLong(maxDev, maxDevTimeUnit);
    }

    public OverlappedbyPredicate(long minDev, TimeUnit minDevTimeUnit, long maxDev, TimeUnit maxDevTimeUnit) {
        super(new Interval(0L, Long.MAX_VALUE));
        this.minDev = TimeUtil.unitToLong(minDev, minDevTimeUnit);
        this.maxDev = TimeUtil.unitToLong(maxDev, maxDevTimeUnit);
    }

    public String toString() {
        return "overlappedby" + this.interval;
    }

    @Override
    public boolean evaluate(long start1, long duration1, long end1, long start2, long duration2, long end2) {
        long startTS = start1;
        long endTS = end2;
        long dist = endTS - startTS;
        return start2 < startTS && endTS < end1 && dist >= this.minDev && dist <= this.maxDev;
    }
}

