/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions.temporal;

import java.util.concurrent.TimeUnit;
import org.drools.model.functions.temporal.AbstractTemporalPredicate;
import org.drools.model.functions.temporal.Interval;
import org.drools.model.functions.temporal.TimeUtil;

public class OverlapsPredicate
extends AbstractTemporalPredicate {
    long minDev;
    long maxDev;

    public OverlapsPredicate() {
        super(new Interval(Long.MIN_VALUE, 0L));
        this.minDev = 1L;
        this.maxDev = Long.MAX_VALUE;
    }

    public OverlapsPredicate(long maxDev, TimeUnit maxDevTimeUnit) {
        super(new Interval(Long.MIN_VALUE, 0L));
        this.minDev = 1L;
        this.maxDev = TimeUtil.unitToLong(maxDev, maxDevTimeUnit);
    }

    public OverlapsPredicate(long minDev, TimeUnit minDevTimeUnit, long maxDev, TimeUnit maxDevTimeUnit) {
        super(new Interval(Long.MIN_VALUE, 0L));
        this.minDev = TimeUtil.unitToLong(minDev, minDevTimeUnit);
        this.maxDev = TimeUtil.unitToLong(maxDev, maxDevTimeUnit);
    }

    public String toString() {
        return "overlaps" + this.interval;
    }

    @Override
    public boolean evaluate(long start1, long duration1, long end1, long start2, long duration2, long end2) {
        long dist = end1 - start2;
        return start1 < start2 && end1 < end2 && dist >= this.minDev && dist <= this.maxDev;
    }
}

