/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class PredicateInformation {
    public static final PredicateInformation EMPTY_PREDICATE_INFORMATION = new PredicateInformation("", "", "");
    private final String stringConstraint;
    private final Set<RuleDef> ruleDefs = new TreeSet<RuleDef>();

    public PredicateInformation(String stringConstraint, String ... ruleNames) {
        this.stringConstraint = PredicateInformation.defaultToEmptyString(stringConstraint);
        this.addRuleNames(ruleNames);
    }

    public String getStringConstraint() {
        return this.stringConstraint;
    }

    public Set<RuleDef> getRuleDefs() {
        return this.ruleDefs;
    }

    public void addRuleNames(String ... ruleNames) {
        for (int i = 0; i < ruleNames.length; i += 2) {
            this.ruleDefs.add(new RuleDef(PredicateInformation.defaultToEmptyString(ruleNames[i + 1]), PredicateInformation.defaultToEmptyString(ruleNames[i])));
        }
    }

    public Map<String, Set<String>> getRuleNameMap() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (RuleDef ruleDef : this.ruleDefs) {
            map.computeIfAbsent(ruleDef.fileName, k -> new HashSet()).add(ruleDef.ruleName);
        }
        return map;
    }

    public static String defaultToEmptyString(String str) {
        return str == null ? "" : str;
    }

    public boolean isEmpty() {
        return EMPTY_PREDICATE_INFORMATION.equals(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredicateInformation that = (PredicateInformation)o;
        return Objects.equals(this.stringConstraint, that.stringConstraint) && Objects.equals(this.ruleDefs, that.ruleDefs);
    }

    public int hashCode() {
        return Objects.hash(this.stringConstraint, this.ruleDefs);
    }

    public String toString() {
        return "PredicateInformation{stringConstraint='" + this.stringConstraint + '\'' + ", ruleNameMap='" + this.ruleDefs + '\'' + '}';
    }

    public static class RuleDef
    implements Comparable<RuleDef> {
        private final String fileName;
        private final String ruleName;

        public RuleDef(String fileName, String ruleName) {
            this.fileName = fileName;
            this.ruleName = ruleName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getRuleName() {
            return this.ruleName;
        }

        @Override
        public int compareTo(RuleDef other) {
            int fileNameCompare = this.fileName.compareTo(other.fileName);
            return fileNameCompare != 0 ? fileNameCompare : this.ruleName.compareTo(other.ruleName);
        }

        public String toString() {
            return "RuleDef{fileName='" + this.fileName + '\'' + ", ruleName='" + this.ruleName + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RuleDef ruleDef = (RuleDef)o;
            return Objects.equals(this.fileName, ruleDef.fileName) && Objects.equals(this.ruleName, ruleDef.ruleName);
        }

        public int hashCode() {
            return Objects.hash(this.fileName, this.ruleName);
        }
    }
}

