/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions.temporal;

import java.util.concurrent.TimeUnit;
import org.drools.model.functions.temporal.AbstractTemporalPredicate;
import org.drools.model.functions.temporal.Interval;
import org.drools.model.functions.temporal.TimeUtil;

public class OverlappedbyPredicate
extends AbstractTemporalPredicate {
    private final long minDev;
    private final long maxDev;

    public OverlappedbyPredicate() {
        this(1L, Long.MAX_VALUE);
    }

    public OverlappedbyPredicate(long maxDev, TimeUnit maxDevTimeUnit) {
        this(1L, TimeUtil.unitToLong(maxDev, maxDevTimeUnit));
    }

    public OverlappedbyPredicate(long minDev, TimeUnit minDevTimeUnit, long maxDev, TimeUnit maxDevTimeUnit) {
        this(TimeUtil.unitToLong(minDev, minDevTimeUnit), TimeUtil.unitToLong(maxDev, maxDevTimeUnit));
    }

    private OverlappedbyPredicate(long minDev, long maxDev) {
        this.minDev = minDev;
        this.maxDev = maxDev;
    }

    public String toString() {
        return (this.negated ? "not " : "") + "overlappedby[" + this.minDev + ", " + this.maxDev + "]";
    }

    @Override
    public Interval getInterval() {
        return this.negated ? new Interval(Long.MIN_VALUE, Long.MAX_VALUE) : new Interval(0L, Long.MAX_VALUE);
    }

    @Override
    public boolean evaluate(long start1, long duration1, long end1, long start2, long duration2, long end2) {
        long startTS = start1;
        long endTS = end2;
        long dist = endTS - startTS;
        return this.negated ^ (start2 < startTS && endTS < end1 && dist >= this.minDev && dist <= this.maxDev);
    }
}

