/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.bitmask;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.drools.model.BitMask;
import org.drools.model.bitmask.AllSetBitMask;
import org.drools.model.bitmask.EmptyBitMask;

public class BitMaskUtil {
    public static final int TRAITABLE_BIT = 0;
    public static final int CUSTOM_BITS_OFFSET = 1;
    public static final String TRAITSET_FIELD_NAME = "__$$dynamic_traits_map$$";

    public static BitMask calculatePatternMask(Class<?> clazz, Collection<String> listenedProperties) {
        List<String> accessibleProperties = BitMaskUtil.getAccessibleProperties(clazz);
        if (listenedProperties == null) {
            return EmptyBitMask.get();
        }
        BitMask mask = BitMaskUtil.getEmptyPropertyReactiveMask(accessibleProperties.size());
        if (listenedProperties.contains(TRAITSET_FIELD_NAME) && listenedProperties.contains(TRAITSET_FIELD_NAME)) {
            mask = mask.set(0);
        }
        for (String propertyName : listenedProperties) {
            if (propertyName.equals("*")) {
                return AllSetBitMask.get();
            }
            mask = BitMaskUtil.setPropertyOnMask(mask, accessibleProperties, propertyName);
        }
        return mask;
    }

    private static BitMask getEmptyPropertyReactiveMask(int settablePropertiesSize) {
        return BitMask.getEmpty(settablePropertiesSize + 1);
    }

    private static BitMask setPropertyOnMask(BitMask mask, List<String> settableProperties, String propertyName) {
        int index = settableProperties.indexOf(propertyName);
        if (index < 0) {
            throw new RuntimeException("Unknown property: " + propertyName);
        }
        return BitMaskUtil.setPropertyOnMask(mask, index);
    }

    private static BitMask setPropertyOnMask(BitMask mask, int index) {
        return mask.set(index + 1);
    }

    private static List<String> getAccessibleProperties(Class<?> clazz) {
        TreeSet<PropertyInClass> props = new TreeSet<PropertyInClass>();
        for (Method method : clazz.getMethods()) {
            String propName;
            if (method.getParameterTypes().length != 0 || (propName = BitMaskUtil.getter2property(method.getName())) == null || propName.equals("class")) continue;
            props.add(new PropertyInClass(propName, method.getDeclaringClass()));
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            if (Modifier.isFinal(((Field)accessibleObject).getModifiers()) || Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            props.add(new PropertyInClass(((Field)accessibleObject).getName(), ((Field)accessibleObject).getDeclaringClass()));
        }
        ArrayList<String> accessibleProperties = new ArrayList<String>();
        for (PropertyInClass setter : props) {
            accessibleProperties.add(setter.setter);
        }
        return accessibleProperties;
    }

    private static String getter2property(String methodName) {
        if (methodName.startsWith("get") && methodName.length() > 3) {
            return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
        }
        if (methodName.startsWith("is") && methodName.length() > 2) {
            return Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
        }
        return null;
    }

    private static class PropertyInClass
    implements Comparable {
        private final String setter;
        private final Class<?> clazz;

        private PropertyInClass(String setter, Class<?> clazz) {
            this.setter = setter;
            this.clazz = clazz;
        }

        public int compareTo(Object o) {
            PropertyInClass other = (PropertyInClass)o;
            if (this.clazz == other.clazz) {
                return this.setter.compareTo(other.setter);
            }
            return this.clazz.isAssignableFrom(other.clazz) ? -1 : 1;
        }

        public boolean equals(Object obj) {
            PropertyInClass other = (PropertyInClass)obj;
            return this.clazz == other.clazz && this.setter.equals(other.setter);
        }

        public int hashCode() {
            return 29 * this.clazz.hashCode() + 31 * this.setter.hashCode();
        }
    }
}

