/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.util;

import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.drools.model.util.OperatorUtils;
import org.junit.Test;

public class OperatorUtilsTest {
    @Test
    public void areEqual_sameType() {
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)"100", (Object)String.valueOf(100))).isTrue();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)"Hello", (Object)String.valueOf(100))).isFalse();
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)100, (Object)100)).isTrue();
    }

    @Test
    public void areEqual_differentTypes() {
        Assertions.assertThat((boolean)OperatorUtils.areEqual((Object)"100", (Object)100)).isFalse();
    }

    @Test
    public void areNumericEqual_IntegerBigDecimal() {
        Assertions.assertThat((boolean)OperatorUtils.areNumericEqual((Number)1, (Number)new BigDecimal("1"))).isTrue();
        Assertions.assertThat((boolean)OperatorUtils.areNumericEqual((Number)1, (Number)new BigDecimal("1.0"))).isTrue();
        Assertions.assertThat((boolean)OperatorUtils.areNumericEqual((Number)1, (Number)new BigDecimal("1.00"))).isTrue();
    }

    @Test
    public void areNumericEqual_BigDecimalWithDifferentScale() {
        Assertions.assertThat((boolean)OperatorUtils.areNumericEqual((Number)new BigDecimal("1.0"), (Number)new BigDecimal("1.00"))).isTrue();
    }

    @Test
    public void compare_IntegerBigDecimal() {
        Assertions.assertThat((int)OperatorUtils.compare((Object)1, (Object)new BigDecimal("0.99"))).isGreaterThan(0);
        Assertions.assertThat((int)OperatorUtils.compare((Object)1, (Object)new BigDecimal("1.0"))).isZero();
        Assertions.assertThat((int)OperatorUtils.compare((Object)1, (Object)new BigDecimal("1.01"))).isLessThan(0);
    }

    @Test
    public void compare_BigDecimalWithDifferentScale() {
        Assertions.assertThat((int)OperatorUtils.compare((Object)new BigDecimal("1.00"), (Object)new BigDecimal("0.99"))).isGreaterThan(0);
        Assertions.assertThat((int)OperatorUtils.compare((Object)new BigDecimal("1.00"), (Object)new BigDecimal("1.0"))).isZero();
        Assertions.assertThat((int)OperatorUtils.compare((Object)new BigDecimal("1.00"), (Object)new BigDecimal("1.01"))).isLessThan(0);
    }

    @Test
    public void compare_String() {
        Assertions.assertThat((int)OperatorUtils.compare((Object)"ABC", (Object)"AAA")).isGreaterThan(0);
        Assertions.assertThat((int)OperatorUtils.compare((Object)"ABC", (Object)"ABC")).isZero();
        Assertions.assertThat((int)OperatorUtils.compare((Object)"ABC", (Object)"XYZ")).isLessThan(0);
    }

    @Test
    public void asBigDecimal() {
        Assertions.assertThat((BigDecimal)OperatorUtils.asBigDecimal((Number)1)).isEqualTo((Object)new BigDecimal("1.0"));
        Assertions.assertThat((BigDecimal)OperatorUtils.asBigDecimal((Number)1.0)).isEqualTo((Object)new BigDecimal("1.0"));
        Assertions.assertThat((BigDecimal)OperatorUtils.asBigDecimal((Number)new BigDecimal("1.0"))).isEqualTo((Object)new BigDecimal("1.0"));
    }
}

