/*
 * Decompiled with CFR 0.152.
 */
package org.drools.clips;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.base.ClassTypeResolver;
import org.drools.base.mvel.DroolsMVELFactory;
import org.drools.clips.ClipsLexer;
import org.drools.clips.ClipsParser;
import org.drools.clips.Function;
import org.drools.clips.FunctionContext;
import org.drools.clips.FunctionHandlers;
import org.drools.clips.LispForm;
import org.drools.clips.ParserHandler;
import org.drools.clips.PrintRouterContext;
import org.drools.clips.StringBuilderAppendable;
import org.drools.clips.VariableContext;
import org.drools.clips.functions.AssertFunction;
import org.drools.clips.functions.BindFunction;
import org.drools.clips.functions.CallFunction;
import org.drools.clips.functions.CreateListFunction;
import org.drools.clips.functions.EqFunction;
import org.drools.clips.functions.GetFunction;
import org.drools.clips.functions.IfFunction;
import org.drools.clips.functions.LessThanFunction;
import org.drools.clips.functions.LessThanOrEqFunction;
import org.drools.clips.functions.MinusFunction;
import org.drools.clips.functions.ModifyFunction;
import org.drools.clips.functions.MoreThanFunction;
import org.drools.clips.functions.MoreThanOrEqFunction;
import org.drools.clips.functions.MultiplyFunction;
import org.drools.clips.functions.NewFunction;
import org.drools.clips.functions.PlusFunction;
import org.drools.clips.functions.PrintoutFunction;
import org.drools.clips.functions.PrognFunction;
import org.drools.clips.functions.ReturnFunction;
import org.drools.clips.functions.RunFunction;
import org.drools.clips.functions.SetFunction;
import org.drools.clips.functions.SwitchFunction;
import org.drools.common.InternalRuleBase;
import org.drools.compiler.PackageBuilder;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.rule.ImportDeclaration;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.Namespaceable;
import org.drools.rule.Package;
import org.drools.runtime.rule.FactHandle;
import org.drools.spi.GlobalResolver;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExpressionCompiler;
import org.mvel2.integration.VariableResolverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClipsShell
implements ParserHandler,
VariableContext,
FunctionContext,
PrintRouterContext {
    private Map<String, Object> vars;
    private PackageBuilder packageBuilder;
    private RuleBase ruleBase;
    private StatefulSession session;
    private ClassTypeResolver typeResolver;
    private String moduleName = "MAIN";
    private static final String MAIN = "MAIN";
    private DroolsMVELFactory factory;

    public ClipsShell() {
        this(RuleBaseFactory.newRuleBase());
    }

    public static void main(String[] args) throws Exception {
        String cmd;
        StringBuffer buf = new StringBuffer();
        FunctionHandlers handlers = FunctionHandlers.getInstance();
        handlers.registerFunction(new PlusFunction());
        handlers.registerFunction(new MinusFunction());
        handlers.registerFunction(new MultiplyFunction());
        handlers.registerFunction(new ModifyFunction());
        handlers.registerFunction(new CreateListFunction());
        handlers.registerFunction(new PrintoutFunction());
        handlers.registerFunction(new PrognFunction());
        handlers.registerFunction(new IfFunction());
        handlers.registerFunction(new LessThanFunction());
        handlers.registerFunction(new LessThanOrEqFunction());
        handlers.registerFunction(new MoreThanFunction());
        handlers.registerFunction(new MoreThanOrEqFunction());
        handlers.registerFunction(new EqFunction());
        handlers.registerFunction(new SwitchFunction());
        handlers.registerFunction(new ReturnFunction());
        handlers.registerFunction(new RunFunction());
        handlers.registerFunction(new BindFunction());
        handlers.registerFunction(new NewFunction());
        handlers.registerFunction(new SetFunction());
        handlers.registerFunction(new GetFunction());
        handlers.registerFunction(new CallFunction());
        handlers.registerFunction(new AssertFunction());
        ClipsShell shell = new ClipsShell();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        shell.addRouter("t", new PrintStream(out));
        System.out.print("Drools>");
        StringBuffer sessionLog = new StringBuffer();
        while (true) {
            String file;
            byte[] name = new byte[256];
            System.in.read(name);
            cmd = new String(name).trim();
            if (cmd.equals("(exit)") || cmd.equals("(quit)")) break;
            buf.append(cmd);
            if (!ClipsShell.isBalancedBrackets(buf)) continue;
            String exp = buf.toString();
            if (exp.startsWith("(save ")) {
                file = ClipsShell.getFileName(exp);
                System.out.println("Saving transcript to [" + file + "]");
                ClipsShell.writeFile(file, sessionLog);
                sessionLog = new StringBuffer();
                System.out.print("Drools>");
                continue;
            }
            sessionLog.append(cmd + "\n");
            if (exp.startsWith("(load ")) {
                file = ClipsShell.getFileName(exp);
                System.out.println("Loading transcript from [" + file + "]");
                exp = ClipsShell.loadFile(file);
            }
            shell.eval(exp);
            String output = new String(out.toByteArray());
            if (output != null && output.trim().length() > 0) {
                System.out.println(output);
            }
            out.reset();
            System.out.print("Drools>");
            buf = new StringBuffer();
        }
        sessionLog.append(cmd);
        System.out.println("Goodbye, and good luck !");
    }

    private static String loadFile(String fileName) throws IOException {
        int offset;
        File f = new File(fileName);
        FileInputStream is = new FileInputStream(f);
        long length = f.length();
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + f.getName());
        }
        ((InputStream)is).close();
        return new String(bytes);
    }

    private static String getFileName(String exp) {
        int qt = 39;
        if (exp.contains("\"")) {
            qt = 34;
        }
        String file = exp.substring(exp.indexOf(qt) + 1, exp.lastIndexOf(qt));
        return file;
    }

    private static void writeFile(String file, StringBuffer sessionLog) {
        try {
            File f = new File(file);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileOutputStream fout = new FileOutputStream(f);
            fout.write(sessionLog.toString().getBytes());
            fout.flush();
            fout.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("File " + file + " does not exist.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean isBalancedBrackets(StringBuffer buf) {
        char[] cs = buf.toString().toCharArray();
        int stack = 0;
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] == '(') {
                ++stack;
            }
            if (cs[i] != ')') continue;
            --stack;
        }
        return stack == 0;
    }

    public ClipsShell(RuleBase ruleBase) {
        this.ruleBase = ruleBase;
        this.packageBuilder = new PackageBuilder(this.ruleBase);
        this.session = this.ruleBase.newStatefulSession();
        this.factory = new DroolsMVELFactory(null, null, ((InternalRuleBase)this.ruleBase).getGlobals());
        this.vars = new HashMap<String, Object>();
        GlobalResolver2 globalResolver = new GlobalResolver2(this.vars, this.session.getGlobalResolver());
        this.session.setGlobalResolver((GlobalResolver)globalResolver);
        this.factory.setContext(null, null, null, (WorkingMemory)this.session, this.vars);
        this.addRouter("t", System.out);
    }

    public StatefulSession getStatefulSession() {
        return this.session;
    }

    @Override
    public void importHandler(ImportDescr descr) {
        PackageDescr pkgDescr = this.createPackageDescr(this.session.getAgenda().getFocusName());
        pkgDescr.addImport(descr);
        this.packageBuilder.addPackage(pkgDescr);
    }

    @Override
    public void functionHandler(FunctionDescr functionDescr) {
        functionDescr.setNamespace(MAIN);
        StringBuilderAppendable builder = new StringBuilderAppendable();
        String name = functionDescr.getName().trim();
        if (name.charAt(0) == '\"') {
            name = name.substring(1);
        }
        if (name.charAt(name.length() - 1) == '\"') {
            name = name.substring(0, name.length() - 1);
        }
        builder.append("function " + name + "(");
        int length = functionDescr.getParameterNames().size();
        for (int i = 0; i < length; ++i) {
            builder.append((String)functionDescr.getParameterNames().get(i));
            if (i >= length - 1) continue;
            builder.append(", ");
        }
        builder.append(") {\n");
        List list = (List)functionDescr.getContent();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            FunctionHandlers.dump((LispForm)it.next(), builder);
        }
        builder.append("}");
        functionDescr.setContent((Object)((Object)builder).toString());
        functionDescr.setDialect("clips");
        PackageDescr pkgDescr = this.createPackageDescr(functionDescr.getNamespace());
        pkgDescr.addFunction(functionDescr);
        this.packageBuilder.addPackage(pkgDescr);
    }

    @Override
    public void lispFormHandler(LispForm lispForm) {
        StringBuilderAppendable appendable = new StringBuilderAppendable();
        FunctionHandlers.dump(lispForm, appendable);
        ParserContext context = new ParserContext();
        String namespace = this.session.getAgenda().getFocusName();
        Package pkg = this.ruleBase.getPackage(namespace);
        if (pkg == null) {
            this.packageBuilder.addPackage(this.createPackageDescr(namespace));
            pkg = this.ruleBase.getPackage(namespace);
        }
        if (pkg != null) {
            try {
                for (Map.Entry entry : pkg.getImports().entrySet()) {
                    String importName = ((ImportDeclaration)entry.getValue()).getTarget();
                    if (importName.endsWith("*")) {
                        context.addPackageImport(importName.substring(0, importName.length() - 2));
                        continue;
                    }
                    Class cls = ((InternalRuleBase)this.ruleBase).getRootClassLoader().loadClass(importName);
                    context.addImport(cls.getSimpleName(), cls);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData("clips");
            this.factory.setNextFactory((VariableResolverFactory)data.getFunctionFactory());
        }
        ClassLoader tempClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)((InternalRuleBase)this.ruleBase).getRootClassLoader());
        ExpressionCompiler expr = new ExpressionCompiler(appendable.toString());
        CompiledExpression executable = expr.compile(context);
        MVEL.executeExpression((Object)executable, (Object)this, (VariableResolverFactory)this.factory);
        Thread.currentThread().setContextClassLoader(tempClassLoader);
    }

    @Override
    public void templateHandler(TypeDeclarationDescr typeDescr) {
        this.setModuleName((Namespaceable)typeDescr);
        PackageDescr pkg = this.createPackageDescr(typeDescr.getNamespace());
        pkg.addTypeDeclaration(typeDescr);
        this.packageBuilder.addPackage(pkg);
    }

    @Override
    public void ruleHandler(RuleDescr ruleDescr) {
        this.setModuleName((Namespaceable)ruleDescr);
        PackageDescr pkg = this.createPackageDescr(ruleDescr.getNamespace());
        pkg.addRule(ruleDescr);
        this.packageBuilder.addPackage(pkg);
        this.session.fireAllRules();
    }

    public void setModuleName(Namespaceable namespaceable) {
        if (this.isEmpty(namespaceable.getNamespace())) {
            namespaceable.setNamespace(this.session.getAgenda().getFocusName());
        }
    }

    public boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public void eval(String string) {
        this.eval(new StringReader(string));
    }

    public void eval(Reader reader) {
        try {
            ClipsParser parser = new ClipsParser((TokenStream)new CommonTokenStream((TokenSource)new ClipsLexer((CharStream)new ANTLRReaderStream(reader))));
            parser.eval(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run() {
        this.session.fireAllRules();
    }

    public void run(int fireLimit) {
        this.session.fireAllRules(fireLimit);
    }

    public FactHandle insert(Object object) {
        return this.session.insert(object);
    }

    public void importEntry(String importEntry) {
    }

    @Override
    public void addFunction(Function function) {
        this.factory.createVariable(function.getName(), (Object)function);
    }

    @Override
    public boolean removeFunction(String functionName) {
        return false;
    }

    @Override
    public Map<String, Function> getFunctions() {
        HashMap<String, Function> map = new HashMap<String, Function>();
        return map;
    }

    @Override
    public void addRouter(String name, PrintStream out) {
        HashMap<String, PrintStream> routers = (HashMap<String, PrintStream>)this.vars.get("printrouters");
        if (routers == null) {
            routers = new HashMap<String, PrintStream>();
            this.factory.createVariable("printrouters", routers);
        }
        routers.put(name, out);
    }

    @Override
    public boolean removeRouter(String name) {
        return false;
    }

    @Override
    public void addVariable(String name, Object value) {
        if (name.startsWith("?")) {
            name = name.substring(1);
        }
        this.factory.createVariable(name, value);
    }

    private PackageDescr createPackageDescr(String moduleName) {
        PackageDescr pkg = new PackageDescr(moduleName);
        pkg.addAttribute(new AttributeDescr("dialect", "clips"));
        return pkg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GlobalResolver2
    implements GlobalResolver {
        private Map<String, Object> vars;
        private GlobalResolver delegate;

        public GlobalResolver2() {
        }

        public GlobalResolver2(Map<String, Object> vars, GlobalResolver delegate) {
            this.vars = vars;
            this.delegate = delegate;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.vars = (Map)in.readObject();
            this.delegate = (GlobalResolver)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.vars);
            out.writeObject(this.delegate);
        }

        public Object resolveGlobal(String identifier) {
            Object object = this.vars.get(identifier);
            if (object == null) {
                object = this.delegate.resolveGlobal(identifier);
            }
            return object;
        }

        public void setGlobal(String identifier, Object value) {
            this.delegate.setGlobal(identifier, value);
        }
    }
}

