/*
 * Decompiled with CFR 0.152.
 */
package org.drools.clips;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.drools.Person;
import org.drools.StatefulSession;
import org.drools.clips.ClipsShell;
import org.drools.clips.Function;
import org.drools.clips.FunctionHandlers;
import org.drools.clips.functions.AssertFunction;
import org.drools.clips.functions.BindFunction;
import org.drools.clips.functions.CallFunction;
import org.drools.clips.functions.CreateListFunction;
import org.drools.clips.functions.EqFunction;
import org.drools.clips.functions.GetFunction;
import org.drools.clips.functions.IfFunction;
import org.drools.clips.functions.LessThanFunction;
import org.drools.clips.functions.LessThanOrEqFunction;
import org.drools.clips.functions.MinusFunction;
import org.drools.clips.functions.ModifyFunction;
import org.drools.clips.functions.MoreThanFunction;
import org.drools.clips.functions.MoreThanOrEqFunction;
import org.drools.clips.functions.MultiplyFunction;
import org.drools.clips.functions.NewFunction;
import org.drools.clips.functions.PlusFunction;
import org.drools.clips.functions.PrintoutFunction;
import org.drools.clips.functions.PrognFunction;
import org.drools.clips.functions.ReturnFunction;
import org.drools.clips.functions.RunFunction;
import org.drools.clips.functions.SetFunction;
import org.drools.clips.functions.SwitchFunction;
import org.drools.common.InternalRuleBase;
import org.drools.rule.Package;
import org.drools.rule.Rule;

public class ClipsShellTest
extends TestCase {
    private ByteArrayOutputStream baos;
    ClipsShell shell;

    public void setUp() {
        FunctionHandlers handlers = FunctionHandlers.getInstance();
        handlers.registerFunction((Function)new PlusFunction());
        handlers.registerFunction((Function)new MinusFunction());
        handlers.registerFunction((Function)new MultiplyFunction());
        handlers.registerFunction((Function)new ModifyFunction());
        handlers.registerFunction((Function)new CreateListFunction());
        handlers.registerFunction((Function)new PrintoutFunction());
        handlers.registerFunction((Function)new PrognFunction());
        handlers.registerFunction((Function)new IfFunction());
        handlers.registerFunction((Function)new LessThanFunction());
        handlers.registerFunction((Function)new LessThanOrEqFunction());
        handlers.registerFunction((Function)new MoreThanFunction());
        handlers.registerFunction((Function)new MoreThanOrEqFunction());
        handlers.registerFunction((Function)new EqFunction());
        handlers.registerFunction((Function)new SwitchFunction());
        handlers.registerFunction((Function)new ReturnFunction());
        handlers.registerFunction((Function)new RunFunction());
        handlers.registerFunction((Function)new BindFunction());
        handlers.registerFunction((Function)new NewFunction());
        handlers.registerFunction((Function)new SetFunction());
        handlers.registerFunction((Function)new GetFunction());
        handlers.registerFunction((Function)new CallFunction());
        handlers.registerFunction((Function)new AssertFunction());
        this.shell = new ClipsShell();
        this.baos = new ByteArrayOutputStream();
        this.shell.addRouter("t", new PrintStream(this.baos));
    }

    public void testBind() {
        String expr = "(bind ?x (create$ 10 20 30) ) (printout t ?x)";
        this.shell.eval(expr);
        ClipsShellTest.assertEquals((String)"[10, 20, 30]", (String)new String(this.baos.toByteArray()));
    }

    public void testProgn() {
        String expr = "(progn (?x (create$ 10 20 30) ) (printout t ?x) )";
        this.shell.eval(expr);
        ClipsShellTest.assertEquals((String)"102030", (String)new String(this.baos.toByteArray()));
    }

    public void testIf() {
        String expr = "(if (< 1 3) then (printout t hello) (printout t hello) )";
        this.shell.eval(expr);
        ClipsShellTest.assertEquals((String)"hellohello", (String)new String(this.baos.toByteArray()));
    }

    public void testIfElse() {
        String expr = "(if (eq 1 3) then (printout t hello)  (printout t 1) else (printout t hello)  (printout t 2))";
        this.shell.eval(expr);
        ClipsShellTest.assertEquals((String)"hello2", (String)new String(this.baos.toByteArray()));
    }

    public void testSwitch() throws IOException {
        String expr = "(switch (?x) (case a then (printout t hello)(printout t 1)) (case b then (printout t hello)(printout t 2)) (default (printout t hello)(printout t 3)) )";
        this.shell.addVariable("$x", (Object)"a");
        this.shell.eval(expr);
        ClipsShellTest.assertEquals((String)"hello1", (String)new String(this.baos.toByteArray()));
        this.shell.addVariable("$x", (Object)"M");
        this.shell.eval(expr);
        ClipsShellTest.assertEquals((String)"hello1hello3", (String)new String(this.baos.toByteArray()));
        this.shell.addVariable("$x", (Object)"b");
        this.shell.eval(expr);
        ClipsShellTest.assertEquals((String)"hello1hello3hello2", (String)new String(this.baos.toByteArray()));
    }

    public void testDeffunction() {
        String function = "(deffunction max (?a ?b) (if (> ?a ?b) then (return ?a) else (return ?b) ) )";
        this.shell.eval(function);
        String expr = "(if (eq (max 3 5) 5) then (printout t hello) )";
        this.shell.eval(expr);
        ClipsShellTest.assertEquals((String)"hello", (String)new String(this.baos.toByteArray()));
        expr = "(if (eq (max ?a ?b) 5) then (printout t hello) )";
        this.shell.addVariable("$a", (Object)"3");
        this.shell.addVariable("$b", (Object)"5");
        this.shell.eval(expr);
        ClipsShellTest.assertEquals((String)"hellohello", (String)new String(this.baos.toByteArray()));
    }

    public void testDirectImportAndNew() {
        String t = "(import org.drools.Person) (bind ?p (new Person mark cheddar) ) (printout t ?p)";
        this.shell.eval(t);
        ClipsShellTest.assertEquals((String)"[Person name='mark']", (String)new String(this.baos.toByteArray()));
    }

    public void testDynamicImportAndNew() {
        String t = "(import org.drools.*) (bind ?p (new Person mark cheddar) ) (printout t ?p)";
        this.shell.eval(t);
        ClipsShellTest.assertEquals((String)"[Person name='mark']", (String)new String(this.baos.toByteArray()));
    }

    public void testSet() {
        String t = "(import org.drools.*) (bind ?p (new Person mark cheddar) ) (set ?p name bob) (printout t ?p)";
        this.shell.eval(t);
        ClipsShellTest.assertEquals((String)"[Person name='bob']", (String)new String(this.baos.toByteArray()));
    }

    public void testGet() {
        String t = "(import org.drools.*) (bind ?p (new Person mark cheddar) )(printout t (get ?p name))";
        this.shell.eval(t);
        ClipsShellTest.assertEquals((String)"mark", (String)new String(this.baos.toByteArray()));
    }

    public void testExplicitCall() {
        String t = "(import org.drools.*) (bind ?p (new Person mark cheddar) ) (call ?p setFields bob stilton 35)  (printout t (call ?p toLongString))";
        this.shell.eval(t);
        ClipsShellTest.assertEquals((String)"[Person name='bob' likes='stilton' age='35']", (String)new String(this.baos.toByteArray()));
    }

    public void testImplicitCall() {
        String t = "(import org.drools.*) (bind ?p (new Person mark cheddar) ) (?p setFields bob stilton 35)  (printout t (call ?p toLongString))";
        this.shell.eval(t);
        ClipsShellTest.assertEquals((String)"[Person name='bob' likes='stilton' age='35']", (String)new String(this.baos.toByteArray()));
    }

    public void FIXME_testRuleCreation() {
        this.shell.eval("(import org.drools.Person)");
        this.shell.eval("(defrule yyy  => (printout t yy \" \" (eq 1 1) ) ) )");
        Package pkg = this.shell.getStatefulSession().getRuleBase().getPackage("MAIN");
        Rule rule = pkg.getRule("yyy");
        ClipsShellTest.assertEquals((String)"yyy", (String)rule.getName());
        this.shell.eval("(defrule xxx (Person (name ?name&bob) (age 30) ) (Person  (name ?name) (age 35)) => (printout t xx \" \" (eq 1 1) ) )");
        rule = pkg.getRule("xxx");
        ClipsShellTest.assertEquals((String)"xxx", (String)rule.getName());
        ClipsShellTest.assertEquals((int)2, (int)pkg.getRules().length);
        ClipsShellTest.assertTrue((boolean)pkg.getImports().containsKey("org.drools.Person"));
        StatefulSession wm = this.shell.getStatefulSession();
        wm.insert((Object)new Person("bob", "cheddar", 30));
        wm.insert((Object)new Person("bob", "stilton", 35));
        wm.fireAllRules();
        ClipsShellTest.assertEquals((String)"yy truexx true", (String)new String(this.baos.toByteArray()));
    }

    public void FIXME_testTemplateCreation2() throws Exception {
        this.shell.eval("(deftemplate PersonTemplate (slot name (type String) ) (slot age (type int) ) )");
        this.shell.eval("(defrule xxx (PersonTemplate (name ?name&bob) (age 30) ) (PersonTemplate  (name ?name) (age 35)) => (printout t xx \" \" (eq 1 1) ) )");
        this.shell.eval("(assert (PersonTemplate (name 'mike') (age 34)))");
        Class personClass = ((InternalRuleBase)this.shell.getStatefulSession().getRuleBase()).getRootClassLoader().loadClass("MAIN.PersonTemplate");
        ClipsShellTest.assertNotNull((Object)personClass);
    }

    public void FIXME_testTemplateCreation() throws Exception {
        this.shell.eval("(deftemplate Person (slot name (type String) ) (slot age (type int) ) )");
        this.shell.eval("(defrule xxx (Person (name ?name&bob) (age 30) ) => (printout t hello bob ) )");
        this.shell.eval("(assert (Person (name bob) (age 30) ) )");
        this.shell.eval("(run)");
        ClipsShellTest.assertEquals((String)"hellobob", (String)new String(this.baos.toByteArray()));
    }

    public void FIXME_testTemplateCreationWithJava() throws Exception {
        this.shell.eval("(deftemplate Person (slot name (type String) ) (slot age (type int) ) )");
        this.shell.eval("(defrule yyy  => (printout t yy \" \" (eq 1 1) ) ) )");
        Package pkg = this.shell.getStatefulSession().getRuleBase().getPackage("MAIN");
        Rule rule = pkg.getRule("yyy");
        ClipsShellTest.assertEquals((String)"yyy", (String)rule.getName());
        this.shell.eval("(defrule xxx (Person (name ?name&bob) (age 30) ) (Person  (name ?name) (age 35)) => (printout t xx \" \" (eq 1 1) ) )");
        rule = pkg.getRule("xxx");
        ClipsShellTest.assertEquals((String)"xxx", (String)rule.getName());
        ClipsShellTest.assertEquals((int)2, (int)pkg.getRules().length);
        StatefulSession wm = this.shell.getStatefulSession();
        Class personClass = ((InternalRuleBase)this.shell.getStatefulSession().getRuleBase()).getRootClassLoader().loadClass("MAIN.Person");
        Method nameMethod = personClass.getMethod("setName", String.class);
        Method ageMethod = personClass.getMethod("setAge", Integer.TYPE);
        Object bob1 = personClass.newInstance();
        nameMethod.invoke(bob1, "bob");
        ageMethod.invoke(bob1, 30);
        Object bob2 = personClass.newInstance();
        nameMethod.invoke(bob2, "bob");
        ageMethod.invoke(bob2, 35);
        wm.insert(bob1);
        wm.insert(bob2);
        wm.fireAllRules();
        ClipsShellTest.assertEquals((String)"yy truexx true", (String)new String(this.baos.toByteArray()));
    }

    public void FIXME_testEmptyLHSRule() {
        String rule1 = "(defrule testRule => (printout t hello) (printout t goodbye))";
        this.shell.eval(rule1);
        ClipsShellTest.assertEquals((String)"hellogoodbye", (String)new String(this.baos.toByteArray()));
    }

    public void FIXME_testSimpleLHSRule() {
        this.shell.eval("(import org.drools.*)");
        this.shell.eval("(defrule testRule (Person (name ?name&mark) ) => (printout t hello) (printout t \" \" ?name))");
        this.shell.eval("(assert (Person (name mark) ) )");
        this.shell.eval("(run)");
        ClipsShellTest.assertEquals((String)"hello mark", (String)new String(this.baos.toByteArray()));
    }

    public void FIXME_testRuleCallDeftemplate() {
        String function = "(deffunction max (?a ?b) (if (> ?a ?b) then (return ?a) else (return ?b) ) )";
        this.shell.eval(function);
        this.shell.eval("(import org.drools.*)");
        this.shell.eval("(defrule testRule (Person (age ?age) ) => (printout t hello) (printout t \" \" (max 3 ?age) ) )");
        this.shell.eval("(assert (Person (name mark) (age 32) ) )");
        this.shell.eval("(run)");
        ClipsShellTest.assertEquals((String)"hello 32", (String)new String(this.baos.toByteArray()));
    }

    public void FIXME_testTwoSimpleRulesWithModify() {
        this.shell.eval("(import org.drools.*)");
        this.shell.eval("(defrule testRule1 ?p <- (Person (name ?name&mark) ) => (printout t hello) (printout t \" \" ?name) (modify ?p (name bob) ) )");
        this.shell.eval("(defrule testRule2 (Person (name ?name&bob) ) => (printout t hello) (printout t \" \" ?name))");
        this.shell.eval("(assert (Person (name mark) ) )");
        this.shell.eval("(run)");
        ClipsShellTest.assertEquals((String)"hello markhello bob", (String)new String(this.baos.toByteArray()));
    }

    public void FIXME_testBlockEval() {
        String text = "(import org.drools.*)";
        text = text + "(defrule testRule1 ?p <- (Person (name ?name&mark) ) => (printout t hello) (printout t \" \" ?name) (modify ?p (name bob) ) )";
        text = text + "(defrule testRule2 (Person (name ?name&bob) ) => (printout t hello) (printout t \" \" ?name))";
        text = text + "(assert (Person (name mark) ) )";
        text = text + "(run)";
        this.shell.eval(text);
        ClipsShellTest.assertEquals((String)"hello markhello bob", (String)new String(this.baos.toByteArray()));
    }

    public void FIXME_testPredicate() {
        this.shell.eval("(import org.drools.Person)");
        this.shell.eval("(defrule testRule1 (Person (name ?name) (age ?age&:(> ?age 30)) ) => (printout t hello) (printout t \" \" ?name) )");
        this.shell.eval("(assert (Person (name mark) (age 27) ) )");
        this.shell.eval("(assert (Person (name bob) (age 35) ) )");
        this.shell.eval("(run)");
        ClipsShellTest.assertEquals((String)"hello bob", (String)new String(this.baos.toByteArray()));
    }

    public void FIXME_testReturnValue() {
        this.shell.eval("(import org.drools.Person)");
        this.shell.eval("(defrule testRule1 (Person (age ?age) ) (Person (name ?name) (age =(- ?age 3)) ) => (printout t hello) (printout t \" \" ?name) )");
        this.shell.eval("(assert (Person (name mark) (age 32) ) )");
        this.shell.eval("(assert (Person (name bob) (age 35) ) )");
        this.shell.eval("(run)");
        ClipsShellTest.assertEquals((String)"hello mark", (String)new String(this.baos.toByteArray()));
    }

    public void FIXME_testTest() {
        this.shell.eval("(import org.drools.Person)");
        this.shell.eval("(defrule testRule1 (Person (age ?age1) ) (Person (name ?name) (age ?age2) ) (test(eq ?age1 (+ ?age2 3) )) => (printout t hello) )");
        this.shell.eval("(assert (Person (name mark) (age 32) ) )");
        this.shell.eval("(assert (Person (name bob) (age 35) ) )");
        this.shell.eval("(run)");
        ClipsShellTest.assertEquals((String)"hello", (String)new String(this.baos.toByteArray()));
    }

    public void testRun() {
        this.shell.eval("(run)");
    }

    public void FIXME_testMixed() {
        this.shell.eval("(import org.drools.Cheese)");
        String str = "";
        str = str + "(deftemplate Person ";
        str = str + "  (slot name ";
        str = str + "    (type String) ) ";
        str = str + "  (slot age";
        str = str + "    (type String) ) ";
        str = str + "  (slot location";
        str = str + "    (type String) ) ";
        str = str + "  (slot cheese";
        str = str + "    (type String) ) ";
        str = str + ")";
        this.shell.eval(str);
        this.shell.eval("(deffunction max (?a ?b) (if (> ?a ?b) then (return ?a) else (return ?b) ) )");
        str = "";
        str = str + "(defrule sendsomecheese ";
        str = str + "  (Person (name ?name) (age ?personAge) (cheese ?cheeseType) (location \"london\") ) ";
        str = str + "  (Cheese (type ?cheeseType) (price ?cheesePrice&:(eq (max ?personAge ?cheesePrice) ?cheesePrice)  ) )";
        str = str + "\n=>\n";
        str = str + "  (printout t \"send some \" ?cheeseType \" \" to \" \" ?name) ";
        str = str + ")";
        this.shell.eval(str);
        this.shell.eval("(assert (Person (name mark) (location \"london\") (cheese \"cheddar\") (age 25) ) )");
        this.shell.eval("(assert (Cheese (type \"cheddar\") (price  30) ) ) ");
        this.shell.eval("(run)");
        ClipsShellTest.assertEquals((String)"send some cheddar to mark", (String)new String(this.baos.toByteArray()));
    }
}

