/*
 * Decompiled with CFR 0.152.
 */
package org.drools.clips;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.drools.clips.ClipsLexer;
import org.drools.clips.ClipsParser;
import org.drools.clips.LispForm;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.RestrictionConnectiveDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.RuleDescr;

public class LhsClpParserTest
extends TestCase {
    private ClipsParser parser;

    public void setUp() {
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testParseFunction() throws Exception {
    }

    public void testPatternsRule() throws Exception {
        RuleDescr rule = this.parse("(defrule xxx ?b <- (person (name \"yyy\"&?bf|~\"zzz\"|~=(+ 2 3)&:(< 1 2)) ) ?c <- (hobby (type ?bf2&~iii) (rating fivestar) ) => )").defrule();
        LhsClpParserTest.assertEquals((String)"xxx", (String)rule.getName());
        AndDescr lhs = rule.getLhs();
        List lhsList = lhs.getDescrs();
        LhsClpParserTest.assertEquals((int)2, (int)lhsList.size());
        PatternDescr personPattern = (PatternDescr)lhsList.get(0);
        LhsClpParserTest.assertEquals((String)"$b", (String)personPattern.getIdentifier());
        LhsClpParserTest.assertEquals((String)"person", (String)personPattern.getObjectType());
        List colList = personPattern.getDescrs();
        LhsClpParserTest.assertEquals((int)3, (int)colList.size());
        FieldBindingDescr fbd = (FieldBindingDescr)colList.get(0);
        LhsClpParserTest.assertEquals((String)"$bf", (String)fbd.getIdentifier());
        LhsClpParserTest.assertEquals((String)"name", (String)fbd.getFieldName());
        FieldConstraintDescr fieldConstraintDescr = (FieldConstraintDescr)colList.get(1);
        LhsClpParserTest.assertEquals((String)"name", (String)fieldConstraintDescr.getFieldName());
        RestrictionConnectiveDescr root = fieldConstraintDescr.getRestriction();
        LhsClpParserTest.assertEquals((int)1, (int)root.getRestrictions().size());
        RestrictionConnectiveDescr or = (RestrictionConnectiveDescr)root.getRestrictions().get(0);
        LhsClpParserTest.assertEquals((Object)RestrictionConnectiveDescr.OR, (Object)or.getConnective());
        List restrictionList = or.getRestrictions();
        LhsClpParserTest.assertEquals((int)3, (int)restrictionList.size());
        LiteralRestrictionDescr litDescr = (LiteralRestrictionDescr)restrictionList.get(0);
        LhsClpParserTest.assertEquals((String)"==", (String)litDescr.getEvaluator());
        LhsClpParserTest.assertEquals((String)"yyy", (String)litDescr.getText());
        litDescr = (LiteralRestrictionDescr)restrictionList.get(1);
        LhsClpParserTest.assertEquals((String)"!=", (String)litDescr.getEvaluator());
        LhsClpParserTest.assertEquals((String)"zzz", (String)litDescr.getText());
        ReturnValueRestrictionDescr retDescr = (ReturnValueRestrictionDescr)restrictionList.get(2);
        LhsClpParserTest.assertEquals((String)"!=", (String)retDescr.getEvaluator());
        LispForm lispForm = (LispForm)retDescr.getContent();
        LhsClpParserTest.assertEquals((String)"(+ 2 3)", (String)lispForm.toString());
        PredicateDescr predicateDescr = (PredicateDescr)colList.get(2);
        lispForm = (LispForm)predicateDescr.getContent();
        LhsClpParserTest.assertEquals((String)"(< 1 2)", (String)lispForm.toString());
        PatternDescr hobbyPattern = (PatternDescr)lhsList.get(1);
        LhsClpParserTest.assertEquals((String)"$c", (String)hobbyPattern.getIdentifier());
        LhsClpParserTest.assertEquals((String)"hobby", (String)hobbyPattern.getObjectType());
        colList = hobbyPattern.getDescrs();
        LhsClpParserTest.assertEquals((int)3, (int)colList.size());
        fbd = (FieldBindingDescr)colList.get(0);
        LhsClpParserTest.assertEquals((String)"$bf2", (String)fbd.getIdentifier());
        LhsClpParserTest.assertEquals((String)"type", (String)fbd.getFieldName());
        fieldConstraintDescr = (FieldConstraintDescr)colList.get(1);
        restrictionList = fieldConstraintDescr.getRestrictions();
        LhsClpParserTest.assertEquals((String)"type", (String)fieldConstraintDescr.getFieldName());
        LhsClpParserTest.assertEquals((Object)RestrictionConnectiveDescr.AND, (Object)fieldConstraintDescr.getRestriction().getConnective());
        litDescr = (LiteralRestrictionDescr)restrictionList.get(0);
        LhsClpParserTest.assertEquals((String)"!=", (String)litDescr.getEvaluator());
        LhsClpParserTest.assertEquals((String)"iii", (String)litDescr.getText());
        fieldConstraintDescr = (FieldConstraintDescr)colList.get(2);
        restrictionList = fieldConstraintDescr.getRestrictions();
        LhsClpParserTest.assertEquals((String)"rating", (String)fieldConstraintDescr.getFieldName());
        litDescr = (LiteralRestrictionDescr)restrictionList.get(0);
        LhsClpParserTest.assertEquals((String)"==", (String)litDescr.getEvaluator());
        LhsClpParserTest.assertEquals((String)"fivestar", (String)litDescr.getText());
    }

    public void testNestedCERule() throws Exception {
        RuleDescr rule = this.parse("(defrule xxx ?b <- (person (name yyy)) (or (and (hobby1 (type qqq1)) (hobby2 (type ~qqq2))) (food (veg ~shroom) ) ) => )").defrule();
        LhsClpParserTest.assertEquals((String)"xxx", (String)rule.getName());
        AndDescr lhs = rule.getLhs();
        List lhsList = lhs.getDescrs();
        LhsClpParserTest.assertEquals((int)2, (int)lhsList.size());
        PatternDescr col = (PatternDescr)lhsList.get(0);
        LhsClpParserTest.assertEquals((String)"$b", (String)col.getIdentifier());
        LhsClpParserTest.assertEquals((String)"person", (String)col.getObjectType());
        FieldConstraintDescr fieldConstraintDescr = (FieldConstraintDescr)col.getDescrs().get(0);
        LhsClpParserTest.assertEquals((String)"name", (String)fieldConstraintDescr.getFieldName());
        LiteralRestrictionDescr litDescr = (LiteralRestrictionDescr)fieldConstraintDescr.getRestrictions().get(0);
        LhsClpParserTest.assertEquals((String)"==", (String)litDescr.getEvaluator());
        LhsClpParserTest.assertEquals((String)"yyy", (String)litDescr.getText());
        OrDescr orDescr = (OrDescr)lhsList.get(1);
        LhsClpParserTest.assertEquals((int)2, (int)orDescr.getDescrs().size());
        AndDescr andDescr = (AndDescr)orDescr.getDescrs().get(0);
        col = (PatternDescr)andDescr.getDescrs().get(0);
        LhsClpParserTest.assertEquals((String)"hobby1", (String)col.getObjectType());
        fieldConstraintDescr = (FieldConstraintDescr)col.getDescrs().get(0);
        LhsClpParserTest.assertEquals((String)"type", (String)fieldConstraintDescr.getFieldName());
        litDescr = (LiteralRestrictionDescr)fieldConstraintDescr.getRestrictions().get(0);
        LhsClpParserTest.assertEquals((String)"==", (String)litDescr.getEvaluator());
        LhsClpParserTest.assertEquals((String)"qqq1", (String)litDescr.getText());
        col = (PatternDescr)andDescr.getDescrs().get(1);
        LhsClpParserTest.assertEquals((String)"hobby2", (String)col.getObjectType());
        fieldConstraintDescr = (FieldConstraintDescr)col.getDescrs().get(0);
        LhsClpParserTest.assertEquals((String)"type", (String)fieldConstraintDescr.getFieldName());
        litDescr = (LiteralRestrictionDescr)fieldConstraintDescr.getRestrictions().get(0);
        LhsClpParserTest.assertEquals((String)"!=", (String)litDescr.getEvaluator());
        LhsClpParserTest.assertEquals((String)"qqq2", (String)litDescr.getText());
        col = (PatternDescr)orDescr.getDescrs().get(1);
        LhsClpParserTest.assertEquals((String)"food", (String)col.getObjectType());
        fieldConstraintDescr = (FieldConstraintDescr)col.getDescrs().get(0);
        LhsClpParserTest.assertEquals((String)"veg", (String)fieldConstraintDescr.getFieldName());
        litDescr = (LiteralRestrictionDescr)fieldConstraintDescr.getRestrictions().get(0);
        LhsClpParserTest.assertEquals((String)"!=", (String)litDescr.getEvaluator());
        LhsClpParserTest.assertEquals((String)"shroom", (String)litDescr.getText());
    }

    public void testNotExistsRule() throws Exception {
        RuleDescr rule = this.parse("(defrule xxx (or (hobby1 (type qqq1)) (not (and (exists (person (name ppp))) (person (name yyy))))) => )").defrule();
        LhsClpParserTest.assertEquals((String)"xxx", (String)rule.getName());
        AndDescr lhs = rule.getLhs();
        List lhsList = lhs.getDescrs();
        LhsClpParserTest.assertEquals((int)1, (int)lhsList.size());
        OrDescr orDescr = (OrDescr)lhsList.get(0);
        LhsClpParserTest.assertEquals((int)2, (int)orDescr.getDescrs().size());
        PatternDescr col = (PatternDescr)orDescr.getDescrs().get(0);
        LhsClpParserTest.assertEquals((String)"hobby1", (String)col.getObjectType());
        FieldConstraintDescr fieldConstraintDescr = (FieldConstraintDescr)col.getDescrs().get(0);
        LhsClpParserTest.assertEquals((String)"type", (String)fieldConstraintDescr.getFieldName());
        LiteralRestrictionDescr litDescr = (LiteralRestrictionDescr)fieldConstraintDescr.getRestrictions().get(0);
        LhsClpParserTest.assertEquals((String)"==", (String)litDescr.getEvaluator());
        LhsClpParserTest.assertEquals((String)"qqq1", (String)litDescr.getText());
        NotDescr notDescr = (NotDescr)orDescr.getDescrs().get(1);
        LhsClpParserTest.assertEquals((int)1, (int)notDescr.getDescrs().size());
        AndDescr andDescr = (AndDescr)notDescr.getDescrs().get(0);
        LhsClpParserTest.assertEquals((int)2, (int)andDescr.getDescrs().size());
        ExistsDescr existsDescr = (ExistsDescr)andDescr.getDescrs().get(0);
        col = (PatternDescr)existsDescr.getDescrs().get(0);
        LhsClpParserTest.assertEquals((String)"person", (String)col.getObjectType());
        fieldConstraintDescr = (FieldConstraintDescr)col.getDescrs().get(0);
        LhsClpParserTest.assertEquals((String)"name", (String)fieldConstraintDescr.getFieldName());
        litDescr = (LiteralRestrictionDescr)fieldConstraintDescr.getRestrictions().get(0);
        LhsClpParserTest.assertEquals((String)"==", (String)litDescr.getEvaluator());
        LhsClpParserTest.assertEquals((String)"ppp", (String)litDescr.getText());
        col = (PatternDescr)andDescr.getDescrs().get(1);
        LhsClpParserTest.assertEquals((String)"person", (String)col.getObjectType());
        fieldConstraintDescr = (FieldConstraintDescr)col.getDescrs().get(0);
        LhsClpParserTest.assertEquals((String)"name", (String)fieldConstraintDescr.getFieldName());
        litDescr = (LiteralRestrictionDescr)fieldConstraintDescr.getRestrictions().get(0);
        LhsClpParserTest.assertEquals((String)"==", (String)litDescr.getEvaluator());
        LhsClpParserTest.assertEquals((String)"yyy", (String)litDescr.getText());
    }

    public void testTestRule() throws Exception {
        RuleDescr rule = this.parse("(defrule xxx (test (< 9.0 1.3) ) => )").defrule();
        LhsClpParserTest.assertEquals((String)"xxx", (String)rule.getName());
        AndDescr lhs = rule.getLhs();
        List lhsList = lhs.getDescrs();
        LhsClpParserTest.assertEquals((int)1, (int)lhsList.size());
        EvalDescr evalDescr = (EvalDescr)lhsList.get(0);
        LispForm lispForm = (LispForm)evalDescr.getContent();
        LhsClpParserTest.assertEquals((String)"(< 9.0 1.3)", (String)lispForm.toString());
    }

    public void testRuleHeader() throws Exception {
        RuleDescr rule = this.parse("(defrule MAIN::name \"docs\"(declare (salience -100) ) => )").defrule();
        Map attributes = rule.getAttributes();
        AttributeDescr module = (AttributeDescr)attributes.get("agenda-group");
        LhsClpParserTest.assertEquals((String)"agenda-group", (String)module.getName());
        LhsClpParserTest.assertEquals((String)"MAIN", (String)module.getValue());
        LhsClpParserTest.assertEquals((String)"name", (String)rule.getName());
        AttributeDescr dialect = (AttributeDescr)attributes.get("dialect");
        LhsClpParserTest.assertEquals((String)"dialect", (String)dialect.getName());
        LhsClpParserTest.assertEquals((String)"clips", (String)dialect.getValue());
        AttributeDescr salience = (AttributeDescr)attributes.get("salience");
        LhsClpParserTest.assertEquals((String)"salience", (String)salience.getName());
        LhsClpParserTest.assertEquals((String)"-100", (String)salience.getValue());
    }

    private ClipsParser parse(String text) throws Exception {
        return new ClipsParser((TokenStream)new CommonTokenStream((TokenSource)new ClipsLexer((CharStream)new ANTLRStringStream(text))));
    }

    private ClipsParser parse(String source, String text) throws Exception {
        this.parser = new ClipsParser((TokenStream)new CommonTokenStream((TokenSource)new ClipsLexer((CharStream)new ANTLRStringStream(text))));
        this.parser.setSource(source);
        return this.parser;
    }

    private Reader getReader(String name) throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        return new InputStreamReader(in);
    }

    private ClipsParser parseResource(String name) throws Exception {
        Reader reader = this.getReader(name);
        StringBuffer text = new StringBuffer();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return this.parse(name, text.toString());
    }

    private CharStream newCharStream(String text) {
        return new ANTLRStringStream(text);
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        LhsClpParserTest.assertEquals((String)cleanExpected, (String)cleanActual);
    }
}

