/*
 * Decompiled with CFR 0.152.
 */
package org.drools.clips;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.drools.clips.ClipsLexer;
import org.drools.clips.ClipsParser;
import org.drools.clips.LispForm;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BindingDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.RestrictionConnectiveDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.RuleDescr;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class LhsClpParserTest {
    private ClipsParser parser;

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    @Ignore
    public void testPatternsRule() throws Exception {
        RuleDescr rule = this.parse("(defrule xxx ?b <- (person (name \"yyy\"&?bf|~\"zzz\"|~=(+ 2 3)&:(< 1 2)) ) ?c <- (hobby (type ?bf2&~iii) (rating fivestar) ) => )").defrule();
        Assert.assertEquals((Object)"xxx", (Object)rule.getName());
        AndDescr lhs = rule.getLhs();
        List lhsList = lhs.getDescrs();
        Assert.assertEquals((long)2L, (long)lhsList.size());
        PatternDescr personPattern = (PatternDescr)lhsList.get(0);
        Assert.assertEquals((Object)"$b", (Object)personPattern.getIdentifier());
        Assert.assertEquals((Object)"person", (Object)personPattern.getObjectType());
        List colList = personPattern.getDescrs();
        Assert.assertEquals((long)3L, (long)colList.size());
        BindingDescr fbd = (BindingDescr)colList.get(0);
        Assert.assertEquals((Object)"$bf", (Object)fbd.getVariable());
        Assert.assertEquals((Object)"name", (Object)fbd.getExpression());
        FieldConstraintDescr fieldConstraintDescr = (FieldConstraintDescr)colList.get(1);
        Assert.assertEquals((Object)"name", (Object)fieldConstraintDescr.getFieldName());
        RestrictionConnectiveDescr root = fieldConstraintDescr.getRestriction();
        Assert.assertEquals((long)1L, (long)root.getRestrictions().size());
        RestrictionConnectiveDescr or = (RestrictionConnectiveDescr)root.getRestrictions().get(0);
        Assert.assertEquals((Object)RestrictionConnectiveDescr.OR, (Object)or.getConnective());
        List restrictionList = or.getRestrictions();
        Assert.assertEquals((long)3L, (long)restrictionList.size());
        LiteralRestrictionDescr litDescr = (LiteralRestrictionDescr)restrictionList.get(0);
        Assert.assertEquals((Object)"==", (Object)litDescr.getEvaluator());
        Assert.assertEquals((Object)"yyy", (Object)litDescr.getText());
        litDescr = (LiteralRestrictionDescr)restrictionList.get(1);
        Assert.assertEquals((Object)"!=", (Object)litDescr.getEvaluator());
        Assert.assertEquals((Object)"zzz", (Object)litDescr.getText());
        ReturnValueRestrictionDescr retDescr = (ReturnValueRestrictionDescr)restrictionList.get(2);
        Assert.assertEquals((Object)"!=", (Object)retDescr.getEvaluator());
        LispForm lispForm = (LispForm)retDescr.getContent();
        Assert.assertEquals((Object)"(+ 2 3)", (Object)lispForm.toString());
        PredicateDescr predicateDescr = (PredicateDescr)colList.get(2);
        lispForm = (LispForm)predicateDescr.getContent();
        Assert.assertEquals((Object)"(< 1 2)", (Object)lispForm.toString());
        PatternDescr hobbyPattern = (PatternDescr)lhsList.get(1);
        Assert.assertEquals((Object)"$c", (Object)hobbyPattern.getIdentifier());
        Assert.assertEquals((Object)"hobby", (Object)hobbyPattern.getObjectType());
        colList = hobbyPattern.getDescrs();
        Assert.assertEquals((long)3L, (long)colList.size());
        fbd = (BindingDescr)colList.get(0);
        Assert.assertEquals((Object)"$bf2", (Object)fbd.getVariable());
        Assert.assertEquals((Object)"type", (Object)fbd.getExpression());
        fieldConstraintDescr = (FieldConstraintDescr)colList.get(1);
        restrictionList = fieldConstraintDescr.getRestrictions();
        Assert.assertEquals((Object)"type", (Object)fieldConstraintDescr.getFieldName());
        Assert.assertEquals((Object)RestrictionConnectiveDescr.AND, (Object)fieldConstraintDescr.getRestriction().getConnective());
        litDescr = (LiteralRestrictionDescr)restrictionList.get(0);
        Assert.assertEquals((Object)"!=", (Object)litDescr.getEvaluator());
        Assert.assertEquals((Object)"iii", (Object)litDescr.getText());
        fieldConstraintDescr = (FieldConstraintDescr)colList.get(2);
        restrictionList = fieldConstraintDescr.getRestrictions();
        Assert.assertEquals((Object)"rating", (Object)fieldConstraintDescr.getFieldName());
        litDescr = (LiteralRestrictionDescr)restrictionList.get(0);
        Assert.assertEquals((Object)"==", (Object)litDescr.getEvaluator());
        Assert.assertEquals((Object)"fivestar", (Object)litDescr.getText());
    }

    @Test
    public void testNestedCERule() throws Exception {
        RuleDescr rule = this.parse("(defrule xxx ?b <- (person (name yyy)) (or (and (hobby1 (type qqq1)) (hobby2 (type ~qqq2))) (food (veg ~shroom) ) ) => )").defrule();
        Assert.assertEquals((Object)"xxx", (Object)rule.getName());
        AndDescr lhs = rule.getLhs();
        List lhsList = lhs.getDescrs();
        Assert.assertEquals((long)2L, (long)lhsList.size());
        PatternDescr col = (PatternDescr)lhsList.get(0);
        Assert.assertEquals((Object)"$b", (Object)col.getIdentifier());
        Assert.assertEquals((Object)"person", (Object)col.getObjectType());
        FieldConstraintDescr fieldConstraintDescr = (FieldConstraintDescr)col.getDescrs().get(0);
        Assert.assertEquals((Object)"name", (Object)fieldConstraintDescr.getFieldName());
        LiteralRestrictionDescr litDescr = (LiteralRestrictionDescr)fieldConstraintDescr.getRestrictions().get(0);
        Assert.assertEquals((Object)"==", (Object)litDescr.getEvaluator());
        Assert.assertEquals((Object)"yyy", (Object)litDescr.getText());
        OrDescr orDescr = (OrDescr)lhsList.get(1);
        Assert.assertEquals((long)2L, (long)orDescr.getDescrs().size());
        AndDescr andDescr = (AndDescr)orDescr.getDescrs().get(0);
        col = (PatternDescr)andDescr.getDescrs().get(0);
        Assert.assertEquals((Object)"hobby1", (Object)col.getObjectType());
        fieldConstraintDescr = (FieldConstraintDescr)col.getDescrs().get(0);
        Assert.assertEquals((Object)"type", (Object)fieldConstraintDescr.getFieldName());
        litDescr = (LiteralRestrictionDescr)fieldConstraintDescr.getRestrictions().get(0);
        Assert.assertEquals((Object)"==", (Object)litDescr.getEvaluator());
        Assert.assertEquals((Object)"qqq1", (Object)litDescr.getText());
        col = (PatternDescr)andDescr.getDescrs().get(1);
        Assert.assertEquals((Object)"hobby2", (Object)col.getObjectType());
        fieldConstraintDescr = (FieldConstraintDescr)col.getDescrs().get(0);
        Assert.assertEquals((Object)"type", (Object)fieldConstraintDescr.getFieldName());
        litDescr = (LiteralRestrictionDescr)fieldConstraintDescr.getRestrictions().get(0);
        Assert.assertEquals((Object)"!=", (Object)litDescr.getEvaluator());
        Assert.assertEquals((Object)"qqq2", (Object)litDescr.getText());
        col = (PatternDescr)orDescr.getDescrs().get(1);
        Assert.assertEquals((Object)"food", (Object)col.getObjectType());
        fieldConstraintDescr = (FieldConstraintDescr)col.getDescrs().get(0);
        Assert.assertEquals((Object)"veg", (Object)fieldConstraintDescr.getFieldName());
        litDescr = (LiteralRestrictionDescr)fieldConstraintDescr.getRestrictions().get(0);
        Assert.assertEquals((Object)"!=", (Object)litDescr.getEvaluator());
        Assert.assertEquals((Object)"shroom", (Object)litDescr.getText());
    }

    @Test
    public void testNotExistsRule() throws Exception {
        RuleDescr rule = this.parse("(defrule xxx (or (hobby1 (type qqq1)) (not (and (exists (person (name ppp))) (person (name yyy))))) => )").defrule();
        Assert.assertEquals((Object)"xxx", (Object)rule.getName());
        AndDescr lhs = rule.getLhs();
        List lhsList = lhs.getDescrs();
        Assert.assertEquals((long)1L, (long)lhsList.size());
        OrDescr orDescr = (OrDescr)lhsList.get(0);
        Assert.assertEquals((long)2L, (long)orDescr.getDescrs().size());
        PatternDescr col = (PatternDescr)orDescr.getDescrs().get(0);
        Assert.assertEquals((Object)"hobby1", (Object)col.getObjectType());
        FieldConstraintDescr fieldConstraintDescr = (FieldConstraintDescr)col.getDescrs().get(0);
        Assert.assertEquals((Object)"type", (Object)fieldConstraintDescr.getFieldName());
        LiteralRestrictionDescr litDescr = (LiteralRestrictionDescr)fieldConstraintDescr.getRestrictions().get(0);
        Assert.assertEquals((Object)"==", (Object)litDescr.getEvaluator());
        Assert.assertEquals((Object)"qqq1", (Object)litDescr.getText());
        NotDescr notDescr = (NotDescr)orDescr.getDescrs().get(1);
        Assert.assertEquals((long)1L, (long)notDescr.getDescrs().size());
        AndDescr andDescr = (AndDescr)notDescr.getDescrs().get(0);
        Assert.assertEquals((long)2L, (long)andDescr.getDescrs().size());
        ExistsDescr existsDescr = (ExistsDescr)andDescr.getDescrs().get(0);
        col = (PatternDescr)existsDescr.getDescrs().get(0);
        Assert.assertEquals((Object)"person", (Object)col.getObjectType());
        fieldConstraintDescr = (FieldConstraintDescr)col.getDescrs().get(0);
        Assert.assertEquals((Object)"name", (Object)fieldConstraintDescr.getFieldName());
        litDescr = (LiteralRestrictionDescr)fieldConstraintDescr.getRestrictions().get(0);
        Assert.assertEquals((Object)"==", (Object)litDescr.getEvaluator());
        Assert.assertEquals((Object)"ppp", (Object)litDescr.getText());
        col = (PatternDescr)andDescr.getDescrs().get(1);
        Assert.assertEquals((Object)"person", (Object)col.getObjectType());
        fieldConstraintDescr = (FieldConstraintDescr)col.getDescrs().get(0);
        Assert.assertEquals((Object)"name", (Object)fieldConstraintDescr.getFieldName());
        litDescr = (LiteralRestrictionDescr)fieldConstraintDescr.getRestrictions().get(0);
        Assert.assertEquals((Object)"==", (Object)litDescr.getEvaluator());
        Assert.assertEquals((Object)"yyy", (Object)litDescr.getText());
    }

    @Test
    public void testTestRule() throws Exception {
        RuleDescr rule = this.parse("(defrule xxx (test (< 9.0 1.3) ) => )").defrule();
        Assert.assertEquals((Object)"xxx", (Object)rule.getName());
        AndDescr lhs = rule.getLhs();
        List lhsList = lhs.getDescrs();
        Assert.assertEquals((long)1L, (long)lhsList.size());
        EvalDescr evalDescr = (EvalDescr)lhsList.get(0);
        LispForm lispForm = (LispForm)evalDescr.getContent();
        Assert.assertEquals((Object)"(< 9.0 1.3)", (Object)lispForm.toString());
    }

    @Test
    public void testRuleHeader() throws Exception {
        RuleDescr rule = this.parse("(defrule MAIN::name \"docs\"(declare (salience -100) ) => )").defrule();
        Map attributes = rule.getAttributes();
        AttributeDescr module = (AttributeDescr)attributes.get("agenda-group");
        Assert.assertEquals((Object)"agenda-group", (Object)module.getName());
        Assert.assertEquals((Object)"MAIN", (Object)module.getValue());
        Assert.assertEquals((Object)"name", (Object)rule.getName());
        AttributeDescr dialect = (AttributeDescr)attributes.get("dialect");
        Assert.assertEquals((Object)"dialect", (Object)dialect.getName());
        Assert.assertEquals((Object)"clips", (Object)dialect.getValue());
        AttributeDescr salience = (AttributeDescr)attributes.get("salience");
        Assert.assertEquals((Object)"salience", (Object)salience.getName());
        Assert.assertEquals((Object)"-100", (Object)salience.getValue());
    }

    private ClipsParser parse(String text) throws Exception {
        return new ClipsParser((TokenStream)new CommonTokenStream((TokenSource)new ClipsLexer((CharStream)new ANTLRStringStream(text))));
    }

    private ClipsParser parse(String source, String text) throws Exception {
        this.parser = new ClipsParser((TokenStream)new CommonTokenStream((TokenSource)new ClipsLexer((CharStream)new ANTLRStringStream(text))));
        this.parser.setSource(source);
        return this.parser;
    }

    private Reader getReader(String name) throws Exception {
        InputStream in = this.getClass().getResourceAsStream(name);
        return new InputStreamReader(in);
    }

    private ClipsParser parseResource(String name) throws Exception {
        Reader reader = this.getReader(name);
        StringBuffer text = new StringBuffer();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return this.parse(name, text.toString());
    }

    private CharStream newCharStream(String text) {
        return new ANTLRStringStream(text);
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        Assert.assertEquals((Object)cleanExpected, (Object)cleanActual);
    }
}

