/*
 * Decompiled with CFR 0.152.
 */
package org.drools.codegen.common;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import org.drools.codegen.common.AppPaths;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

@Execution(value=ExecutionMode.SAME_THREAD)
class AppPathsTest {
    AppPathsTest() {
    }

    @ParameterizedTest
    @EnumSource(value=AppPaths.BuildTool.class, names={"GRADLE", "MAVEN"})
    void fromProjectDir(AppPaths.BuildTool bt) {
        boolean withGradle;
        String projectDirPath = "projectDir";
        Path projectDir = Path.of(projectDirPath, new String[0]);
        String generatedResourceDir = switch (bt) {
            case AppPaths.BuildTool.GRADLE -> {
                withGradle = true;
                yield "generated/resources";
            }
            default -> {
                withGradle = false;
                yield "generated-resources";
            }
        };
        String outputTargetPath = bt.OUTPUT_DIRECTORY;
        AppPaths retrieved = AppPaths.fromProjectDir((Path)projectDir, (AppPaths.BuildTool)bt);
        this.getPathsTest(retrieved, projectDirPath, withGradle, false);
        this.getFirstProjectPathTest(retrieved, projectDirPath);
        this.getResourceFilesTest(retrieved, projectDirPath, outputTargetPath, generatedResourceDir, false);
        this.getResourcePathsTest(retrieved, projectDirPath, withGradle, false);
        this.getSourcePathsTest(retrieved, projectDirPath);
        this.getClassesPathsTest(retrieved);
        this.getOutputTargetTest(retrieved, outputTargetPath);
    }

    @ParameterizedTest
    @EnumSource(value=AppPaths.BuildTool.class, names={"GRADLE", "MAVEN"})
    void fromTestDir(AppPaths.BuildTool bt) {
        boolean withGradle;
        String projectDirPath = "projectDir";
        Path projectDir = Path.of(projectDirPath, new String[0]);
        String generatedResourceDir = switch (bt) {
            case AppPaths.BuildTool.GRADLE -> {
                withGradle = true;
                yield "generated/test/resources";
            }
            default -> {
                withGradle = false;
                yield "generated-test-resources";
            }
        };
        String outputTargetPath = bt.OUTPUT_DIRECTORY;
        AppPaths retrieved = AppPaths.fromTestDir((Path)projectDir, (AppPaths.BuildTool)bt);
        this.getPathsTest(retrieved, projectDirPath, withGradle, true);
        this.getFirstProjectPathTest(retrieved, projectDirPath);
        this.getResourceFilesTest(retrieved, projectDirPath, outputTargetPath, generatedResourceDir, true);
        this.getResourcePathsTest(retrieved, projectDirPath, withGradle, true);
        this.getSourcePathsTest(retrieved, projectDirPath);
        this.getClassesPathsTest(retrieved);
        this.getOutputTargetTest(retrieved, outputTargetPath);
    }

    private void getPathsTest(AppPaths toCheck, String projectDirPath, boolean isGradle, boolean isTestDir) {
        Path[] retrieved = toCheck.getPaths();
        this.commonCheckResourcePaths(retrieved, projectDirPath, isGradle, isTestDir, "getPathsTest");
    }

    private void getFirstProjectPathTest(AppPaths toCheck, String expectedPath) {
        Path retrieved = toCheck.getFirstProjectPath();
        Assertions.assertEquals((Object)Path.of(expectedPath, new String[0]), (Object)retrieved, (String)"AppPathsTest.getFirstProjectPathTest");
    }

    private void getResourceFilesTest(AppPaths toCheck, String projectDirPath, String outputDir, String generatedResourceDir, boolean isTestDir) {
        File[] retrieved = toCheck.getResourceFiles();
        int expected = 2;
        Assertions.assertEquals((int)expected, (int)retrieved.length, (String)"AppPathsTest.getResourceFilesTest");
        String sourceDir = isTestDir ? "test" : "main";
        String expectedPath = String.format("%s/%s/%s/%s", projectDirPath, "src", sourceDir, "resources").replace("/", File.separator);
        Assertions.assertEquals((Object)new File(expectedPath), (Object)retrieved[0], (String)"AppPathsTest.getResourceFilesTest");
        expectedPath = String.format("%s/%s/%s", projectDirPath, outputDir, generatedResourceDir).replace("/", File.separator);
        Assertions.assertEquals((Object)new File(expectedPath), (Object)retrieved[1], (String)"AppPathsTest.getResourceFilesTest");
    }

    private void getResourcePathsTest(AppPaths toCheck, String projectDirPath, boolean isGradle, boolean isTestDir) {
        Path[] retrieved = toCheck.getResourcePaths();
        this.commonCheckResourcePaths(retrieved, projectDirPath, isGradle, isTestDir, "getResourcePathsTest");
    }

    private void getSourcePathsTest(AppPaths toCheck, String projectPath) {
        Path[] retrieved = toCheck.getSourcePaths();
        Assertions.assertEquals((int)1, (int)retrieved.length, (String)"AppPathsTest.getSourcePathsTest");
        String expectedPath = String.format("%s/src", projectPath).replace("/", File.separator);
        Assertions.assertEquals((Object)Path.of(expectedPath, new String[0]), (Object)retrieved[0], (String)"AppPathsTest.getSourcePathsTest");
    }

    private void getClassesPathsTest(AppPaths toCheck) {
        Collection retrieved = toCheck.getClassesPaths();
        Assertions.assertTrue((boolean)retrieved.isEmpty(), (String)"AppPathsTest.getClassesPathsTest");
    }

    private void getOutputTargetTest(AppPaths toCheck, String outputPath) {
        Path retrieved = toCheck.getOutputTarget();
        outputPath = String.format(".%s%s", File.separator, outputPath);
        Assertions.assertEquals((Object)Path.of(outputPath, new String[0]), (Object)retrieved, (String)"AppPathsTest.getOutputTargetTest");
    }

    private void commonCheckResourcePaths(Path[] toCheck, String projectDirPath, boolean isGradle, boolean isTestDir, String methodName) {
        int expected = 2;
        Assertions.assertEquals((int)expected, (int)toCheck.length, (String)String.format("AppPathsTest.%s", methodName));
        String sourceDir = isTestDir ? "test" : "main";
        String expectedPath = String.format("%s/src/%s/resources", projectDirPath, sourceDir).replace("/", File.separator);
        Assertions.assertEquals((Object)Path.of(expectedPath, new String[0]), (Object)toCheck[0], (String)String.format("AppPathsTest.%s", methodName));
        if (isGradle) {
            String toFormat = isTestDir ? "%s/build/generated/test/resources" : "%s/build/generated/resources";
            expectedPath = String.format(toFormat, projectDirPath).replace("/", File.separator);
            Assertions.assertEquals((Object)Path.of(expectedPath, new String[0]), (Object)toCheck[1], (String)String.format("AppPathsTest.%s", methodName));
        } else {
            String toFormat = isTestDir ? "%s/target/generated-test-resources" : "%s/target/generated-resources";
            expectedPath = String.format(toFormat, projectDirPath).replace("/", File.separator);
            Assertions.assertEquals((Object)Path.of(expectedPath, new String[0]), (Object)toCheck[1], (String)String.format("AppPathsTest.%s", methodName));
        }
    }
}

