/*
 * Decompiled with CFR 0.152.
 */
package org.drools.codegen.common;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.drools.codegen.common.AppPaths;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;
import org.drools.codegen.common.GeneratedFileWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

@Execution(value=ExecutionMode.SAME_THREAD)
class GeneratedFileWriterTest {
    GeneratedFileWriterTest() {
    }

    @ParameterizedTest
    @EnumSource(value=AppPaths.BuildTool.class, names={"GRADLE", "MAVEN"})
    void builderWithConfig(AppPaths.BuildTool bt) {
        String resourcesDirectoryProperty = "resource.property";
        String sourcesDirectoryProperty = "source.property";
        String finalPath = "final/destination/";
        String resourcesDirectory = "custom/resources/path";
        String sourcesDirectory = "custom/sources/path";
        System.setProperty(resourcesDirectoryProperty, resourcesDirectory);
        System.setProperty(sourcesDirectoryProperty, sourcesDirectory);
        GeneratedFileWriter.Builder retrieved = GeneratedFileWriter.builder((String)finalPath, (String)resourcesDirectoryProperty, (String)sourcesDirectoryProperty, (AppPaths.BuildTool)bt);
        Assertions.assertEquals((Object)bt.CLASSES_PATH.toString(), (Object)retrieved.classesDir);
        Assertions.assertEquals((Object)resourcesDirectory, (Object)retrieved.resourcePath);
        Assertions.assertEquals((Object)sourcesDirectory, (Object)retrieved.scaffoldedSourcesDir);
        System.clearProperty(resourcesDirectoryProperty);
        System.clearProperty(sourcesDirectoryProperty);
    }

    @ParameterizedTest
    @EnumSource(value=AppPaths.BuildTool.class, names={"GRADLE", "MAVEN"})
    void builderWithoutConfig(AppPaths.BuildTool bt) {
        String resourcesDirectoryProperty = "resource.property";
        String sourcesDirectoryProperty = "source.property";
        String finalPath = "final";
        GeneratedFileWriter.Builder retrieved = GeneratedFileWriter.builder((String)finalPath, (String)resourcesDirectoryProperty, (String)sourcesDirectoryProperty, (AppPaths.BuildTool)bt);
        Assertions.assertEquals((Object)bt.CLASSES_PATH.toString(), (Object)retrieved.classesDir);
        String expected = String.format("%s/%s", bt.GENERATED_RESOURCES_PATH.toString(), finalPath).replace("/", File.separator);
        Assertions.assertEquals((Object)expected, (Object)retrieved.resourcePath);
        expected = String.format("%s/%s", bt.GENERATED_SOURCES_PATH.toString(), finalPath).replace("/", File.separator);
        Assertions.assertEquals((Object)expected, (Object)retrieved.scaffoldedSourcesDir);
    }

    @ParameterizedTest
    @MethodSource(value={"btAndGeneratedFileCategoryProvider"})
    void write(AppPaths.BuildTool bt, GeneratedFileType.Category category) throws IOException {
        String relativePath = "relative/path";
        GeneratedFile generatedFile = new GeneratedFile(GeneratedFileType.of((GeneratedFileType.Category)category), relativePath, "");
        GeneratedFileWriter spiedWriter = (GeneratedFileWriter)Mockito.spy((Object)new GeneratedFileWriter(bt.CLASSES_PATH, bt.GENERATED_RESOURCES_PATH, bt.GENERATED_SOURCES_PATH));
        spiedWriter.write(generatedFile);
        Path location = switch (category) {
            default -> throw new IncompatibleClassChangeError();
            case GeneratedFileType.Category.INTERNAL_RESOURCE, GeneratedFileType.Category.STATIC_HTTP_RESOURCE, GeneratedFileType.Category.COMPILED_CLASS -> bt.CLASSES_PATH;
            case GeneratedFileType.Category.SOURCE -> bt.GENERATED_SOURCES_PATH;
        };
        ((GeneratedFileWriter)Mockito.verify((Object)spiedWriter)).writeGeneratedFile(generatedFile, location);
    }

    static Stream<Arguments> btAndGeneratedFileCategoryProvider() {
        Stream.Builder<Arguments> argumentBuilder = Stream.builder();
        for (AppPaths.BuildTool bt : AppPaths.BuildTool.values()) {
            for (GeneratedFileType.Category category : GeneratedFileType.Category.values()) {
                argumentBuilder.add(Arguments.of((Object[])new Object[]{bt, category}));
            }
        }
        return argumentBuilder.build();
    }
}

