/*
 * Decompiled with CFR 0.152.
 */
package org.drools.codegen.common;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.drools.codegen.common.GeneratedFileType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratedFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneratedFile.class);
    public static final String META_INF_RESOURCES = "META-INF/resources/";
    public static final Path META_INF_RESOURCES_PATH = Paths.get("META-INF/resources/", new String[0]);
    private final Path path;
    private final String pathAsString;
    private final byte[] contents;
    private final GeneratedFileType type;

    public GeneratedFile(GeneratedFileType type, Path path, String contents) {
        this(type, path, contents.getBytes(StandardCharsets.UTF_8));
    }

    public GeneratedFile(GeneratedFileType type, Path path, byte[] contents) {
        this(type, path, path.toString(), contents);
    }

    public GeneratedFile(GeneratedFileType type, String relativePath, String contents) {
        this(type, relativePath, contents.getBytes(StandardCharsets.UTF_8));
    }

    public GeneratedFile(GeneratedFileType type, String relativePath, byte[] contents) {
        this(type, Paths.get(relativePath, new String[0]), relativePath, contents);
    }

    private GeneratedFile(GeneratedFileType type, Path path, String pathAsString, byte[] contents) {
        this.type = type;
        if (type.category().equals((Object)GeneratedFileType.Category.STATIC_HTTP_RESOURCE)) {
            if (path.startsWith(META_INF_RESOURCES)) {
                LOGGER.warn("STATIC_HTTP_RESOURCE is automatically placed under META-INF/resources/. You don't need to specify the directory : {}", (Object)path);
            } else {
                path = META_INF_RESOURCES_PATH.resolve(path);
                pathAsString = path.toString();
            }
        }
        this.path = path;
        this.pathAsString = pathAsString;
        this.contents = contents;
    }

    public String relativePath() {
        return this.pathAsString;
    }

    public Path path() {
        return this.path;
    }

    public byte[] contents() {
        return this.contents;
    }

    public GeneratedFileType type() {
        return this.type;
    }

    public GeneratedFileType.Category category() {
        return this.type.category();
    }

    public String toStringWithContent() {
        return "GeneratedFile{path=" + this.path + ", content='\n" + new String(this.contents) + "\n'}";
    }

    public String toString() {
        return "GeneratedFile{type=" + this.type + ", path='" + this.path + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneratedFile that = (GeneratedFile)o;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }
}

