/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.TimeUnit;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class KnowledgeBuilderImplCompilerFJPoolTest {
    private ClassLoader originalClassLoader;
    private ClassLoader customClassLoader;

    @BeforeEach
    void setUp() {
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
        this.customClassLoader = new ClassLoader(ClassLoader.getSystemClassLoader()){};
        Thread.currentThread().setContextClassLoader(this.customClassLoader);
    }

    @AfterEach
    void tearDown() {
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
    }

    @Test
    void testCompilerPoolClassLoader() throws Exception {
        int i;
        int numTasks = 5;
        ArrayList<ClassLoader> results = new ArrayList<ClassLoader>(numTasks);
        for (i = 0; i < numTasks; ++i) {
            results.add(null);
        }
        for (i = 0; i < numTasks; ++i) {
            KnowledgeBuilderImpl.ForkJoinPoolHolder.COMPILER_POOL.submit(new ClassLoaderCheckTask(results, i));
        }
        KnowledgeBuilderImpl.ForkJoinPoolHolder.COMPILER_POOL.awaitQuiescence(1L, TimeUnit.SECONDS);
        for (ClassLoader workerClassLoader : results) {
            Assertions.assertSame((Object)this.customClassLoader, (Object)workerClassLoader, (String)"Worker thread should have inherited the custom classloader");
        }
    }

    private static class ClassLoaderCheckTask
    extends RecursiveAction {
        private final List<ClassLoader> results;
        private final int index;

        public ClassLoaderCheckTask(List<ClassLoader> results, int index) {
            this.results = results;
            this.index = index;
        }

        @Override
        protected void compute() {
            this.results.set(this.index, Thread.currentThread().getContextClassLoader());
        }
    }
}

