/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.descr;

import org.assertj.core.api.Assertions;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.io.ByteArrayResource;
import org.drools.util.StringUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;

public class CompositePackageDescrTest {
    private static final String NAMESPACE = "namespace";
    private CompositePackageDescr compositePackageDescr;

    @BeforeEach
    public void setup() {
        this.compositePackageDescr = new CompositePackageDescr((Resource)new ByteArrayResource(), new PackageDescr(NAMESPACE));
    }

    @Test
    public void addPackageDescrSamePkgUUID() {
        String pkgUUID = StringUtils.generateUUID();
        PackageDescr toAdd = new PackageDescr(NAMESPACE);
        toAdd.setPreferredPkgUUID(pkgUUID);
        this.compositePackageDescr.addPackageDescr((Resource)new ByteArrayResource(), toAdd);
        Assertions.assertThat((boolean)this.compositePackageDescr.getPreferredPkgUUID().isPresent()).isTrue();
        Assertions.assertThat((String)((String)this.compositePackageDescr.getPreferredPkgUUID().get())).isEqualTo(pkgUUID);
        toAdd = new PackageDescr(NAMESPACE);
        toAdd.setPreferredPkgUUID(pkgUUID);
        this.compositePackageDescr.addPackageDescr((Resource)new ByteArrayResource(), toAdd);
        Assertions.assertThat((String)((String)this.compositePackageDescr.getPreferredPkgUUID().get())).isEqualTo(pkgUUID);
    }

    @Test
    public void addPackageDescrDifferentPkgUUID() {
        String pkgUUID = StringUtils.generateUUID();
        PackageDescr first = new PackageDescr(NAMESPACE);
        first.setPreferredPkgUUID(pkgUUID);
        Assertions.assertThat((boolean)first.getPreferredPkgUUID().isPresent()).isTrue();
        this.compositePackageDescr.addPackageDescr((Resource)new ByteArrayResource(), first);
        Assertions.assertThat((boolean)this.compositePackageDescr.getPreferredPkgUUID().isPresent()).isTrue();
        Assertions.assertThat((String)((String)this.compositePackageDescr.getPreferredPkgUUID().get())).isEqualTo(pkgUUID);
        pkgUUID = StringUtils.generateUUID();
        PackageDescr second = new PackageDescr(NAMESPACE);
        second.setPreferredPkgUUID(pkgUUID);
        Assertions.assertThat((boolean)second.getPreferredPkgUUID().isPresent()).isTrue();
        Assertions.assertThat((String)((String)second.getPreferredPkgUUID().get())).isNotEqualTo(first.getPreferredPkgUUID().get());
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.compositePackageDescr.addPackageDescr((Resource)new ByteArrayResource(), second));
    }
}

