/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import org.drools.compiler.compiler.BuilderResultUtils;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.parser.DroolsError;
import org.kie.api.io.Resource;

public class DescrBuildError
extends DroolsError {
    private BaseDescr parentDescr;
    private BaseDescr descr;
    private Object object;
    private int[] errorLines = new int[1];
    private String originalMessage;

    public DescrBuildError(BaseDescr parentDescr, BaseDescr descr, Object object, String message) {
        super((Resource)(descr.getResource() != null ? descr.getResource() : (parentDescr != null ? parentDescr.getResource() : null)), BuilderResultUtils.getProblemMessage(object, message, "\n"));
        this.parentDescr = parentDescr;
        this.descr = descr;
        this.object = object;
        this.errorLines[0] = this.getLine();
        this.originalMessage = message;
    }

    public String getNamespace() {
        return this.parentDescr != null ? this.parentDescr.getNamespace() : this.descr.getNamespace();
    }

    public BaseDescr getParentDescr() {
        return this.parentDescr;
    }

    public BaseDescr getDescr() {
        return this.descr;
    }

    public Object getObject() {
        return this.object;
    }

    public int[] getLines() {
        return this.errorLines;
    }

    public int getLine() {
        return this.descr != null ? this.descr.getLine() : -1;
    }

    public int getColumn() {
        return this.descr != null ? this.descr.getColumn() : -1;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.originalMessage).append(" : ").append(this.parentDescr).append("\n");
        return BuilderResultUtils.appendProblems(this.object, builder).toString();
    }
}

