/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.agent.KnowledgeAgent;
import org.drools.agent.KnowledgeAgentConfiguration;
import org.drools.agent.KnowledgeAgentFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.builder.impl.KnowledgeBuilderImpl;
import org.drools.definition.KnowledgePackage;
import org.drools.io.ResourceChangeScannerConfiguration;
import org.drools.io.ResourceFactory;
import org.drools.io.impl.ResourceChangeScannerImpl;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.util.DroolsStreamUtils;
import org.drools.util.FileManager;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ResourceHandler;

public class KnowledgeAgentTest
extends TestCase {
    FileManager fileManager;
    private Server server;
    private String returnUrl;

    protected void setUp() throws Exception {
        this.fileManager = new FileManager();
        this.fileManager.setUp();
        ((ResourceChangeScannerImpl)ResourceFactory.getResourceChangeScannerService()).reset();
        ResourceFactory.getResourceChangeNotifierService().start();
        ResourceFactory.getResourceChangeScannerService().start();
        this.server = new Server(9000);
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setResourceBase(this.fileManager.getRootDirectory().getPath());
        this.server.setHandler((Handler)resourceHandler);
        this.server.start();
    }

    protected void tearDown() throws Exception {
        this.fileManager.tearDown();
        ResourceFactory.getResourceChangeNotifierService().stop();
        ResourceFactory.getResourceChangeScannerService().stop();
        ((ResourceChangeScannerImpl)ResourceFactory.getResourceChangeScannerService()).reset();
        this.server.stop();
    }

    public void testModifyFileUrl() throws Exception {
        String rule1 = "";
        rule1 = rule1 + "package org.drools.test\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule rule1\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "list.add( drools.getRule().getName() );\n";
        rule1 = rule1 + "end\n";
        File f1 = this.fileManager.newFile("rule1.drl");
        f1.deleteOnExit();
        BufferedWriter output = new BufferedWriter(new FileWriter(f1));
        output.write(rule1);
        ((Writer)output).close();
        String rule2 = "";
        rule2 = rule2 + "package org.drools.test\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule rule2\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "list.add( drools.getRule().getName() );\n";
        rule2 = rule2 + "end\n";
        File f2 = this.fileManager.newFile("rule2.drl");
        f2.deleteOnExit();
        output = new BufferedWriter(new FileWriter(f2));
        output.write(rule2);
        ((Writer)output).close();
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set drools-change-set-5.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:9000/rule1.drl' type='DRL' />";
        xml = xml + "        <resource source='http://localhost:9000/rule2.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.newFile("changeset.xml");
        fxml.deleteOnExit();
        output = new BufferedWriter(new FileWriter(fxml));
        output.write(xml);
        ((Writer)output).close();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        ResourceChangeScannerConfiguration sconf = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration();
        sconf.setProperty("drools.resource.scanner.interval", "2");
        ResourceFactory.getResourceChangeScannerService().configure(sconf);
        KnowledgeAgentConfiguration aconf = KnowledgeAgentFactory.newKnowledgeAgentConfiguration();
        aconf.setProperty("drools.agent.scanDirectories", "true");
        aconf.setProperty("drools.agent.scanResources", "true");
        aconf.setProperty("drools.agent.newInstance", "true");
        KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)"test agent", (KnowledgeBase)kbase, (KnowledgeAgentConfiguration)aconf);
        kagent.applyChangeSet(ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        KnowledgeAgentTest.assertEquals((int)2, (int)list.size());
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule1"));
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        Thread.sleep(2000L);
        rule1 = "";
        rule1 = rule1 + "package org.drools.test\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule rule3\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "list.add( drools.getRule().getName() );\n";
        rule1 = rule1 + "end\n";
        output = new BufferedWriter(new FileWriter(f1));
        output.write(rule1);
        ((Writer)output).close();
        Thread.sleep(3000L);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        KnowledgeAgentTest.assertEquals((int)2, (int)list.size());
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule3"));
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule2"));
        kagent.monitorResourceChangeEvents(false);
    }

    public void testModifyPackageUrl() throws Exception {
        String rule1 = "";
        rule1 = rule1 + "package org.drools.test\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule rule1\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "list.add( drools.getRule().getName() );\n";
        rule1 = rule1 + "end\n";
        String rule2 = "";
        rule2 = rule2 + "package org.drools.test\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule rule2\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "list.add( drools.getRule().getName() );\n";
        rule2 = rule2 + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule2.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            KnowledgeAgentTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgePackage pkg = (KnowledgePackage)kbuilder.getKnowledgePackages().iterator().next();
        KnowledgeAgentTest.writePackage(pkg, this.fileManager.newFile("pkg1.pkg"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set drools-change-set-5.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:9000/pkg1.pkg' type='PKG' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.newFile("changeset.xml");
        fxml.deleteOnExit();
        BufferedWriter output = new BufferedWriter(new FileWriter(fxml));
        output.write(xml);
        ((Writer)output).close();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        ResourceChangeScannerConfiguration sconf = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration();
        sconf.setProperty("drools.resource.scanner.interval", "2");
        ResourceFactory.getResourceChangeScannerService().configure(sconf);
        KnowledgeAgentConfiguration aconf = KnowledgeAgentFactory.newKnowledgeAgentConfiguration();
        aconf.setProperty("drools.agent.scanDirectories", "true");
        aconf.setProperty("drools.agent.scanResources", "true");
        aconf.setProperty("drools.agent.newInstance", "true");
        KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)"test agent", (KnowledgeBase)kbase, (KnowledgeAgentConfiguration)aconf);
        kagent.applyChangeSet(ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        KnowledgeAgentTest.assertEquals((int)2, (int)list.size());
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule1"));
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        Thread.sleep(2000L);
        rule1 = "";
        rule1 = rule1 + "package org.drools.test\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule rule3\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "list.add( drools.getRule().getName() );\n";
        rule1 = rule1 + "end\n";
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule2.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            KnowledgeAgentTest.fail((String)kbuilder.getErrors().toString());
        }
        pkg = (KnowledgePackage)kbuilder.getKnowledgePackages().iterator().next();
        KnowledgeAgentTest.writePackage(pkg, this.fileManager.newFile("pkg1.pkg"));
        Thread.sleep(3000L);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        KnowledgeAgentTest.assertEquals((int)2, (int)list.size());
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule3"));
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule2"));
        kagent.monitorResourceChangeEvents(false);
    }

    public void testDeletePackageUrl() throws Exception {
        String rule1 = "";
        rule1 = rule1 + "package org.drools.test1\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule rule1\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "list.add( drools.getRule().getName() );\n";
        rule1 = rule1 + "end\n";
        String rule2 = "";
        rule2 = rule2 + "package org.drools.test2\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule rule2\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "list.add( drools.getRule().getName() );\n";
        rule2 = rule2 + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule2.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            KnowledgeAgentTest.fail((String)kbuilder.getErrors().toString());
        }
        HashMap<String, KnowledgePackage> map = new HashMap<String, KnowledgePackage>();
        for (KnowledgePackage pkg : kbuilder.getKnowledgePackages()) {
            map.put(pkg.getName(), pkg);
        }
        KnowledgeAgentTest.writePackage((KnowledgePackage)map.get("org.drools.test1"), this.fileManager.newFile("pkg1.pkg"));
        KnowledgeAgentTest.writePackage((KnowledgePackage)map.get("org.drools.test2"), this.fileManager.newFile("pkg2.pkg"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set drools-change-set-5.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:9000/pkg1.pkg' type='PKG' />";
        xml = xml + "        <resource source='http://localhost:9000/pkg2.pkg' type='PKG' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        ResourceChangeScannerConfiguration sconf = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration();
        sconf.setProperty("drools.resource.scanner.interval", "2");
        ResourceFactory.getResourceChangeScannerService().configure(sconf);
        KnowledgeAgentConfiguration aconf = KnowledgeAgentFactory.newKnowledgeAgentConfiguration();
        aconf.setProperty("drools.agent.scanDirectories", "true");
        aconf.setProperty("drools.agent.scanResources", "true");
        aconf.setProperty("drools.agent.newInstance", "true");
        KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)"test agent", (KnowledgeBase)kbase, (KnowledgeAgentConfiguration)aconf);
        kagent.applyChangeSet(ResourceFactory.newByteArrayResource((byte[])xml.getBytes()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        KnowledgeAgentTest.assertEquals((int)2, (int)list.size());
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule1"));
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        Thread.sleep(2000L);
        xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set drools-change-set-5.0.xsd' >";
        xml = xml + "    <remove> ";
        xml = xml + "        <resource source='http://localhost:9000/pkg2.pkg' type='PKG' />";
        xml = xml + "    </remove> ";
        xml = xml + "</change-set>";
        kagent.applyChangeSet(ResourceFactory.newByteArrayResource((byte[])xml.getBytes()));
        Thread.sleep(3000L);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        KnowledgeAgentTest.assertEquals((int)1, (int)list.size());
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule1"));
        kagent.monitorResourceChangeEvents(false);
    }

    public void testOldSchoolPackageUrl() throws Exception {
        String rule1 = "";
        rule1 = rule1 + "package org.drools.test\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule rule1\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "list.add( drools.getRule().getName() );\n";
        rule1 = rule1 + "end\n";
        String rule2 = "";
        rule2 = rule2 + "package org.drools.test\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule rule2\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "list.add( drools.getRule().getName() );\n";
        rule2 = rule2 + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule2.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            KnowledgeAgentTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBuilderImpl kbi = (KnowledgeBuilderImpl)kbuilder;
        KnowledgeAgentTest.writePackage(kbi.getPackageBuilder().getPackage(), this.fileManager.newFile("pkgold.pkg"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set drools-change-set-5.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:9000/pkgold.pkg' type='PKG' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.newFile("changeset.xml");
        fxml.deleteOnExit();
        BufferedWriter output = new BufferedWriter(new FileWriter(fxml));
        output.write(xml);
        ((Writer)output).close();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        ResourceChangeScannerConfiguration sconf = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration();
        sconf.setProperty("drools.resource.scanner.interval", "2");
        ResourceFactory.getResourceChangeScannerService().configure(sconf);
        KnowledgeAgentConfiguration aconf = KnowledgeAgentFactory.newKnowledgeAgentConfiguration();
        aconf.setProperty("drools.agent.scanDirectories", "true");
        aconf.setProperty("drools.agent.scanResources", "true");
        aconf.setProperty("drools.agent.newInstance", "true");
        KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)"test agent", (KnowledgeBase)kbase, (KnowledgeAgentConfiguration)aconf);
        kagent.applyChangeSet(ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        KnowledgeAgentTest.assertEquals((int)2, (int)list.size());
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule1"));
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule2"));
    }

    public void testModifyFile() throws IOException, InterruptedException {
        String rule1 = "";
        rule1 = rule1 + "package org.drools.test\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule rule1\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "list.add( drools.getRule().getName() );\n";
        rule1 = rule1 + "end\n";
        File f1 = this.fileManager.newFile("rule1.drl");
        f1.deleteOnExit();
        BufferedWriter output = new BufferedWriter(new FileWriter(f1));
        output.write(rule1);
        ((Writer)output).close();
        String rule2 = "";
        rule2 = rule2 + "package org.drools.test\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule rule2\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "list.add( drools.getRule().getName() );\n";
        rule2 = rule2 + "end\n";
        File f2 = this.fileManager.newFile("rule2.drl");
        f2.deleteOnExit();
        output = new BufferedWriter(new FileWriter(f2));
        output.write(rule2);
        ((Writer)output).close();
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set drools-change-set-5.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='" + f1.toURI().toURL() + "' type='DRL' />";
        xml = xml + "        <resource source='" + f2.toURI().toURL() + "' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.newFile("changeset.xml");
        fxml.deleteOnExit();
        output = new BufferedWriter(new FileWriter(fxml));
        output.write(xml);
        ((Writer)output).close();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        ResourceChangeScannerConfiguration sconf = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration();
        sconf.setProperty("drools.resource.scanner.interval", "2");
        ResourceFactory.getResourceChangeScannerService().configure(sconf);
        KnowledgeAgentConfiguration aconf = KnowledgeAgentFactory.newKnowledgeAgentConfiguration();
        aconf.setProperty("drools.agent.scanDirectories", "true");
        aconf.setProperty("drools.agent.scanResources", "true");
        aconf.setProperty("drools.agent.newInstance", "true");
        KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)"test agent", (KnowledgeBase)kbase, (KnowledgeAgentConfiguration)aconf);
        kagent.applyChangeSet(ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        KnowledgeAgentTest.assertEquals((int)2, (int)list.size());
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule1"));
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        Thread.sleep(2000L);
        rule1 = "";
        rule1 = rule1 + "package org.drools.test\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule rule3\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "list.add( drools.getRule().getName() );\n";
        rule1 = rule1 + "end\n";
        output = new BufferedWriter(new FileWriter(f1));
        output.write(rule1);
        ((Writer)output).close();
        Thread.sleep(3000L);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        KnowledgeAgentTest.assertEquals((int)2, (int)list.size());
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule3"));
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule2"));
        kagent.monitorResourceChangeEvents(false);
    }

    public void testModifyDirectory() throws IOException, InterruptedException {
        String rule1 = "";
        rule1 = rule1 + "package org.drools.test\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule rule1\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "list.add( drools.getRule().getName() );\n";
        rule1 = rule1 + "end\n";
        File f1 = this.fileManager.newFile("rule1.drl");
        BufferedWriter output = new BufferedWriter(new FileWriter(f1));
        output.write(rule1);
        ((Writer)output).close();
        String rule2 = "";
        rule2 = rule2 + "package org.drools.test\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule rule2\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "list.add( drools.getRule().getName() );\n";
        rule2 = rule2 + "end\n";
        File f2 = this.fileManager.newFile("rule2.drl");
        output = new BufferedWriter(new FileWriter(f2));
        output.write(rule2);
        ((Writer)output).close();
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set drools-change-set-5.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='" + f1.getParentFile().toURI().toURL() + "' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File newDir = this.fileManager.newFile("changeset");
        newDir.mkdir();
        File fxml = this.fileManager.newFile(newDir, "changeset.xml");
        output = new BufferedWriter(new FileWriter(fxml));
        output.write(xml);
        ((Writer)output).close();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        ResourceChangeScannerConfiguration sconf = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration();
        sconf.setProperty("drools.resource.scanner.interval", "2");
        ResourceFactory.getResourceChangeScannerService().configure(sconf);
        KnowledgeAgentConfiguration aconf = KnowledgeAgentFactory.newKnowledgeAgentConfiguration();
        aconf.setProperty("drools.agent.scanDirectories", "true");
        aconf.setProperty("drools.agent.newInstance", "true");
        KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)"test agent", (KnowledgeBase)kbase, (KnowledgeAgentConfiguration)aconf);
        kagent.applyChangeSet(ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        Thread.sleep(3000L);
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        KnowledgeAgentTest.assertEquals((int)2, (int)list.size());
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule1"));
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        String rule3 = "";
        rule3 = rule3 + "package org.drools.test\n";
        rule3 = rule3 + "global java.util.List list\n";
        rule3 = rule3 + "rule rule3\n";
        rule3 = rule3 + "when\n";
        rule3 = rule3 + "then\n";
        rule3 = rule3 + "list.add( drools.getRule().getName() );\n";
        rule3 = rule3 + "end\n";
        File f3 = this.fileManager.newFile("rule3.drl");
        output = new BufferedWriter(new FileWriter(f3));
        output.write(rule3);
        ((Writer)output).close();
        KnowledgeAgentTest.assertTrue((boolean)f1.delete());
        Thread.sleep(3000L);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        KnowledgeAgentTest.assertEquals((int)2, (int)list.size());
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule2"));
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule3"));
        kagent.monitorResourceChangeEvents(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePackage(Object pkg, File p1file) throws IOException, FileNotFoundException {
        FileOutputStream out = new FileOutputStream(p1file);
        try {
            DroolsStreamUtils.streamOut((OutputStream)out, (Object)pkg);
        }
        finally {
            out.close();
        }
    }
}

