/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.rules;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.server.rules.SuggestionCompletionLoader;

public class SuggestionCompletionLoaderTest
extends TestCase {
    public void testSuggestionCompLoader() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.Person", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
    }

    public void testSuggestionCompLoaderWildcards() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        loader.getSuggestionEngine("package foo \n import org.drools.*", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertEquals((int)1, (int)loader.getErrors().size());
        String err = (String)loader.getErrors().get(0);
        SuggestionCompletionLoaderTest.assertTrue((boolean)err.startsWith("Unable"));
    }

    public void testLoadDifferentFieldTypes() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.guvnor.server.rules.SomeFact", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        SuggestionCompletionLoaderTest.assertEquals((String)"Numeric", (String)eng.getFieldType("SomeFact", "age"));
        SuggestionCompletionLoaderTest.assertEquals((String)"String", (String)eng.getFieldType("SomeFact", "likes"));
        SuggestionCompletionLoaderTest.assertEquals((String)"String", (String)eng.getFieldType("SomeFact", "name"));
        SuggestionCompletionLoaderTest.assertEquals((String)"Numeric", (String)eng.getFieldType("SomeFact", "bigDecimal"));
        SuggestionCompletionLoaderTest.assertEquals((String)"Comparable", (String)eng.getFieldType("SomeFact", "date"));
        SuggestionCompletionLoaderTest.assertEquals((String)"Cheese", (String)eng.getFieldType("SomeFact", "cheese"));
        SuggestionCompletionLoaderTest.assertEquals((String)"Boolean", (String)eng.getFieldType("SomeFact", "dead"));
        SuggestionCompletionLoaderTest.assertEquals((String)"Boolean", (String)eng.getFieldType("SomeFact", "alive"));
    }

    public void testGeneratedBeans() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n declare GenBean \n   id: int \n name : String \n end \n declare GenBean2 \n list: java.util.List \n gb: GenBean \n end", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertFalse((boolean)loader.hasErrors());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        SuggestionCompletionLoaderTest.assertEquals((int)2, (int)eng.factTypes.length);
        SuggestionCompletionLoaderTest.assertEquals((String)"GenBean", (String)eng.factTypes[0]);
        SuggestionCompletionLoaderTest.assertEquals((String)"GenBean2", (String)eng.factTypes[1]);
        SuggestionCompletionLoaderTest.assertEquals((String)"Numeric", (String)eng.getFieldType("GenBean", "id"));
        SuggestionCompletionLoaderTest.assertEquals((String)"String", (String)eng.getFieldType("GenBean", "name"));
        SuggestionCompletionLoaderTest.assertEquals((String)"GenBean", (String)eng.getFieldType("GenBean2", "gb"));
    }

    public void testGlobal() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n global org.drools.Person p", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        SuggestionCompletionLoaderTest.assertFalse((boolean)loader.hasErrors());
        SuggestionCompletionLoaderTest.assertEquals((int)1, (int)eng.getGlobalVariables().length);
        SuggestionCompletionLoaderTest.assertEquals((String)"p", (String)eng.getGlobalVariables()[0]);
        SuggestionCompletionLoaderTest.assertEquals((String)"Person", (String)((String)eng.globalTypes.get("p")));
        String[] flds = (String[])eng.fieldsForType.get("Person");
        SuggestionCompletionLoaderTest.assertNotNull((Object)flds);
        SuggestionCompletionLoaderTest.assertEquals((int)0, (int)eng.globalCollections.length);
    }

    public void testGlobalCollections() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n global java.util.List ls", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        SuggestionCompletionLoaderTest.assertFalse((boolean)loader.hasErrors());
        SuggestionCompletionLoaderTest.assertEquals((int)1, (int)eng.getGlobalVariables().length);
        SuggestionCompletionLoaderTest.assertEquals((String)"ls", (String)eng.getGlobalVariables()[0]);
        SuggestionCompletionLoaderTest.assertEquals((String)"List", (String)((String)eng.globalTypes.get("ls")));
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng.globalCollections);
        SuggestionCompletionLoaderTest.assertEquals((int)1, (int)eng.globalCollections.length);
        SuggestionCompletionLoaderTest.assertEquals((String)"ls", (String)eng.globalCollections[0]);
    }

    public void testSortOrderOfFields() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.guvnor.server.rules.SomeFact", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        String[] fields = eng.getFieldCompletions("SomeFact");
        SuggestionCompletionLoaderTest.assertEquals((String)"age", (String)fields[0]);
        SuggestionCompletionLoaderTest.assertEquals((String)"alive", (String)fields[1]);
        SuggestionCompletionLoaderTest.assertEquals((String)"bigDecimal", (String)fields[2]);
    }

    public void testSortOrderOfFacts() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.guvnor.server.rules.SomeFact\n import org.drools.Person", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        String[] facts = eng.getFactTypes();
        SuggestionCompletionLoaderTest.assertEquals((int)2, (int)facts.length);
        SuggestionCompletionLoaderTest.assertEquals((String)"Person", (String)facts[0]);
        SuggestionCompletionLoaderTest.assertEquals((String)"SomeFact", (String)facts[1]);
    }

    public void testLoaderWithExistingClassloader() throws Exception {
        MockClassLoader mcl = new MockClassLoader();
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader((ClassLoader)mcl);
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.foo.Bar", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng.dataEnumLists);
        SuggestionCompletionLoaderTest.assertTrue((boolean)mcl.called);
    }

    static class MockClassLoader
    extends ClassLoader {
        public boolean called = false;

        MockClassLoader() {
        }

        public Class loadClass(String name) {
            this.called = true;
            return Object.class;
        }
    }
}

