/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import junit.framework.TestCase;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.server.util.SuggestionCompletionEngineBuilder;
import org.drools.lang.dsl.DSLMappingEntry;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;

public class SuggestionCompletionEngineBuilderTest
extends TestCase {
    SuggestionCompletionEngineBuilder builder = new SuggestionCompletionEngineBuilder();
    Mockery context = new Mockery();

    protected void setUp() throws Exception {
        super.setUp();
        this.builder.newCompletionEngine();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAddDSLSentence() {
        String input = "{This} is a {pattern} considered pretty \\{{easy}\\} by most \\{people\\}. What do you {say}?";
        this.builder.addDSLActionSentence("{This} is a {pattern} considered pretty \\{{easy}\\} by most \\{people\\}. What do you {say}?");
        this.builder.addDSLConditionSentence("foo bar");
        SuggestionCompletionEngine engine = this.builder.getInstance();
        SuggestionCompletionEngineBuilderTest.assertEquals((int)1, (int)engine.actionDSLSentences.length);
        SuggestionCompletionEngineBuilderTest.assertEquals((int)1, (int)engine.conditionDSLSentences.length);
    }

    public void testAddSentenceMultipleTypes() {
        final DSLMappingEntry mapping1 = (DSLMappingEntry)this.context.mock(DSLMappingEntry.class, "mapping1");
        final DSLMappingEntry mapping2 = (DSLMappingEntry)this.context.mock(DSLMappingEntry.class, "mapping2");
        final DSLMappingEntry mapping3 = (DSLMappingEntry)this.context.mock(DSLMappingEntry.class, "mapping3");
        final DSLMappingEntry mapping4 = (DSLMappingEntry)this.context.mock(DSLMappingEntry.class, "mapping4");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DSLMappingEntry)this.allowing(mapping1)).getSection();
                this.will(1.returnValue((Object)DSLMappingEntry.CONDITION));
                ((DSLMappingEntry)this.allowing(mapping1)).getMappingKey();
                this.will(1.returnValue((Object)"cond"));
                ((DSLMappingEntry)this.allowing(mapping2)).getSection();
                this.will(1.returnValue((Object)DSLMappingEntry.CONSEQUENCE));
                ((DSLMappingEntry)this.allowing(mapping2)).getMappingKey();
                this.will(1.returnValue((Object)"cons"));
                ((DSLMappingEntry)this.allowing(mapping3)).getSection();
                this.will(1.returnValue((Object)DSLMappingEntry.ANY));
                ((DSLMappingEntry)this.allowing(mapping3)).getMappingKey();
                this.will(1.returnValue((Object)"any"));
                ((DSLMappingEntry)this.allowing(mapping4)).getSection();
                this.will(1.returnValue((Object)DSLMappingEntry.KEYWORD));
                ((DSLMappingEntry)this.allowing(mapping4)).getMappingKey();
                this.will(1.returnValue((Object)"key"));
            }
        });
        this.builder.addDSLMapping(mapping1);
        this.builder.addDSLMapping(mapping2);
        this.builder.addDSLMapping(mapping3);
        this.builder.addDSLMapping(mapping4);
        SuggestionCompletionEngine engine = this.builder.getInstance();
        SuggestionCompletionEngineBuilderTest.assertEquals((int)1, (int)engine.actionDSLSentences.length);
        SuggestionCompletionEngineBuilderTest.assertEquals((int)1, (int)engine.conditionDSLSentences.length);
        SuggestionCompletionEngineBuilderTest.assertEquals((int)1, (int)engine.keywordDSLItems.length);
        SuggestionCompletionEngineBuilderTest.assertEquals((int)1, (int)engine.anyScopeDSLItems.length);
        SuggestionCompletionEngineBuilderTest.assertEquals((String)"cond", (String)engine.conditionDSLSentences[0].sentence);
    }
}

