/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.Cheesery;
import org.drools.FactHandle;
import org.drools.OuterClass;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.RuntimeDroolsException;
import org.drools.StatefulSession;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.integrationtests.SerializationHelper;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.Package;

public class AccumulateTest
extends TestCase {
    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    private RuleBase loadRuleBase(Reader reader) throws IOException, DroolsParserException, Exception {
        return this.loadRuleBase(reader, new PackageBuilderConfiguration());
    }

    private RuleBase loadRuleBase(Reader reader, PackageBuilderConfiguration conf) throws IOException, DroolsParserException, Exception {
        DrlParser parser = new DrlParser();
        PackageDescr packageDescr = parser.parse(reader);
        if (parser.hasErrors()) {
            System.out.println(parser.getErrors());
            Assert.fail((String)"Error messages in parser, need to sort this our (or else collect error messages)");
        }
        PackageBuilder builder = new PackageBuilder(conf);
        builder.addPackage(packageDescr);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        return ruleBase;
    }

    public void testAccumulateModify() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AccumulateModify.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)0, (int)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((int)1, (int)results.size());
        Assert.assertEquals((int)24, (int)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
        Assert.assertEquals((int)31, (int)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
    }

    public void testAccumulate() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Accumulate.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new Person("Bob", "stilton", 20));
        wm.insert((Object)new Person("Mark", "provolone"));
        wm.insert((Object)new Cheese("stilton", 10));
        wm.insert((Object)new Cheese("brie", 5));
        wm.insert((Object)new Cheese("provolone", 150));
        wm.fireAllRules();
        Assert.assertEquals((Object)new Integer(165), results.get(0));
        Assert.assertEquals((Object)new Integer(10), results.get(1));
        Assert.assertEquals((Object)new Integer(150), results.get(2));
        Assert.assertEquals((Object)new Integer(10), results.get(3));
        Assert.assertEquals((Object)new Integer(210), results.get(4));
    }

    public void testMVELAccumulate() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AccumulateMVEL.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new Person("Bob", "stilton", 20));
        wm.insert((Object)new Person("Mark", "provolone"));
        wm.insert((Object)new Cheese("stilton", 10));
        wm.insert((Object)new Cheese("brie", 5));
        wm.insert((Object)new Cheese("provolone", 150));
        wm.fireAllRules();
        Assert.assertEquals((Object)new Integer(165), results.get(0));
        Assert.assertEquals((Object)new Integer(10), results.get(1));
        Assert.assertEquals((Object)new Integer(150), results.get(2));
        Assert.assertEquals((Object)new Integer(10), results.get(3));
        Assert.assertEquals((Object)new Integer(210), results.get(4));
    }

    public void testAccumulateModifyMVEL() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AccumulateModifyMVEL.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)0, (int)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((int)1, (int)results.size());
        Assert.assertEquals((int)24, (int)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
        Assert.assertEquals((int)31, (int)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
    }

    public void testAccumulateReverseModify() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AccumulateReverseModify.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)0, (int)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((int)1, (int)results.size());
        Assert.assertEquals((int)24, (int)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        cheese[3].setPrice(20);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[3], (Object)cheese[3]);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
        Assert.assertEquals((int)36, (int)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
    }

    public void testAccumulateReverseModify2() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AccumulateReverseModify2.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)0, (int)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((int)1, (int)results.size());
        Assert.assertEquals((int)24, (int)((Number)results.get(results.size() - 1)).intValue());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        cheese[3].setPrice(20);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[3], (Object)cheese[3]);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
        Assert.assertEquals((int)36, (int)((Number)results.get(results.size() - 1)).intValue());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
    }

    public void testAccumulateReverseModifyMVEL() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AccumulateReverseModifyMVEL.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)0, (int)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((int)1, (int)results.size());
        Assert.assertEquals((int)24, (int)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
        Assert.assertEquals((int)31, (int)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
    }

    public void testAccumulateReverseModifyMVEL2() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AccumulateReverseModifyMVEL2.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)0, (int)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((int)1, (int)results.size());
        Assert.assertEquals((int)24, (int)((Number)results.get(results.size() - 1)).intValue());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
        Assert.assertEquals((int)31, (int)((Number)results.get(results.size() - 1)).intValue());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
    }

    public void testAccumulateWithFromChaining() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AccumulateWithFromChaining.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 8), new Cheese("stilton", 10), new Cheese("stilton", 9), new Cheese("brie", 4), new Cheese("brie", 1), new Cheese("provolone", 8)};
        Cheesery cheesery = new Cheesery();
        for (int i = 0; i < cheese.length; ++i) {
            cheesery.addCheese(cheese[i]);
        }
        FactHandle cheeseryHandle = wm.insert((Object)cheesery);
        Person bob = new Person("Bob", "stilton");
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)1, (int)results.size());
        Assert.assertEquals((int)3, (int)((List)results.get(results.size() - 1)).size());
        boolean index = true;
        cheese[1].setType("brie");
        wm.update((org.drools.runtime.rule.FactHandle)cheeseryHandle, (Object)cheesery);
        wm.fireAllRules();
        Assert.assertEquals((int)1, (int)results.size());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
        Assert.assertEquals((int)3, (int)((List)results.get(results.size() - 1)).size());
        cheesery.getCheeses().remove(cheese[3]);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseryHandle, (Object)cheesery);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
    }

    public void testMVELAccumulate2WM() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AccumulateMVEL.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm1 = ruleBase.newStatefulSession();
        ArrayList results1 = new ArrayList();
        wm1.setGlobal("results", results1);
        StatefulSession wm2 = ruleBase.newStatefulSession();
        ArrayList results2 = new ArrayList();
        wm2.setGlobal("results", results2);
        wm1.insert((Object)new Person("Bob", "stilton", 20));
        wm1.insert((Object)new Person("Mark", "provolone"));
        wm2.insert((Object)new Person("Bob", "stilton", 20));
        wm2.insert((Object)new Person("Mark", "provolone"));
        wm1.insert((Object)new Cheese("stilton", 10));
        wm1.insert((Object)new Cheese("brie", 5));
        wm2.insert((Object)new Cheese("stilton", 10));
        wm1.insert((Object)new Cheese("provolone", 150));
        wm2.insert((Object)new Cheese("brie", 5));
        wm2.insert((Object)new Cheese("provolone", 150));
        wm1.fireAllRules();
        wm2.fireAllRules();
        Assert.assertEquals((Object)new Integer(165), results1.get(0));
        Assert.assertEquals((Object)new Integer(10), results1.get(1));
        Assert.assertEquals((Object)new Integer(150), results1.get(2));
        Assert.assertEquals((Object)new Integer(10), results1.get(3));
        Assert.assertEquals((Object)new Integer(210), results1.get(4));
        Assert.assertEquals((Object)new Integer(165), results2.get(0));
        Assert.assertEquals((Object)new Integer(10), results2.get(1));
        Assert.assertEquals((Object)new Integer(150), results2.get(2));
        Assert.assertEquals((Object)new Integer(10), results2.get(3));
        Assert.assertEquals((Object)new Integer(210), results2.get(4));
    }

    public void testAccumulateInnerClass() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AccumulateInnerClass.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new OuterClass.InnerClass(10));
        wm.insert((Object)new OuterClass.InnerClass(5));
        wm.fireAllRules();
        Assert.assertEquals((Object)new Integer(15), results.get(0));
    }

    public void testAccumulateReturningNull() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AccumulateReturningNull.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        try {
            wm.insert((Object)new Cheese("stilton", 10));
            AccumulateTest.fail((String)"Should have raised an exception because accumulate is returning null");
        }
        catch (RuntimeDroolsException rde) {
        }
        catch (Exception e) {
            e.printStackTrace();
            AccumulateTest.fail((String)("Should have raised a DroolsRuntimeException instead of " + e));
        }
    }

    public void testAccumulateReturningNullMVEL() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AccumulateReturningNullMVEL.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        try {
            wm.insert((Object)new Cheese("stilton", 10));
            AccumulateTest.fail((String)"Should have raised an exception because accumulate is returning null");
        }
        catch (RuntimeDroolsException rde) {
        }
        catch (Exception e) {
            e.printStackTrace();
            AccumulateTest.fail((String)("Should have raised a DroolsRuntimeException instead of " + e));
        }
    }

    public void testAccumulateSumJava() throws Exception {
        this.execTestAccumulateSum("test_AccumulateSum.drl");
    }

    public void testAccumulateSumMVEL() throws Exception {
        this.execTestAccumulateSum("test_AccumulateSumMVEL.drl");
    }

    public void testAccumulateMultiPatternWithFunctionJava() throws Exception {
        this.execTestAccumulateSum("test_AccumulateMultiPatternFunctionJava.drl");
    }

    public void testAccumulateMultiPatternWithFunctionMVEL() throws Exception {
        this.execTestAccumulateSum("test_AccumulateMultiPatternFunctionMVEL.drl");
    }

    public void testAccumulateCountJava() throws Exception {
        this.execTestAccumulateCount("test_AccumulateCount.drl");
    }

    public void testAccumulateCountMVEL() throws Exception {
        this.execTestAccumulateCount("test_AccumulateCountMVEL.drl");
    }

    public void testAccumulateAverageJava() throws Exception {
        this.execTestAccumulateAverage("test_AccumulateAverage.drl");
    }

    public void testAccumulateAverageMVEL() throws Exception {
        this.execTestAccumulateAverage("test_AccumulateAverageMVEL.drl");
    }

    public void testAccumulateMinJava() throws Exception {
        this.execTestAccumulateMin("test_AccumulateMin.drl");
    }

    public void testAccumulateMinMVEL() throws Exception {
        this.execTestAccumulateMin("test_AccumulateMinMVEL.drl");
    }

    public void testAccumulateMaxJava() throws Exception {
        this.execTestAccumulateMax("test_AccumulateMax.drl");
    }

    public void testAccumulateMaxMVEL() throws Exception {
        this.execTestAccumulateMax("test_AccumulateMaxMVEL.drl");
    }

    public void testAccumulateMultiPatternJava() throws Exception {
        this.execTestAccumulateReverseModifyMultiPattern("test_AccumulateMultiPattern.drl");
    }

    public void testAccumulateMultiPatternMVEL() throws Exception {
        this.execTestAccumulateReverseModifyMultiPattern("test_AccumulateMultiPatternMVEL.drl");
    }

    public void testAccumulateCollectListJava() throws Exception {
        this.execTestAccumulateCollectList("test_AccumulateCollectList.drl");
    }

    public void testAccumulateCollectListMVEL() throws Exception {
        this.execTestAccumulateCollectList("test_AccumulateCollectListMVEL.drl");
    }

    public void testAccumulateCollectSetJava() throws Exception {
        this.execTestAccumulateCollectSet("test_AccumulateCollectSet.drl");
    }

    public void testAccumulateCollectSetMVEL() throws Exception {
        this.execTestAccumulateCollectSet("test_AccumulateCollectSetMVEL.drl");
    }

    public void execTestAccumulateSum(String fileName) throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(fileName));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession session = ruleBase.newStatefulSession();
        DataSet data = new DataSet();
        data.results = new ArrayList();
        session.setGlobal("results", data.results);
        data.cheese = new Cheese[]{new Cheese("stilton", 8, 0), new Cheese("stilton", 10, 1), new Cheese("stilton", 9, 2), new Cheese("brie", 11, 3), new Cheese("brie", 4, 4), new Cheese("provolone", 8, 5)};
        data.bob = new Person("Bob", "stilton");
        data.cheeseHandles = new FactHandle[data.cheese.length];
        for (int i = 0; i < data.cheese.length; ++i) {
            data.cheeseHandles[i] = session.insert((Object)data.cheese[i]);
        }
        data.bobHandle = session.insert((Object)data.bob);
        session.fireAllRules();
        Assert.assertEquals((int)1, (int)data.results.size());
        Assert.assertEquals((int)27, (int)((Number)data.results.get(data.results.size() - 1)).intValue());
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        this.updateReferences(session, data);
        boolean index = true;
        data.cheese[1].setPrice(3);
        session.update((org.drools.runtime.rule.FactHandle)data.cheeseHandles[1], (Object)data.cheese[1]);
        session.fireAllRules();
        Assert.assertEquals((int)2, (int)data.results.size());
        Assert.assertEquals((int)20, (int)((Number)data.results.get(data.results.size() - 1)).intValue());
        data.bob.setLikes("brie");
        session.update((org.drools.runtime.rule.FactHandle)data.bobHandle, (Object)data.bob);
        session.fireAllRules();
        Assert.assertEquals((int)3, (int)data.results.size());
        Assert.assertEquals((int)15, (int)((Number)data.results.get(data.results.size() - 1)).intValue());
        session.retract((org.drools.runtime.rule.FactHandle)data.cheeseHandles[3]);
        session.fireAllRules();
        Assert.assertEquals((int)3, (int)data.results.size());
    }

    private void updateReferences(StatefulSession session, DataSet data) {
        data.results = (List)session.getGlobal("results");
        Iterator it = session.iterateObjects();
        while (it.hasNext()) {
            Person p;
            Object next = it.next();
            if (next instanceof Cheese) {
                Cheese c;
                data.cheese[c.getOldPrice()] = c = (Cheese)next;
                data.cheeseHandles[c.getOldPrice()] = session.getFactHandle((Object)c);
                AccumulateTest.assertNotNull((Object)data.cheeseHandles[c.getOldPrice()]);
                continue;
            }
            if (!(next instanceof Person)) continue;
            data.bob = p = (Person)next;
            data.bobHandle = session.getFactHandle((Object)data.bob);
        }
    }

    public void execTestAccumulateCount(String fileName) throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(fileName));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 8), new Cheese("stilton", 10), new Cheese("stilton", 9), new Cheese("brie", 4), new Cheese("brie", 1), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)1, (int)results.size());
        Assert.assertEquals((int)3, (int)((Number)results.get(results.size() - 1)).intValue());
        boolean index = true;
        cheese[1].setPrice(3);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
        Assert.assertEquals((int)3, (int)((Number)results.get(results.size() - 1)).intValue());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)3, (int)results.size());
        Assert.assertEquals((int)2, (int)((Number)results.get(results.size() - 1)).intValue());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((int)3, (int)results.size());
    }

    public void execTestAccumulateAverage(String fileName) throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(fileName));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 11), new Cheese("brie", 15), new Cheese("brie", 17), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)0, (int)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((int)1, (int)results.size());
        Assert.assertEquals((int)10, (int)((Number)results.get(results.size() - 1)).intValue());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
        Assert.assertEquals((int)16, (int)((Number)results.get(results.size() - 1)).intValue());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[4]);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
    }

    public void execTestAccumulateMin(String fileName) throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(fileName));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 8), new Cheese("stilton", 10), new Cheese("stilton", 9), new Cheese("brie", 4), new Cheese("brie", 1), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)0, (int)results.size());
        boolean index = true;
        cheese[1].setPrice(3);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((int)1, (int)results.size());
        Assert.assertEquals((int)3, (int)((Number)results.get(results.size() - 1)).intValue());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
        Assert.assertEquals((int)1, (int)((Number)results.get(results.size() - 1)).intValue());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[4]);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
    }

    public void execTestAccumulateMax(String fileName) throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(fileName));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 4), new Cheese("stilton", 2), new Cheese("stilton", 3), new Cheese("brie", 15), new Cheese("brie", 17), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)0, (int)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((int)1, (int)results.size());
        Assert.assertEquals((int)9, (int)((Number)results.get(results.size() - 1)).intValue());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
        Assert.assertEquals((int)17, (int)((Number)results.get(results.size() - 1)).intValue());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[4]);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
    }

    public void execTestAccumulateCollectList(String fileName) throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(fileName));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 4), new Cheese("stilton", 2), new Cheese("stilton", 3), new Cheese("brie", 15), new Cheese("brie", 17), new Cheese("provolone", 8)};
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        wm.fireAllRules();
        Assert.assertEquals((int)1, (int)results.size());
        Assert.assertEquals((int)6, (int)((List)results.get(results.size() - 1)).size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
        Assert.assertEquals((int)6, (int)((List)results.get(results.size() - 1)).size());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[4]);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
    }

    public void execTestAccumulateCollectSet(String fileName) throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(fileName));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 4), new Cheese("stilton", 2), new Cheese("stilton", 3), new Cheese("brie", 15), new Cheese("brie", 17), new Cheese("provolone", 8)};
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        wm.fireAllRules();
        Assert.assertEquals((int)1, (int)results.size());
        Assert.assertEquals((int)3, (int)((Set)results.get(results.size() - 1)).size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
        Assert.assertEquals((int)3, (int)((Set)results.get(results.size() - 1)).size());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((int)3, (int)results.size());
        Assert.assertEquals((int)3, (int)((Set)results.get(results.size() - 1)).size());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[4]);
        wm.fireAllRules();
        Assert.assertEquals((int)3, (int)results.size());
    }

    public void execTestAccumulateReverseModifyMultiPattern(String fileName) throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(fileName));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        Person mark = new Person("Mark", "provolone");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        FactHandle markHandle = wm.insert((Object)mark);
        wm.fireAllRules();
        Assert.assertEquals((int)0, (int)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((int)1, (int)results.size());
        Assert.assertEquals((int)32, (int)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
        Assert.assertEquals((int)39, (int)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((int)2, (int)results.size());
    }

    public void testAccumulateWithPreviouslyBoundVariables() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AccumulatePreviousBinds.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new Cheese("stilton", 10));
        wm.insert((Object)new Cheese("brie", 5));
        wm.insert((Object)new Cheese("provolone", 150));
        wm.insert((Object)new Cheese("brie", 20));
        wm.fireAllRules();
        AccumulateTest.assertEquals((int)1, (int)results.size());
        AccumulateTest.assertEquals((Object)new Integer(45), results.get(0));
    }

    public void testAccumulateGlobals() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AccumulateGlobals.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.setGlobal("globalValue", (Object)new Integer(50));
        wm.insert((Object)new Cheese("stilton", 10));
        wm.insert((Object)new Cheese("brie", 5));
        wm.insert((Object)new Cheese("provolone", 150));
        wm.insert((Object)new Cheese("brie", 20));
        wm.fireAllRules();
        AccumulateTest.assertEquals((int)1, (int)results.size());
        AccumulateTest.assertEquals((Object)new Integer(100), results.get(0));
    }

    public static class DataSet {
        public Cheese[] cheese;
        public FactHandle[] cheeseHandles;
        public Person bob;
        public FactHandle bobHandle;
        public List<?> results;
    }
}

