/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.integrationtests.LargeRuleBase;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.Package;
import org.drools.util.DroolsStreamUtils;

public class LargeRuleBaseSerializationTest
extends TestCase {
    private static final int RULE_COUNT = Integer.parseInt(System.getProperty("test.count", "525"));
    private static final int ITERATIONS = Integer.parseInt(System.getProperty("test.iterations", "5"));
    private static RuleBase ruleBase;
    private static byte[] bytes;
    private static byte[] compressedBytes;
    private static final int MILLIS_IN_SECOND = 1000;
    private static final int MILLIS_IN_MINUTE = 60000;
    private static final int MILLIS_IN_HOUR = 3600000;

    protected void setUp() throws Exception {
        if (ruleBase == null) {
            ruleBase = LargeRuleBaseSerializationTest.createRuleBase();
        }
        if (bytes == null) {
            bytes = DroolsStreamUtils.streamOut((Object)ruleBase);
        }
        if (compressedBytes == null) {
            compressedBytes = DroolsStreamUtils.streamOut((Object)ruleBase, (boolean)true);
        }
    }

    public void testUnmarshallingPerformance() throws Exception {
        DroolsStreamUtils.streamIn((byte[])bytes);
        long time = System.currentTimeMillis();
        int i = ITERATIONS;
        while (i-- > 0) {
            DroolsStreamUtils.streamIn((byte[])bytes);
        }
        System.out.println("Total time of unmarshalling " + ITERATIONS + " times is " + LargeRuleBaseSerializationTest.format(System.currentTimeMillis() - time));
    }

    public void testMarshallingPerformance() throws Exception {
        long time = System.currentTimeMillis();
        int i = ITERATIONS;
        while (i-- > 0) {
            DroolsStreamUtils.streamOut((Object)ruleBase);
        }
        System.out.println("Total time of marshalling " + ITERATIONS + " times is " + LargeRuleBaseSerializationTest.format(System.currentTimeMillis() - time) + " with size of " + bytes.length + " bytes");
    }

    public void testUnmarshallWithCompressionPerformance() throws Exception {
        long time = System.currentTimeMillis();
        int i = ITERATIONS;
        while (i-- > 0) {
            DroolsStreamUtils.streamIn((byte[])compressedBytes, (boolean)true);
        }
        System.out.println("Total time of unmarshalling with compression " + ITERATIONS + " times is " + LargeRuleBaseSerializationTest.format(System.currentTimeMillis() - time));
    }

    public void testMarshallWithCompressionPerformance() throws Exception {
        long time = System.currentTimeMillis();
        int i = ITERATIONS;
        while (i-- > 0) {
            DroolsStreamUtils.streamOut((Object)ruleBase, (boolean)true);
        }
        System.out.println("Total time of marshalling with compression " + ITERATIONS + " times is " + LargeRuleBaseSerializationTest.format(System.currentTimeMillis() - time) + " with size of " + compressedBytes.length + " bytes");
    }

    private static String format(long time) {
        StringBuilder sb = new StringBuilder();
        if (time / 3600000L > 0L) {
            sb.append(time / 3600000L).append(':');
            time -= time / 3600000L * 3600000L;
        }
        if (time / 60000L > 0L) {
            sb.append(time / 60000L).append(':');
            time -= time / 60000L * 60000L;
        }
        sb.append((double)time * 1.0 / 1000.0);
        return sb.toString();
    }

    private static RuleBase createRuleBase() throws DroolsParserException {
        System.out.println("Generating " + RULE_COUNT + " rules");
        StringBuilder sb = new StringBuilder(LargeRuleBase.getHeader());
        for (int i = 0; i < RULE_COUNT; ++i) {
            sb.append(LargeRuleBase.getTemplate1("testRule" + i, i));
        }
        System.out.println("Parsing " + RULE_COUNT + " rules");
        PackageBuilder pkgBuilder = new PackageBuilder();
        DrlParser ps = new DrlParser();
        PackageDescr pkgDescr = ps.parse((Reader)new StringReader(sb.toString()));
        pkgBuilder.addPackage(pkgDescr);
        Package pkg = pkgBuilder.getPackage();
        ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        return ruleBase;
    }
}

