/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.Cheesery;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.base.CopyIdentifiersGlobalExporter;
import org.drools.base.MapGlobalResolver;
import org.drools.base.ReferenceOriginalGlobalExporter;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.command.Command;
import org.drools.command.CommandFactory;
import org.drools.compiler.PackageBuilder;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.rule.Package;
import org.drools.runtime.BatchExecutionResults;
import org.drools.runtime.StatelessKnowledgeSession;
import org.drools.runtime.rule.QueryResults;
import org.drools.runtime.rule.QueryResultsRow;
import org.drools.spi.GlobalExporter;
import org.drools.spi.GlobalResolver;

public class StatelessSessionTest
extends TestCase {
    final List list = new ArrayList();
    final Cheesery cheesery = new Cheesery();
    final GlobalResolver globalResolver = new MapGlobalResolver();

    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    public void testSingleObjectAssert() throws Exception {
        StatelessKnowledgeSession session = this.getSession2("literal_rule_test.drl");
        Cheese stilton = new Cheese("stilton", 5);
        session.execute((Object)stilton);
        StatelessSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testArrayObjectAssert() throws Exception {
        StatelessKnowledgeSession session = this.getSession2("literal_rule_test.drl");
        Cheese stilton = new Cheese("stilton", 5);
        session.execute(Arrays.asList(stilton));
        StatelessSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testCollectionObjectAssert() throws Exception {
        StatelessKnowledgeSession session = this.getSession2("literal_rule_test.drl");
        Cheese stilton = new Cheese("stilton", 5);
        ArrayList<Cheese> collection = new ArrayList<Cheese>();
        collection.add(stilton);
        session.execute(collection);
        StatelessSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testInsertObject() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( 30 ); \n";
        str = str + "end\n";
        Cheese stilton = new Cheese("stilton", 5);
        StatelessKnowledgeSession ksession = this.getSession2(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        Command cmd = CommandFactory.newInsertObject((Object)stilton, (String)"outStilton");
        BatchExecutionResults result = ksession.execute(cmd);
        stilton = (Cheese)result.getValue("outStilton");
        StatelessSessionTest.assertEquals((int)30, (int)stilton.getPrice());
    }

    public void testSetGlobal() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "global java.util.List list1 \n";
        str = str + "global java.util.List list2 \n";
        str = str + "global java.util.List list3 \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    $c : Cheese() \n";
        str = str + " \n";
        str = str + "  then \n";
        str = str + "    $c.setPrice( 30 ); \n";
        str = str + "    list1.add( $c ); \n";
        str = str + "    list2.add( $c ); \n";
        str = str + "    list3.add( $c ); \n";
        str = str + "end\n";
        Cheese stilton = new Cheese("stilton", 5);
        ArrayList list1 = new ArrayList();
        List list2 = new ArrayList();
        List list3 = new ArrayList();
        StatelessKnowledgeSession ksession = this.getSession2(ResourceFactory.newByteArrayResource((byte[])str.getBytes()));
        Command setGlobal1 = CommandFactory.newSetGlobal((String)"list1", list1);
        Command setGlobal2 = CommandFactory.newSetGlobal((String)"list2", list2, (boolean)true);
        Command setGlobal3 = CommandFactory.newSetGlobal((String)"list3", list3, (String)"outList3");
        Command insert = CommandFactory.newInsertObject((Object)stilton);
        ArrayList<Command> cmds = new ArrayList<Command>();
        cmds.add(setGlobal1);
        cmds.add(setGlobal2);
        cmds.add(setGlobal3);
        cmds.add(insert);
        BatchExecutionResults result = ksession.execute(CommandFactory.newBatchExecution(cmds));
        StatelessSessionTest.assertEquals((int)30, (int)stilton.getPrice());
        StatelessSessionTest.assertNull((Object)result.getValue("list1"));
        list2 = (List)result.getValue("list2");
        StatelessSessionTest.assertEquals((int)1, (int)list2.size());
        StatelessSessionTest.assertSame((Object)stilton, list2.get(0));
        list3 = (List)result.getValue("outList3");
        StatelessSessionTest.assertEquals((int)1, (int)list3.size());
        StatelessSessionTest.assertSame((Object)stilton, list3.get(0));
    }

    public void testQuery() throws Exception {
        String str = "";
        str = str + "package org.drools.test  \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "query cheeses \n";
        str = str + "    stilton : Cheese(type == 'stilton') \n";
        str = str + "    cheddar : Cheese(type == 'cheddar', price == stilton.price) \n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            StatelessSessionTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatelessKnowledgeSession ksession = kbase.newStatelessKnowledgeSession();
        Cheese stilton1 = new Cheese("stilton", 1);
        Cheese cheddar1 = new Cheese("cheddar", 1);
        Cheese stilton2 = new Cheese("stilton", 2);
        Cheese cheddar2 = new Cheese("cheddar", 2);
        Cheese stilton3 = new Cheese("stilton", 3);
        Cheese cheddar3 = new Cheese("cheddar", 3);
        HashSet set = new HashSet();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(stilton1);
        list.add(cheddar1);
        set.add(list);
        list = new ArrayList();
        list.add(stilton2);
        list.add(cheddar2);
        set.add(list);
        list = new ArrayList();
        list.add(stilton3);
        list.add(cheddar3);
        set.add(list);
        ArrayList<Command> cmds = new ArrayList<Command>();
        cmds.add(CommandFactory.newInsertObject((Object)stilton1));
        cmds.add(CommandFactory.newInsertObject((Object)stilton2));
        cmds.add(CommandFactory.newInsertObject((Object)stilton3));
        cmds.add(CommandFactory.newInsertObject((Object)cheddar1));
        cmds.add(CommandFactory.newInsertObject((Object)cheddar2));
        cmds.add(CommandFactory.newInsertObject((Object)cheddar3));
        cmds.add(CommandFactory.newQuery((String)"cheeses", (String)"cheeses"));
        BatchExecutionResults batchResult = ksession.execute(CommandFactory.newBatchExecution(cmds));
        QueryResults results = (QueryResults)batchResult.getValue("cheeses");
        StatelessSessionTest.assertEquals((int)3, (int)results.size());
        StatelessSessionTest.assertEquals((int)2, (int)results.getIdentifiers().length);
        HashSet<ArrayList<Object>> newSet = new HashSet<ArrayList<Object>>();
        for (QueryResultsRow result : results) {
            list = new ArrayList();
            list.add(result.get("stilton"));
            list.add(result.get("cheddar"));
            newSet.add(list);
        }
        StatelessSessionTest.assertEquals(set, newSet);
    }

    public void testAsynSingleOjbectcAssert() throws Exception {
        StatelessSession session = this.getSession();
        Cheese stilton = new Cheese("stilton", 5);
        session.asyncExecute((Object)stilton);
        Thread.sleep(300L);
        StatelessSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testAsynArrayOjbectcAssert() throws Exception {
        StatelessSession session = this.getSession();
        Cheese stilton = new Cheese("stilton", 5);
        session.asyncExecute(new Object[]{stilton});
        Thread.sleep(100L);
        StatelessSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testAsynCollectionOjbectcAssert() throws Exception {
        StatelessSession session = this.getSession();
        Cheese stilton = new Cheese("stilton", 5);
        ArrayList<Cheese> collection = new ArrayList<Cheese>();
        collection.add(stilton);
        session.execute(collection);
        Thread.sleep(100L);
        StatelessSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testCopyIdentifierGlobalExporterOneValue() throws Exception {
        StatelessSession session = this.getSession();
        session.setGlobalExporter((GlobalExporter)new CopyIdentifiersGlobalExporter(new String[]{"list"}));
        StatelessSessionResult result = session.executeWithResults((Object)null);
        StatelessSessionTest.assertSame((Object)this.list, (Object)result.getGlobal("list"));
        StatelessSessionTest.assertNull((Object)result.getGlobal("cheesery"));
        StatelessSessionTest.assertNotSame((Object)this.globalResolver, (Object)result.getGlobalResolver());
    }

    public void testCopyIdentifierGlobalExporterTwoValues() throws Exception {
        StatelessSession session = this.getSession();
        session.setGlobalExporter((GlobalExporter)new CopyIdentifiersGlobalExporter(new String[]{"list", "cheesery"}));
        StatelessSessionResult result = session.executeWithResults((Object)null);
        StatelessSessionTest.assertSame((Object)this.list, (Object)result.getGlobal("list"));
        StatelessSessionTest.assertSame((Object)this.cheesery, (Object)result.getGlobal("cheesery"));
        StatelessSessionTest.assertNotSame((Object)this.globalResolver, (Object)result.getGlobalResolver());
    }

    public void testCopyIdentifierGlobalExporterAllValues() throws Exception {
        StatelessSession session = this.getSession();
        session.setGlobalExporter((GlobalExporter)new CopyIdentifiersGlobalExporter());
        StatelessSessionResult result = session.executeWithResults((Object)null);
        StatelessSessionTest.assertSame((Object)this.list, (Object)result.getGlobal("list"));
        StatelessSessionTest.assertSame((Object)this.cheesery, (Object)result.getGlobal("cheesery"));
        StatelessSessionTest.assertNotSame((Object)this.globalResolver, (Object)result.getGlobalResolver());
    }

    public void testReferenceOriginalGlobalExporter() throws Exception {
        StatelessSession session = this.getSession();
        session.setGlobalExporter((GlobalExporter)new ReferenceOriginalGlobalExporter());
        StatelessSessionResult result = session.executeWithResults((Object)null);
        StatelessSessionTest.assertSame((Object)this.list, (Object)result.getGlobal("list"));
        StatelessSessionTest.assertSame((Object)this.cheesery, (Object)result.getGlobal("cheesery"));
        StatelessSessionTest.assertSame((Object)this.globalResolver, (Object)result.getGlobalResolver());
    }

    private StatelessSession getSession() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("literal_rule_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatelessSession session = ruleBase.newStatelessSession();
        session = SerializationHelper.serializeObject(session);
        session.setGlobalResolver(this.globalResolver);
        session.setGlobal("list", (Object)this.list);
        session.setGlobal("cheesery", (Object)this.cheesery);
        return session;
    }

    private StatelessKnowledgeSession getSession2(String fileName) throws Exception {
        return this.getSession2(ResourceFactory.newClassPathResource((String)fileName, ((Object)((Object)this)).getClass()));
    }

    private StatelessKnowledgeSession getSession2(Resource resource) throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(resource, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
        }
        StatelessSessionTest.assertFalse((boolean)kbuilder.hasErrors());
        Collection pkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatelessKnowledgeSession session = kbase.newStatelessKnowledgeSession();
        session.setGlobal("list", (Object)this.list);
        session.setGlobal("cheesery", (Object)this.cheesery);
        return session;
    }
}

