/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests.manners;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.common.InternalRuleBase;
import org.drools.compiler.PackageBuilder;
import org.drools.integrationtests.manners.Context;
import org.drools.integrationtests.manners.Guest;
import org.drools.integrationtests.manners.Hobby;
import org.drools.integrationtests.manners.LastSeat;
import org.drools.integrationtests.manners.Sex;
import org.drools.reteoo.AlphaNetworkCompiler;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.rule.Package;

public class MannersBenchmark {
    private int numGuests = 16;
    private int numSeats = 16;
    private int minHobbies = 2;
    private int maxHobbies = 3;

    public static void main(String[] args) throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(MannersBenchmark.class.getResourceAsStream("manners.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        AlphaNetworkCompiler compiler = new AlphaNetworkCompiler();
        for (ObjectTypeNode node : ((InternalRuleBase)ruleBase).getRete().getObjectTypeNodes()) {
            compiler.compile(node);
        }
    }

    protected static List getInputObjects(InputStream inputStream) throws IOException {
        String line;
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = br.readLine()) != null) {
            if (line.trim().length() == 0 || line.trim().startsWith(";")) continue;
            StringTokenizer st = new StringTokenizer(line, "() ");
            String type = st.nextToken();
            if ("guest".equals(type)) {
                if (!"name".equals(st.nextToken())) {
                    throw new IOException("expected 'name' in: " + line);
                }
                String name = st.nextToken();
                if (!"sex".equals(st.nextToken())) {
                    throw new IOException("expected 'sex' in: " + line);
                }
                String sex = st.nextToken();
                if (!"hobby".equals(st.nextToken())) {
                    throw new IOException("expected 'hobby' in: " + line);
                }
                String hobby = st.nextToken();
                Guest guest = new Guest(name, Sex.resolve(sex), Hobby.resolve(hobby));
                list.add(guest);
            }
            if ("last_seat".equals(type)) {
                if (!"seat".equals(st.nextToken())) {
                    throw new IOException("expected 'seat' in: " + line);
                }
                list.add(new LastSeat(new Integer(st.nextToken())));
            }
            if (!"context".equals(type)) continue;
            if (!"state".equals(st.nextToken())) {
                throw new IOException("expected 'state' in: " + line);
            }
            list.add(new Context(st.nextToken()));
        }
        inputStream.close();
        return list;
    }

    private InputStream generateData() {
        String LINE_SEPARATOR = System.getProperty("line.separator");
        StringWriter writer = new StringWriter();
        int maxMale = this.numGuests / 2;
        int maxFemale = this.numGuests / 2;
        int maleCount = 0;
        int femaleCount = 0;
        ArrayList<String> hobbyList = new ArrayList<String>();
        for (int i = 1; i <= this.maxHobbies; ++i) {
            hobbyList.add("h" + i);
        }
        Random rnd = new Random();
        for (int i = 1; i <= this.numGuests; ++i) {
            char sex;
            char c = sex = rnd.nextBoolean() ? (char)'m' : 'f';
            if (sex == 'm' && maleCount == maxMale) {
                sex = 'f';
            }
            if (sex == 'f' && femaleCount == maxFemale) {
                sex = 'm';
            }
            if (sex == 'm') {
                ++maleCount;
            }
            if (sex == 'f') {
                ++femaleCount;
            }
            ArrayList guestHobbies = new ArrayList(hobbyList);
            int numHobbies = this.minHobbies + rnd.nextInt(this.maxHobbies - this.minHobbies + 1);
            for (int j = 0; j < numHobbies; ++j) {
                int hobbyIndex = rnd.nextInt(guestHobbies.size());
                String hobby = (String)guestHobbies.get(hobbyIndex);
                writer.write("(guest (name n" + i + ") (sex " + sex + ") (hobby " + hobby + "))" + LINE_SEPARATOR);
                guestHobbies.remove(hobbyIndex);
            }
        }
        writer.write("(last_seat (seat " + this.numSeats + "))" + LINE_SEPARATOR);
        writer.write(LINE_SEPARATOR);
        writer.write("(context (state start))" + LINE_SEPARATOR);
        return new ByteArrayInputStream(writer.getBuffer().toString().getBytes());
    }
}

