/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.drools.RuleBaseConfiguration;
import org.drools.common.InternalRuleBase;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.integrationtests.LargeRuleBase;
import org.drools.lang.descr.PackageDescr;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.Package;
import org.drools.rule.Rule;

public class ReteooBuilderPerformanceTest
extends TestCase {
    private static final int RULE_COUNT = Integer.parseInt(System.getProperty("rule.count", "1000"));
    private static final int RETEBUILDER_COUNT = Integer.parseInt(System.getProperty("retebuilder.count", "1"));
    private static final int MILLIS_IN_SECOND = 1000;
    private static final int MILLIS_IN_MINUTE = 60000;
    private static final int MILLIS_IN_HOUR = 3600000;

    public void testReteBuilder() throws DroolsParserException {
        ReteooBuilderPerformanceTest.addRules(ReteooBuilderPerformanceTest.generatePackage(RULE_COUNT));
    }

    private static void addRules(Package pkg) {
        ReteooBuilder[] reteBuilders = ReteooBuilderPerformanceTest.getReteBuilders(RETEBUILDER_COUNT);
        System.out.println("Adding rules to ReteBuilder");
        long start = System.currentTimeMillis();
        for (ReteooBuilder reteBuilder : reteBuilders) {
            for (Rule rule : pkg.getRules()) {
                reteBuilder.addRule(rule);
            }
        }
        System.out.println("Added " + RULE_COUNT + " rules to each ReteBuilder's in " + ReteooBuilderPerformanceTest.format(System.currentTimeMillis() - start));
    }

    private static ReteooBuilder[] getReteBuilders(int count) {
        System.out.println("Creating " + count + " ReteBuilder's");
        ReteooBuilder[] reteBuilders = new ReteooBuilder[count];
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        for (int i = 0; i < reteBuilders.length; ++i) {
            reteBuilders[i] = new ReteooBuilder((InternalRuleBase)new ReteooRuleBase(conf));
        }
        return reteBuilders;
    }

    private static Package generatePackage(int ruleCount) throws DroolsParserException {
        StringReader reader = new StringReader(ReteooBuilderPerformanceTest.generateRules(ruleCount));
        System.out.println("Parsing rules");
        PackageDescr pkgDescr = new DrlParser().parse((Reader)reader);
        System.out.println("Generating packages");
        PackageBuilder pkgBuilder = new PackageBuilder(new PackageBuilderConfiguration());
        pkgBuilder.addPackage(pkgDescr);
        return pkgBuilder.getPackage();
    }

    private static String generateRules(int ruleCount) {
        System.out.println("Generating " + ruleCount + " rules");
        StringBuilder sb = new StringBuilder(LargeRuleBase.getHeader());
        for (int i = 1; i <= ruleCount; ++i) {
            sb.append(LargeRuleBase.getTemplate1("testrule" + i, i));
        }
        return sb.toString();
    }

    private static String format(long time) {
        StringBuilder sb = new StringBuilder();
        sb.append(time / 3600000L).append(':');
        sb.append((time %= 3600000L) / 60000L).append(':');
        sb.append((double)(time %= 60000L) * 1.0 / 1000.0);
        return sb.toString();
    }
}

