/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.Map;
import junit.framework.TestCase;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.PackageRegistry;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.DescrFactory;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.Accumulate;
import org.drools.rule.Package;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.java.JavaAccumulateBuilder;
import org.drools.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.rule.builder.dialect.java.JavaExprAnalyzer;

public class JavaAccumulateBuilderTest
extends TestCase {
    private JavaAccumulateBuilder builder;

    protected void setUp() throws Exception {
        super.setUp();
        this.builder = new JavaAccumulateBuilder();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBuildRuleBuildContextBaseDescr() {
        AccumulateDescr accumDescr = new DescrFactory().createAccumulate();
        FieldBindingDescr price = new FieldBindingDescr("price", "$price");
        PatternDescr cheeseDescr = new PatternDescr("org.drools.Cheese");
        cheeseDescr.addConstraint((BaseDescr)price);
        accumDescr.setInputPattern(cheeseDescr);
        accumDescr.setInitCode("int x = 0;");
        accumDescr.setActionCode("x += $price;");
        accumDescr.setResultCode("new Integer( x )");
        PackageBuilder pkgBuilder = new PackageBuilder();
        pkgBuilder.addPackage(new PackageDescr("org.drools"));
        PackageBuilderConfiguration conf = pkgBuilder.getPackageBuilderConfiguration();
        PackageRegistry pkgReg = pkgBuilder.getPackageRegistry("org.drools");
        Package pkg = pkgReg.getPackage();
        DialectCompiletimeRegistry dialectRegistry = pkgReg.getDialectCompiletimeRegistry();
        Dialect dialect = dialectRegistry.getDialect("java");
        RuleDescr ruleDescr = new RuleDescr("test rule");
        RuleBuildContext context = new RuleBuildContext(pkgBuilder, ruleDescr, dialectRegistry, pkg, dialect);
        Accumulate accumulate = (Accumulate)this.builder.build(context, (BaseDescr)accumDescr);
        dialect.compileAll();
        JavaAccumulateBuilderTest.assertTrue((String)context.getErrors().toString(), (boolean)context.getErrors().isEmpty());
    }

    public void testFixInitCode() throws Exception {
        JavaExprAnalyzer analyzer = new JavaExprAnalyzer();
        JavaAccumulateBuilder builder = new JavaAccumulateBuilder();
        String code = "int x = 0;";
        String expected = "x = 0;";
        JavaAnalysisResult analysis = analyzer.analyzeBlock(code, new Map[0]);
        String result = builder.fixInitCode(analysis, code);
        JavaAccumulateBuilderTest.assertEquals((String)expected, (String)result);
        code = "$anExternalVar.method(); \nint aVar = 0, anotherVar=10    ;Integer bla = new Integer( 25);functionCall();\n";
        expected = "$anExternalVar.method(); \naVar = 0;anotherVar=10;bla = new Integer( 25);functionCall();\n";
        analysis = analyzer.analyzeBlock(code, new Map[0]);
        result = builder.fixInitCode(analysis, code);
        JavaAccumulateBuilderTest.assertEquals((String)expected, (String)result);
        code = "$anExternalVar.method(); String[] aVar = new String[] { \"a\", \"b\" }, anotherVar=new String[] { someStringVar }  ;final Integer bla = new Integer( 25);functionCall();\n";
        expected = "$anExternalVar.method(); aVar = new String[] { \"a\", \"b\" };anotherVar=new String[] { someStringVar };bla = new Integer( 25);functionCall();\n";
        analysis = analyzer.analyzeBlock(code, new Map[0]);
        result = builder.fixInitCode(analysis, code);
        JavaAccumulateBuilderTest.assertEquals((String)expected, (String)result);
    }
}

