/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.Map;
import junit.framework.TestCase;
import org.antlr.runtime.RecognitionException;
import org.drools.Cheese;
import org.drools.base.ClassObjectType;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.PackageRegistry;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.ImportDeclaration;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.rule.builder.dialect.java.JavaConsequenceBuilder;
import org.drools.rule.builder.dialect.java.JavaExprAnalyzer;
import org.drools.spi.ObjectType;

public class JavaConsequenceBuilderTest
extends TestCase {
    private JavaConsequenceBuilder builder;
    private RuleBuildContext context;
    private RuleDescr ruleDescr;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void setupTest(String consequence) {
        this.builder = new JavaConsequenceBuilder();
        Package pkg = new Package("org.drools");
        pkg.addImport(new ImportDeclaration("org.drools.Cheese"));
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration();
        PackageBuilder pkgBuilder = new PackageBuilder(pkg, conf);
        this.ruleDescr = new RuleDescr("test consequence builder");
        this.ruleDescr.setConsequence((Object)consequence);
        Rule rule = new Rule(this.ruleDescr.getName());
        rule.addPattern((RuleConditionElement)new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class), "$cheese"));
        PackageRegistry pkgRegistry = pkgBuilder.getPackageRegistry(pkg.getName());
        DialectCompiletimeRegistry reg = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        this.context = new RuleBuildContext(pkgBuilder, this.ruleDescr, reg, pkg, reg.getDialect(pkgRegistry.getDialect()));
        this.context.getBuildStack().push(rule.getLhs());
    }

    public void testFixExitPointsReferences() {
        String consequence = " System.out.println(\"this is a test\");\n  exitPoints[\"foo\"].insert( new Cheese() );\n  System.out.println(\"we are done with exitPoints\");\n ";
        this.setupTest(consequence);
        try {
            JavaExprAnalyzer analyzer = new JavaExprAnalyzer();
            JavaAnalysisResult analysis = analyzer.analyzeBlock((String)this.ruleDescr.getConsequence(), new Map[0]);
            String fixed = this.builder.fixBlockDescr(this.context, analysis, (String)this.ruleDescr.getConsequence());
            String expected = " System.out.println(\"this is a test\");\n  drools.getExitPoint(\"foo\").insert( new Cheese() );\n  System.out.println(\"we are done with exitPoints\");\n ";
            JavaConsequenceBuilderTest.assertNotNull((String)this.context.getErrors().toString(), (Object)fixed);
            this.assertEqualsIgnoreSpaces(expected, fixed);
        }
        catch (RecognitionException e) {
            e.printStackTrace();
        }
    }

    public void testFixEntryPointsReferences() {
        String consequence = " System.out.println(\"this is a test\");\n  entryPoints[\"foo\"].insert( new Cheese() );\n  System.out.println(\"we are done with entryPoints\");\n ";
        this.setupTest(consequence);
        try {
            JavaExprAnalyzer analyzer = new JavaExprAnalyzer();
            JavaAnalysisResult analysis = analyzer.analyzeBlock((String)this.ruleDescr.getConsequence(), new Map[0]);
            String fixed = this.builder.fixBlockDescr(this.context, analysis, (String)this.ruleDescr.getConsequence());
            String expected = " System.out.println(\"this is a test\");\n  drools.getEntryPoint(\"foo\").insert( new Cheese() );\n  System.out.println(\"we are done with entryPoints\");\n ";
            JavaConsequenceBuilderTest.assertNotNull((String)this.context.getErrors().toString(), (Object)fixed);
            this.assertEqualsIgnoreSpaces(expected, fixed);
        }
        catch (RecognitionException e) {
            e.printStackTrace();
        }
    }

    public void testFixModifyBlocks() {
        String consequence = " System.out.println(\"this is a test\");\n  modify( $cheese ) { setPrice( 10 ), setAge( age ) }\n  System.out.println(\"we are done\");\n ";
        this.setupTest(consequence);
        try {
            JavaExprAnalyzer analyzer = new JavaExprAnalyzer();
            JavaAnalysisResult analysis = analyzer.analyzeBlock((String)this.ruleDescr.getConsequence(), new Map[0]);
            String fixed = this.builder.fixBlockDescr(this.context, analysis, (String)this.ruleDescr.getConsequence());
            String expected = " System.out.println(\"this is a test\");\n{ org.drools.Cheese __obj__ = (org.drools.Cheese) ( $cheese );\nmodifyRetract( __obj__ );\n__obj__.setPrice( 10 );\n__obj__.setAge( age );\nmodifyInsert( __obj__ );}\nSystem.out.println(\"we are done\");\n";
            JavaConsequenceBuilderTest.assertNotNull((String)this.context.getErrors().toString(), (Object)fixed);
            this.assertEqualsIgnoreSpaces(expected, fixed);
        }
        catch (RecognitionException e) {
            e.printStackTrace();
        }
    }

    private void assertEqualsIgnoreSpaces(String expected, String fixed) {
        JavaConsequenceBuilderTest.assertEquals((String)expected.replaceAll("\\s+", ""), (String)fixed.replaceAll("\\s+", ""));
    }
}

