/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.HashMap;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.mvel.MVELEvalExpression;
import org.drools.common.InternalFactHandle;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.MockLeftTupleSink;
import org.drools.rule.Declaration;
import org.drools.rule.EvalCondition;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.mvel.InstrumentedBuildContent;
import org.drools.rule.builder.dialect.mvel.InstrumentedDeclarationScopeResolver;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.rule.builder.dialect.mvel.MVELEvalBuilder;
import org.drools.runtime.rule.FactHandle;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;
import org.drools.spi.Tuple;

public class MVELEvalBuilderTest
extends TestCase {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    protected void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    public void testSimpleExpression() {
        Package pkg = new Package("pkg1");
        RuleDescr ruleDescr = new RuleDescr("rule 1");
        PackageBuilder pkgBuilder = new PackageBuilder(pkg);
        PackageBuilderConfiguration conf = pkgBuilder.getPackageBuilderConfiguration();
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        MVELDialect mvelDialect = (MVELDialect)dialectRegistry.getDialect("mvel");
        InstrumentedBuildContent context = new InstrumentedBuildContent(pkgBuilder, ruleDescr, dialectRegistry, pkg, (Dialect)mvelDialect);
        InstrumentedDeclarationScopeResolver declarationResolver = new InstrumentedDeclarationScopeResolver();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "price", ((Object)((Object)this)).getClass().getClassLoader());
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Integer.TYPE));
        Declaration declaration = new Declaration("a", (InternalReadAccessor)extractor, pattern);
        HashMap<String, Declaration> map = new HashMap<String, Declaration>();
        map.put("a", declaration);
        declarationResolver.setDeclarations(map);
        context.setDeclarationResolver(declarationResolver);
        EvalDescr evalDescr = new EvalDescr();
        evalDescr.setContent((Object)"a == 10");
        MVELEvalBuilder builder = new MVELEvalBuilder();
        EvalCondition eval = (EvalCondition)builder.build((RuleBuildContext)context, (BaseDescr)evalDescr);
        ((MVELEvalExpression)eval.getEvalExpression()).compile(Thread.currentThread().getContextClassLoader());
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        StatefulSession wm = ruleBase.newStatefulSession();
        MockLeftTupleSink sink = new MockLeftTupleSink();
        Cheese cheddar = new Cheese("cheddar", 10);
        InternalFactHandle f0 = (InternalFactHandle)wm.insert((Object)cheddar);
        LeftTuple tuple = new LeftTuple(f0, (LeftTupleSink)sink, true);
        Object evalContext = eval.createContext();
        MVELEvalBuilderTest.assertTrue((boolean)eval.isAllowed((Tuple)tuple, (WorkingMemory)wm, evalContext));
        cheddar.setPrice(9);
        wm.update((FactHandle)f0, (Object)cheddar);
        MVELEvalBuilderTest.assertFalse((boolean)eval.isAllowed((Tuple)tuple, (WorkingMemory)wm, evalContext));
    }
}

