/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.ValueType;
import org.drools.base.evaluators.Operator;
import org.drools.base.mvel.MVELReturnValueExpression;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.RightTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.ReturnValueRestriction;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.mvel.InstrumentedBuildContent;
import org.drools.rule.builder.dialect.mvel.InstrumentedDeclarationScopeResolver;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.rule.builder.dialect.mvel.MVELReturnValueBuilder;
import org.drools.runtime.rule.FactHandle;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;
import org.drools.spi.Tuple;

public class MVELReturnValueBuilderTest
extends TestCase {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    protected void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    public void testSimpleExpression() {
        ArrayList list;
        Package pkg = new Package("pkg1");
        RuleDescr ruleDescr = new RuleDescr("rule 1");
        PackageBuilder pkgBuilder = new PackageBuilder(pkg);
        PackageBuilderConfiguration conf = pkgBuilder.getPackageBuilderConfiguration();
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        MVELDialect mvelDialect = (MVELDialect)dialectRegistry.getDialect("mvel");
        InstrumentedBuildContent context = new InstrumentedBuildContent(pkgBuilder, ruleDescr, dialectRegistry, pkg, (Dialect)mvelDialect);
        InstrumentedDeclarationScopeResolver declarationResolver = new InstrumentedDeclarationScopeResolver();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "price", ((Object)((Object)this)).getClass().getClassLoader());
        Pattern patternA = new Pattern(0, (ObjectType)new ClassObjectType(Integer.TYPE));
        Pattern patternB = new Pattern(1, (ObjectType)new ClassObjectType(Integer.TYPE));
        Declaration a = new Declaration("a", (InternalReadAccessor)extractor, patternA);
        Declaration b = new Declaration("b", (InternalReadAccessor)extractor, patternB);
        HashMap<String, Declaration> map = new HashMap<String, Declaration>();
        map.put("a", a);
        map.put("b", b);
        declarationResolver.setDeclarations(map);
        context.setDeclarationResolver(declarationResolver);
        ReturnValueRestrictionDescr returnValueDescr = new ReturnValueRestrictionDescr("=");
        returnValueDescr.setContent((Object)"a + b");
        MVELReturnValueBuilder builder = new MVELReturnValueBuilder();
        List[] usedIdentifiers = new ArrayList[2];
        usedIdentifiers[1] = list = new ArrayList();
        Declaration[] previousDeclarations = new Declaration[]{a, b};
        Declaration[] localDeclarations = new Declaration[]{};
        String[] requiredGlobals = new String[]{};
        ReturnValueRestriction returnValue = new ReturnValueRestriction((InternalReadAccessor)extractor, previousDeclarations, localDeclarations, requiredGlobals, context.getConfiguration().getEvaluatorRegistry().getEvaluator(ValueType.PINTEGER_TYPE, Operator.EQUAL));
        builder.build((RuleBuildContext)context, usedIdentifiers, previousDeclarations, localDeclarations, returnValue, returnValueDescr);
        ((MVELReturnValueExpression)returnValue.getExpression()).compile(Thread.currentThread().getContextClassLoader());
        ContextEntry retValContext = returnValue.createContextEntry();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        InternalWorkingMemory wm = (InternalWorkingMemory)ruleBase.newStatefulSession();
        Cheese stilton = new Cheese("stilton", 10);
        Cheese cheddar = new Cheese("cheddar", 10);
        InternalFactHandle f0 = (InternalFactHandle)wm.insert((Object)cheddar);
        LeftTuple tuple = new LeftTuple(f0, null, true);
        InternalFactHandle f1 = (InternalFactHandle)wm.insert((Object)stilton);
        tuple = new LeftTuple(tuple, new RightTuple(f1, null), null, true);
        Cheese brie = new Cheese("brie", 20);
        InternalFactHandle f2 = (InternalFactHandle)wm.insert((Object)brie);
        MVELReturnValueBuilderTest.assertTrue((boolean)returnValue.isAllowed((InternalReadAccessor)extractor, f2, (Tuple)tuple, (WorkingMemory)wm, retValContext));
        brie.setPrice(18);
        wm.update((FactHandle)f2, (Object)brie);
        MVELReturnValueBuilderTest.assertFalse((boolean)returnValue.isAllowed((InternalReadAccessor)extractor, f2, (Tuple)tuple, (WorkingMemory)wm, retValContext));
    }
}

