/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.HashMap;
import java.util.Map;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.base.mvel.MVELCompileable;
import org.drools.base.mvel.MVELConsequence;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.Dialect;
import org.drools.rule.Declaration;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.builder.ConsequenceBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.spi.Consequence;
import org.drools.spi.Wireable;
import org.mvel2.Macro;
import org.mvel2.MacroProcessor;

public class MVELConsequenceBuilder
implements ConsequenceBuilder {
    private static final Map<String, Macro> macros = new HashMap<String, Macro>(10);

    public void build(RuleBuildContext context) {
        context.getBuildStack().push((RuleConditionElement)context.getRule().getLhs());
        try {
            MVELDialect dialect = (MVELDialect)context.getDialect(context.getDialect().getId());
            String text = MVELConsequenceBuilder.processMacros((String)context.getRuleDescr().getConsequence());
            Dialect.AnalysisResult analysis = dialect.analyzeBlock(context, context.getRuleDescr(), dialect.getInterceptors(), text, new Map[]{context.getDeclarationResolver().getDeclarationClasses(context.getRule()), context.getPackageBuilder().getGlobals()}, null);
            Declaration[] previousDeclarations = context.getDeclarationResolver().getDeclarations(context.getRule()).values().toArray(new Declaration[context.getDeclarationResolver().getDeclarations(context.getRule()).size()]);
            MVELCompilationUnit unit = dialect.getMVELCompilationUnit(text, analysis, previousDeclarations, null, null, context);
            MVELConsequence expr = new MVELConsequence(unit, dialect.getId());
            context.getRule().setConsequence((Consequence)expr);
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData(context.getDialect().getId());
            data.addCompileable((Wireable)context.getRule(), (MVELCompileable)expr);
            expr.compile((ClassLoader)context.getPackageBuilder().getRootClassLoader());
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), context.getRuleDescr(), null, "Unable to build expression for 'consequence': " + e.getMessage() + " '" + context.getRuleDescr().getConsequence() + "'"));
        }
    }

    public static String processMacros(String consequence) {
        MacroProcessor macroProcessor = new MacroProcessor();
        macroProcessor.setMacros(macros);
        return macroProcessor.parse(MVELConsequenceBuilder.delimitExpressions(consequence));
    }

    public static String delimitExpressions(String s) {
        StringBuffer result = new StringBuffer();
        char[] cs = s.toCharArray();
        int brace = 0;
        int sqre = 0;
        int crly = 0;
        int lastNonWhite = 59;
        for (int i = 0; i < cs.length; ++i) {
            int c = cs[i];
            switch (c) {
                case 40: {
                    ++brace;
                    break;
                }
                case 123: {
                    ++crly;
                    break;
                }
                case 91: {
                    ++sqre;
                    break;
                }
                case 41: {
                    --brace;
                    break;
                }
                case 125: {
                    --crly;
                    break;
                }
                case 93: {
                    --sqre;
                    break;
                }
            }
            if (brace == 0 && sqre == 0 && crly == 0 && (c == 10 || c == 13)) {
                if (lastNonWhite != 59) {
                    result.append(';');
                    lastNonWhite = 59;
                }
            } else if (!Character.isWhitespace((char)c)) {
                lastNonWhite = c;
            }
            result.append((char)c);
        }
        return result.toString();
    }

    static {
        macros.put("insert", new Macro(){

            public String doMacro() {
                return "drools.insert";
            }
        });
        macros.put("insertLogical", new Macro(){

            public String doMacro() {
                return "drools.insertLogical";
            }
        });
        macros.put("modify", new Macro(){

            public String doMacro() {
                return "@Modify with";
            }
        });
        macros.put("update", new Macro(){

            public String doMacro() {
                return "drools.update";
            }
        });
        macros.put("retract", new Macro(){

            public String doMacro() {
                return "drools.retract";
            }
        });
        macros.put("entryPoints", new Macro(){

            public String doMacro() {
                return "drools.entryPoints";
            }
        });
        macros.put("exitPoints", new Macro(){

            public String doMacro() {
                return "drools.exitPoints";
            }
        });
    }
}

