/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.modeldriven.dt;

import java.util.HashMap;
import junit.framework.TestCase;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.guvnor.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.guvnor.client.modeldriven.dt.AttributeCol;
import org.drools.guvnor.client.modeldriven.dt.ConditionCol;
import org.drools.guvnor.client.modeldriven.dt.DTColumnConfig;
import org.drools.guvnor.client.modeldriven.dt.GuidedDecisionTable;

public class GuidedDecisionTableTest
extends TestCase {
    public void testValueLists() {
        GuidedDecisionTable dt = new GuidedDecisionTable();
        ConditionCol c1 = new ConditionCol();
        c1.boundName = "c1";
        c1.factType = "Driver";
        c1.factField = "name";
        c1.constraintValueType = 1;
        dt.conditionCols.add(c1);
        ConditionCol c1_ = new ConditionCol();
        c1_.boundName = "c1";
        c1_.factType = "Driver";
        c1_.factField = "name";
        c1_.constraintValueType = 3;
        dt.conditionCols.add(c1_);
        ConditionCol c1__ = new ConditionCol();
        c1__.boundName = "c1";
        c1__.factType = "Driver";
        c1__.factField = "name";
        c1__.constraintValueType = 1;
        c1__.valueList = "one,two,three";
        dt.conditionCols.add(c1__);
        ConditionCol c2 = new ConditionCol();
        c2.boundName = "c2";
        c2.factType = "Driver";
        c2.factField = "nothing";
        c2.constraintValueType = 1;
        dt.conditionCols.add(c2);
        ActionSetFieldCol asf = new ActionSetFieldCol();
        asf.boundName = "c1";
        asf.factField = "name";
        dt.actionCols.add(asf);
        ActionInsertFactCol ins = new ActionInsertFactCol();
        ins.boundName = "x";
        ins.factField = "rating";
        ins.factType = "Person";
        dt.actionCols.add(ins);
        ActionInsertFactCol ins_ = new ActionInsertFactCol();
        ins_.boundName = "x";
        ins_.factField = "rating";
        ins_.factType = "Person";
        ins_.valueList = "one,two,three";
        dt.actionCols.add(ins_);
        ActionSetFieldCol asf_ = new ActionSetFieldCol();
        asf_.boundName = "c1";
        asf_.factField = "goo";
        dt.actionCols.add(asf_);
        ActionSetFieldCol asf__ = new ActionSetFieldCol();
        asf__.boundName = "c1";
        asf__.factField = "goo";
        asf__.valueList = "one,two,three";
        dt.actionCols.add(asf__);
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.dataEnumLists.put("Driver.name", new String[]{"bob", "michael"});
        sce.dataEnumLists.put("Person.rating", new String[]{"1", "2"});
        String[] r = dt.getValueList((DTColumnConfig)c1, sce);
        GuidedDecisionTableTest.assertEquals((int)2, (int)r.length);
        GuidedDecisionTableTest.assertEquals((String)"bob", (String)r[0]);
        GuidedDecisionTableTest.assertEquals((String)"michael", (String)r[1]);
        GuidedDecisionTableTest.assertEquals((int)0, (int)dt.getValueList((DTColumnConfig)c1_, sce).length);
        r = dt.getValueList((DTColumnConfig)c1__, sce);
        GuidedDecisionTableTest.assertEquals((int)3, (int)r.length);
        GuidedDecisionTableTest.assertEquals((String)"one", (String)r[0]);
        GuidedDecisionTableTest.assertEquals((String)"two", (String)r[1]);
        GuidedDecisionTableTest.assertEquals((String)"three", (String)r[2]);
        GuidedDecisionTableTest.assertEquals((int)0, (int)dt.getValueList((DTColumnConfig)c2, sce).length);
        r = dt.getValueList((DTColumnConfig)asf, sce);
        GuidedDecisionTableTest.assertEquals((int)2, (int)r.length);
        GuidedDecisionTableTest.assertEquals((String)"bob", (String)r[0]);
        GuidedDecisionTableTest.assertEquals((String)"michael", (String)r[1]);
        r = dt.getValueList((DTColumnConfig)ins, sce);
        GuidedDecisionTableTest.assertEquals((int)2, (int)r.length);
        GuidedDecisionTableTest.assertEquals((String)"1", (String)r[0]);
        GuidedDecisionTableTest.assertEquals((String)"2", (String)r[1]);
        r = dt.getValueList((DTColumnConfig)ins_, sce);
        GuidedDecisionTableTest.assertEquals((int)3, (int)r.length);
        GuidedDecisionTableTest.assertEquals((String)"one", (String)r[0]);
        GuidedDecisionTableTest.assertEquals((String)"two", (String)r[1]);
        GuidedDecisionTableTest.assertEquals((String)"three", (String)r[2]);
        GuidedDecisionTableTest.assertEquals((int)0, (int)dt.getValueList((DTColumnConfig)asf_, sce).length);
        r = dt.getValueList((DTColumnConfig)asf__, sce);
        GuidedDecisionTableTest.assertEquals((int)3, (int)r.length);
        GuidedDecisionTableTest.assertEquals((String)"one", (String)r[0]);
        GuidedDecisionTableTest.assertEquals((String)"two", (String)r[1]);
        GuidedDecisionTableTest.assertEquals((String)"three", (String)r[2]);
        AttributeCol at = new AttributeCol();
        at.attr = "no-loop";
        dt.attributeCols.add(at);
        r = dt.getValueList((DTColumnConfig)at, sce);
        GuidedDecisionTableTest.assertEquals((int)2, (int)r.length);
        GuidedDecisionTableTest.assertEquals((String)"true", (String)r[0]);
        GuidedDecisionTableTest.assertEquals((String)"false", (String)r[1]);
        at.attr = "enabled";
        GuidedDecisionTableTest.assertEquals((int)2, (int)dt.getValueList((DTColumnConfig)at, sce).length);
        at.attr = "salience";
        GuidedDecisionTableTest.assertEquals((int)0, (int)dt.getValueList((DTColumnConfig)at, sce).length);
    }

    public void testNumeric() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.fieldTypes = new HashMap();
        sce.fieldTypes.put("Driver.age", "Numeric");
        sce.fieldTypes.put("Driver.name", "String");
        GuidedDecisionTable dt = new GuidedDecisionTable();
        AttributeCol at = new AttributeCol();
        at.attr = "salience";
        AttributeCol at_ = new AttributeCol();
        at_.attr = "enabled";
        dt.attributeCols.add(at);
        dt.attributeCols.add(at_);
        ConditionCol c1 = new ConditionCol();
        c1.boundName = "c1";
        c1.factType = "Driver";
        c1.factField = "name";
        c1.operator = "==";
        c1.constraintValueType = 1;
        dt.conditionCols.add(c1);
        ConditionCol c1_ = new ConditionCol();
        c1_.boundName = "c1";
        c1_.factType = "Driver";
        c1_.factField = "age";
        c1_.operator = "==";
        c1_.constraintValueType = 1;
        dt.conditionCols.add(c1_);
        ConditionCol c2 = new ConditionCol();
        c2.boundName = "c1";
        c2.factType = "Driver";
        c2.factField = "age";
        c2.constraintValueType = 1;
        dt.conditionCols.add(c2);
        ActionSetFieldCol a = new ActionSetFieldCol();
        a.boundName = "c1";
        a.factField = "name";
        dt.actionCols.add(a);
        ActionSetFieldCol a2 = new ActionSetFieldCol();
        a2.boundName = "c1";
        a2.factField = "age";
        dt.actionCols.add(a2);
        ActionInsertFactCol ins = new ActionInsertFactCol();
        ins.boundName = "x";
        ins.factType = "Driver";
        ins.factField = "name";
        dt.actionCols.add(ins);
        ActionInsertFactCol ins_ = new ActionInsertFactCol();
        ins_.boundName = "x";
        ins_.factType = "Driver";
        ins_.factField = "age";
        dt.actionCols.add(ins_);
        GuidedDecisionTableTest.assertTrue((boolean)dt.isNumeric((DTColumnConfig)at, sce));
        GuidedDecisionTableTest.assertFalse((boolean)dt.isNumeric((DTColumnConfig)at_, sce));
        GuidedDecisionTableTest.assertFalse((boolean)dt.isNumeric((DTColumnConfig)c1, sce));
        GuidedDecisionTableTest.assertTrue((boolean)dt.isNumeric((DTColumnConfig)c1_, sce));
        GuidedDecisionTableTest.assertFalse((boolean)dt.isNumeric((DTColumnConfig)a, sce));
        GuidedDecisionTableTest.assertTrue((boolean)dt.isNumeric((DTColumnConfig)a2, sce));
        GuidedDecisionTableTest.assertFalse((boolean)dt.isNumeric((DTColumnConfig)ins, sce));
        GuidedDecisionTableTest.assertTrue((boolean)dt.isNumeric((DTColumnConfig)ins_, sce));
        GuidedDecisionTableTest.assertFalse((boolean)dt.isNumeric((DTColumnConfig)c2, sce));
    }

    public void testNoConstraintLists() {
        GuidedDecisionTable dt = new GuidedDecisionTable();
        ConditionCol c1 = new ConditionCol();
        c1.boundName = "c1";
        c1.factType = "Driver";
        c1.constraintValueType = 1;
        dt.conditionCols.add(c1);
        ConditionCol c2 = new ConditionCol();
        c2.boundName = "c2";
        c2.factType = "Driver";
        c2.constraintValueType = 1;
        c2.valueList = "a,b,c";
        dt.conditionCols.add(c2);
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.dataEnumLists.put("Driver.name", new String[]{"bob", "michael"});
        GuidedDecisionTableTest.assertEquals((int)0, (int)dt.getValueList((DTColumnConfig)c1, sce).length);
        GuidedDecisionTableTest.assertEquals((int)3, (int)dt.getValueList((DTColumnConfig)c2, sce).length);
    }

    public void testNoConstraintsNumeric() {
        GuidedDecisionTable dt = new GuidedDecisionTable();
        ConditionCol c1 = new ConditionCol();
        c1.boundName = "c1";
        c1.factType = "Driver";
        c1.constraintValueType = 1;
        dt.conditionCols.add(c1);
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.fieldTypes = new HashMap();
        sce.fieldTypes.put("Driver.age", "Numeric");
        sce.fieldTypes.put("Driver.name", "String");
        GuidedDecisionTableTest.assertFalse((boolean)dt.isNumeric((DTColumnConfig)c1, sce));
    }
}

