/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.KnowledgeType;
import org.drools.integrationtests.SerializationHelper;
import org.drools.lang.Expander;
import org.drools.lang.dsl.DefaultExpanderResolver;
import org.drools.runtime.StatefulKnowledgeSession;

public class DslTest
extends TestCase {
    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    public void testMultiLineTemplates() throws Exception {
        InputStreamReader source = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("rule_with_expander_multiline.dslr"));
        InputStreamReader dsl = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_dsl_multiline.dsl"));
        Expander ex = new DefaultExpanderResolver((Reader)dsl).get("*", null);
        String r = ex.expand((Reader)source);
        DslTest.assertEquals((String)"when Car(color==\"Red\") then doSomething();", (String)r.trim());
    }

    public void testWithExpanderDSL() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        InputStreamReader source = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("rule_with_expander_dsl.dslr"));
        InputStreamReader dsl = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_expander.dsl"));
        kbuilder.addResource((Reader)dsl, KnowledgeType.DSL);
        kbuilder.addResource((Reader)source, KnowledgeType.DSLR);
        DslTest.assertFalse((boolean)kbuilder.hasErrors());
        String err = kbuilder.getErrors().toString();
        DslTest.assertEquals((String)"", (String)err);
        DslTest.assertEquals((int)0, (int)kbuilder.getErrors().size());
        Collection pkgs = kbuilder.getKnowledgePackages();
        DslTest.assertEquals((int)1, (int)pkgs.size());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        session.insert((Object)new Person("Bob", "http://foo.bar"));
        session.insert((Object)new Cheese("stilton", 42));
        ArrayList messages = new ArrayList();
        session.setGlobal("messages", messages);
        session.fireAllRules();
        DslTest.assertEquals((int)1, (int)messages.size());
    }

    public void testWithExpanderMore() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        InputStreamReader source = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("rule_with_expander_dsl_more.dslr"));
        InputStreamReader dsl = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_expander.dsl"));
        kbuilder.addResource((Reader)dsl, KnowledgeType.DSL);
        kbuilder.addResource((Reader)source, KnowledgeType.DSLR);
        DslTest.assertFalse((boolean)kbuilder.hasErrors());
        String err = kbuilder.getErrors().toString();
        DslTest.assertEquals((String)"", (String)err);
        DslTest.assertEquals((int)0, (int)kbuilder.getErrors().size());
        Collection pkgs = kbuilder.getKnowledgePackages();
        DslTest.assertEquals((int)1, (int)pkgs.size());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        session.insert((Object)new Person("rage"));
        session.insert((Object)new Cheese("cheddar", 15));
        ArrayList messages = new ArrayList();
        session.setGlobal("messages", messages);
        session.fireAllRules();
        DslTest.assertEquals((int)0, (int)messages.size());
        session.insert((Object)new Person("fire"));
        session.fireAllRules();
        DslTest.assertEquals((int)0, (int)messages.size());
        session.insert((Object)new Cheese("brie", 15));
        session.fireAllRules();
        DslTest.assertEquals((int)1, (int)messages.size());
    }

    public void FIXME_estEmptyDSL() throws Exception {
        String DSL = "# This is an empty dsl file.";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        InputStreamReader drlReader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("literal_rule.drl"));
        StringReader dslReader = new StringReader("# This is an empty dsl file.");
        kbuilder.addResource((Reader)dslReader, KnowledgeType.DSL);
        kbuilder.addResource((Reader)drlReader, KnowledgeType.DSLR);
        DslTest.assertFalse((boolean)kbuilder.hasErrors());
        String err = kbuilder.getErrors().toString();
        DslTest.assertEquals((String)"", (String)err);
        DslTest.assertEquals((int)0, (int)kbuilder.getErrors().size());
        Collection pkgs = kbuilder.getKnowledgePackages();
        DslTest.assertEquals((int)0, (int)pkgs.size());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        pkgs = SerializationHelper.serializeObject(pkgs);
        DslTest.assertNull((Object)pkgs);
    }

    public void testDSLWithIndividualConstraintMappings() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        InputStreamReader source = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_dslWithIndividualConstraints.dslr"));
        InputStreamReader dsl = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_dslWithIndividualConstraints.dsl"));
        kbuilder.addResource((Reader)dsl, KnowledgeType.DSL);
        kbuilder.addResource((Reader)source, KnowledgeType.DSLR);
        DslTest.assertFalse((boolean)kbuilder.hasErrors());
        String err = kbuilder.getErrors().toString();
        DslTest.assertEquals((String)"", (String)err);
        DslTest.assertEquals((int)0, (int)kbuilder.getErrors().size());
        Collection pkgs = kbuilder.getKnowledgePackages();
        DslTest.assertEquals((int)1, (int)pkgs.size());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        Cheese cheese = new Cheese("stilton", 42);
        session.insert((Object)cheese);
        session.fireAllRules();
        DslTest.assertEquals((int)1, (int)results.size());
        DslTest.assertEquals((Object)cheese, results.get(0));
    }
}

