/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import junit.framework.TestCase;
import org.drools.Address;
import org.drools.Cell;
import org.drools.Cheese;
import org.drools.FactA;
import org.drools.FactB;
import org.drools.FactC;
import org.drools.Message;
import org.drools.Person;
import org.drools.Primitives;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.base.ClassObjectType;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.integrationtests.IteratorToList;
import org.drools.integrationtests.SerializationHelper;
import org.drools.marshalling.DefaultMarshaller;
import org.drools.marshalling.Marshaller;
import org.drools.marshalling.RuleBaseNodes;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.MapBackedClassLoader;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.runtime.rule.FactHandle;
import org.drools.spi.GlobalResolver;
import org.drools.util.DroolsStreamUtils;

public class MarshallingTest
extends TestCase {
    public void testSerializable() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Serializable.drl"));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        MarshallingTest.assertEquals((int)0, (int)builder.getErrors().getErrors().length);
        RuleBase ruleBase = this.getRuleBase(pkg);
        Map map = new HashMap<String, RuleBase>();
        map.put("x", ruleBase);
        map = SerializationHelper.serializeObject(map);
        ruleBase = (RuleBase)map.get("x");
        Rule[] rules = ruleBase.getPackages()[0].getRules();
        MarshallingTest.assertEquals((int)4, (int)rules.length);
        MarshallingTest.assertEquals((String)"match Person 1", (String)rules[0].getName());
        MarshallingTest.assertEquals((String)"match Person 2", (String)rules[1].getName());
        MarshallingTest.assertEquals((String)"match Person 3", (String)rules[2].getName());
        MarshallingTest.assertEquals((String)"match Integer", (String)rules[3].getName());
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        session.insert((Object)bob);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        MarshallingTest.assertEquals((int)1, (int)IteratorToList.convert(session.iterateObjects()).size());
        MarshallingTest.assertEquals((Object)bob, IteratorToList.convert(session.iterateObjects()).get(0));
        MarshallingTest.assertEquals((int)2, (int)session.getAgenda().agendaSize());
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        MarshallingTest.assertEquals((int)3, (int)list.size());
        MarshallingTest.assertEquals((Object)new Integer(4), list.get(0));
        MarshallingTest.assertEquals((int)2, (int)IteratorToList.convert(session.iterateObjects()).size());
        MarshallingTest.assertTrue((boolean)IteratorToList.convert(session.iterateObjects()).contains(bob));
        MarshallingTest.assertTrue((boolean)IteratorToList.convert(session.iterateObjects()).contains(new Person("help")));
    }

    public void testSerializeWorkingMemoryAndRuleBase1() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Serializable.drl"));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        MarshallingTest.assertEquals((int)0, (int)builder.getErrors().getErrors().length);
        RuleBase ruleBase = this.getRuleBase();
        StatefulSession session = ruleBase.newStatefulSession();
        Map map = new HashMap<String, RuleBase>();
        map.put("x", ruleBase);
        map = SerializationHelper.serializeObject(map);
        ruleBase = (RuleBase)map.get("x");
        ruleBase.addPackage(pkg);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        session.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        session.insert((Object)bob);
        Rule[] rules = ruleBase.getPackages()[0].getRules();
        MarshallingTest.assertEquals((int)4, (int)rules.length);
        MarshallingTest.assertEquals((String)"match Person 1", (String)rules[0].getName());
        MarshallingTest.assertEquals((String)"match Person 2", (String)rules[1].getName());
        MarshallingTest.assertEquals((String)"match Person 3", (String)rules[2].getName());
        MarshallingTest.assertEquals((String)"match Integer", (String)rules[3].getName());
        MarshallingTest.assertEquals((int)1, (int)IteratorToList.convert(session.iterateObjects()).size());
        MarshallingTest.assertEquals((Object)bob, IteratorToList.convert(session.iterateObjects()).get(0));
        MarshallingTest.assertEquals((int)2, (int)session.getAgenda().agendaSize());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        MarshallingTest.assertEquals((int)3, (int)list.size());
        MarshallingTest.assertEquals((Object)new Integer(4), list.get(0));
        MarshallingTest.assertEquals((int)2, (int)IteratorToList.convert(session.iterateObjects()).size());
        MarshallingTest.assertTrue((boolean)IteratorToList.convert(session.iterateObjects()).contains(bob));
        MarshallingTest.assertTrue((boolean)IteratorToList.convert(session.iterateObjects()).contains(new Person("help")));
    }

    public void testSerializeWorkingMemoryAndRuleBase2() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Serializable.drl"));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        MarshallingTest.assertEquals((int)0, (int)builder.getErrors().getErrors().length);
        RuleBase ruleBase = this.getRuleBase();
        Map map = new HashMap<String, RuleBase>();
        map.put("x", ruleBase);
        map = SerializationHelper.serializeObject(map);
        ruleBase = (RuleBase)map.get("x");
        StatefulSession session = ruleBase.newStatefulSession();
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        ruleBase.addPackage(pkg);
        session.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        session.insert((Object)bob);
        Rule[] rules = ruleBase.getPackages()[0].getRules();
        MarshallingTest.assertEquals((int)4, (int)rules.length);
        MarshallingTest.assertEquals((String)"match Person 1", (String)rules[0].getName());
        MarshallingTest.assertEquals((String)"match Person 2", (String)rules[1].getName());
        MarshallingTest.assertEquals((String)"match Person 3", (String)rules[2].getName());
        MarshallingTest.assertEquals((String)"match Integer", (String)rules[3].getName());
        MarshallingTest.assertEquals((int)1, (int)IteratorToList.convert(session.iterateObjects()).size());
        MarshallingTest.assertEquals((Object)bob, IteratorToList.convert(session.iterateObjects()).get(0));
        MarshallingTest.assertEquals((int)2, (int)session.getAgenda().agendaSize());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        MarshallingTest.assertEquals((int)3, (int)list.size());
        MarshallingTest.assertEquals((Object)new Integer(4), list.get(0));
        MarshallingTest.assertEquals((int)2, (int)IteratorToList.convert(session.iterateObjects()).size());
        MarshallingTest.assertTrue((boolean)IteratorToList.convert(session.iterateObjects()).contains(bob));
        MarshallingTest.assertTrue((boolean)IteratorToList.convert(session.iterateObjects()).contains(new Person("help")));
    }

    public void testSerializeWorkingMemoryAndRuleBase3() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Serializable.drl"));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        MarshallingTest.assertEquals((int)0, (int)builder.getErrors().getErrors().length);
        RuleBase ruleBase = this.getRuleBase();
        StatefulSession session = ruleBase.newStatefulSession();
        ruleBase.addPackage(pkg);
        session.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        session.insert((Object)bob);
        Map map = new HashMap<String, RuleBase>();
        map.put("x", ruleBase);
        map = SerializationHelper.serializeObject(map);
        ruleBase = (RuleBase)map.get("x");
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        Rule[] rules = ruleBase.getPackages()[0].getRules();
        MarshallingTest.assertEquals((int)4, (int)rules.length);
        MarshallingTest.assertEquals((String)"match Person 1", (String)rules[0].getName());
        MarshallingTest.assertEquals((String)"match Person 2", (String)rules[1].getName());
        MarshallingTest.assertEquals((String)"match Person 3", (String)rules[2].getName());
        MarshallingTest.assertEquals((String)"match Integer", (String)rules[3].getName());
        MarshallingTest.assertEquals((int)1, (int)IteratorToList.convert(session.iterateObjects()).size());
        MarshallingTest.assertEquals((Object)bob, IteratorToList.convert(session.iterateObjects()).get(0));
        MarshallingTest.assertEquals((int)2, (int)session.getAgenda().agendaSize());
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        MarshallingTest.assertEquals((int)3, (int)list.size());
        MarshallingTest.assertEquals((Object)new Integer(4), list.get(0));
        MarshallingTest.assertEquals((int)2, (int)IteratorToList.convert(session.iterateObjects()).size());
        MarshallingTest.assertTrue((boolean)IteratorToList.convert(session.iterateObjects()).contains(bob));
        MarshallingTest.assertTrue((boolean)IteratorToList.convert(session.iterateObjects()).contains(new Person("help")));
    }

    public void testSerializeAdd() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1.drl")));
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        List list = new ArrayList();
        session.setGlobal("list", list);
        InternalFactHandle stilton = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        session.fireAllRules();
        MarshallingTest.assertEquals((int)list.size(), (int)1);
        MarshallingTest.assertEquals((Object)"stilton", list.get(0));
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        list = (List)session.getGlobal("list");
        MarshallingTest.assertNotNull(list);
        MarshallingTest.assertEquals((int)list.size(), (int)1);
        MarshallingTest.assertEquals((Object)"stilton", list.get(0));
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic3.drl")));
        pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie2 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        InternalFactHandle bob = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        MarshallingTest.assertEquals((int)list.size(), (int)3);
        MarshallingTest.assertEquals((Object)bob.getObject(), list.get(1));
        MarshallingTest.assertEquals((Object)"stilton", list.get(2));
        session.dispose();
    }

    public void testSerializationOfIndexedWM() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Serializable2.drl"));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg = builder.getPackage();
        MarshallingTest.assertEquals((String)builder.getErrors().toString(), (int)0, (int)builder.getErrors().getErrors().length);
        RuleBase ruleBase = this.getRuleBase(pkg);
        Map map = new HashMap<String, RuleBase>();
        map.put("x", ruleBase);
        map = SerializationHelper.serializeObject(map);
        ruleBase = (RuleBase)map.get("x");
        Rule[] rules = ruleBase.getPackages()[0].getRules();
        MarshallingTest.assertEquals((int)3, (int)rules.length);
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("list", new ArrayList());
        Primitives p = new Primitives();
        p.setBytePrimitive((byte)1);
        p.setShortPrimitive((short)2);
        p.setIntPrimitive(3);
        session.insert((Object)p);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        MarshallingTest.assertEquals((int)1, (int)IteratorToList.convert(session.iterateObjects()).size());
        MarshallingTest.assertEquals((Object)p, IteratorToList.convert(session.iterateObjects()).get(0));
        MarshallingTest.assertEquals((int)3, (int)session.getAgenda().agendaSize());
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        MarshallingTest.assertEquals((int)3, (int)list.size());
        MarshallingTest.assertEquals((Object)"1", list.get(0));
        MarshallingTest.assertEquals((Object)"2", list.get(1));
        MarshallingTest.assertEquals((Object)"3", list.get(2));
    }

    public void testSerializeAdd2() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1_0.drl")));
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        List results = new ArrayList();
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("results", results);
        InternalFactHandle stilton1 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        session.insert((Object)new Cheese("brie", 10));
        InternalFactHandle bob = (InternalFactHandle)session.insert((Object)new Person("bob", 10));
        session.fireAllRules();
        MarshallingTest.assertEquals((int)1, (int)results.size());
        MarshallingTest.assertEquals((Object)stilton1.getObject(), results.get(0));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DefaultMarshaller marshaller = new DefaultMarshaller();
        ruleBase.writeStatefulSession(session, (OutputStream)baos, (Marshaller)marshaller);
        GlobalResolver resolver = session.getGlobalResolver();
        byte[] serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
        ruleBase = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
        session = ruleBase.readStatefulSession((InputStream)new ByteArrayInputStream(baos.toByteArray()), (Marshaller)marshaller);
        session.setGlobalResolver(resolver);
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic3_0.drl")));
        pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle mark = (InternalFactHandle)session.insert((Object)new Person("mark", 20));
        session.fireAllRules();
        results = (List)session.getGlobal("results");
        MarshallingTest.assertEquals((int)4, (int)results.size());
        MarshallingTest.assertEquals((Object)bob.getObject(), results.get(1));
        MarshallingTest.assertEquals((Object)stilton2.getObject(), results.get(2));
        MarshallingTest.assertEquals((Object)mark.getObject(), results.get(3));
        serializedRulebase = null;
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
    }

    public void testSerializeAdd_newRuleNotFiredForNewData() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1_0.drl")));
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        List results = new ArrayList();
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("results", results);
        InternalFactHandle stilton1 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie1 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        session.fireAllRules();
        GlobalResolver resolver = session.getGlobalResolver();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DefaultMarshaller marshaller = new DefaultMarshaller();
        ruleBase.writeStatefulSession(session, (OutputStream)baos, (Marshaller)marshaller);
        byte[] serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
        MarshallingTest.assertEquals((int)1, (int)results.size());
        MarshallingTest.assertEquals((Object)stilton1.getObject(), results.get(0));
        ruleBase = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
        session = ruleBase.readStatefulSession((InputStream)new ByteArrayInputStream(baos.toByteArray()), (Marshaller)marshaller);
        session.setGlobalResolver(resolver);
        results = (List)session.getGlobal("results");
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1_1.drl")));
        pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie2 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle brie3 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 30));
        session.fireAllRules();
        MarshallingTest.assertEquals((int)5, (int)results.size());
        MarshallingTest.assertEquals((Object)brie1.getObject(), results.get(1));
        MarshallingTest.assertEquals((Object)stilton2.getObject(), results.get(2));
        MarshallingTest.assertEquals((Object)brie2.getObject(), results.get(4));
        MarshallingTest.assertEquals((Object)brie3.getObject(), results.get(3));
        serializedRulebase = null;
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
    }

    public void testSerializeAdd3() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1_0.drl")));
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        List results = new ArrayList();
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("results", results);
        InternalFactHandle stilton1 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie1 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        session.fireAllRules();
        GlobalResolver resolver = session.getGlobalResolver();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DefaultMarshaller marshaller = new DefaultMarshaller();
        ruleBase.writeStatefulSession(session, (OutputStream)baos, (Marshaller)marshaller);
        byte[] serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
        MarshallingTest.assertEquals((int)1, (int)results.size());
        MarshallingTest.assertEquals((Object)stilton1.getObject(), results.get(0));
        ruleBase = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
        session = ruleBase.readStatefulSession((InputStream)new ByteArrayInputStream(baos.toByteArray()), (Marshaller)marshaller);
        session.setGlobalResolver(resolver);
        results = (List)session.getGlobal("results");
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic3_0.drl")));
        pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie2 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle bob1 = (InternalFactHandle)session.insert((Object)new Person("bob", 20));
        InternalFactHandle bob2 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        MarshallingTest.assertEquals((int)4, (int)results.size());
        MarshallingTest.assertEquals((Object)stilton2.getObject(), results.get(1));
        MarshallingTest.assertEquals((Object)bob2.getObject(), results.get(2));
        MarshallingTest.assertEquals((Object)bob1.getObject(), results.get(3));
        serializedRulebase = null;
        resolver = session.getGlobalResolver();
        baos = new ByteArrayOutputStream();
        marshaller = new DefaultMarshaller();
        ruleBase.writeStatefulSession(session, (OutputStream)baos, (Marshaller)marshaller);
        serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
        ruleBase = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
        session = ruleBase.readStatefulSession((InputStream)new ByteArrayInputStream(baos.toByteArray()), (Marshaller)marshaller);
        session.setGlobalResolver(resolver);
        results = (List)session.getGlobal("results");
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1_2.drl")));
        pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        InternalFactHandle stilton3 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 40));
        InternalFactHandle brie3 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 40));
        InternalFactHandle bob3 = (InternalFactHandle)session.insert((Object)new Person("bob", 40));
        InternalFactHandle bob4 = (InternalFactHandle)session.insert((Object)new Person("bob", 40));
        InternalFactHandle addr1 = (InternalFactHandle)session.insert((Object)new Address("bangalore"));
        InternalFactHandle addr2 = (InternalFactHandle)session.insert((Object)new Address("India"));
        session.fireAllRules();
        MarshallingTest.assertEquals((int)9, (int)results.size());
        MarshallingTest.assertEquals((Object)stilton3.getObject(), results.get(4));
        MarshallingTest.assertEquals((Object)bob4.getObject(), results.get(5));
        MarshallingTest.assertEquals((Object)bob3.getObject(), results.get(6));
        MarshallingTest.assertEquals((Object)addr2.getObject(), results.get(7));
        MarshallingTest.assertEquals((Object)addr1.getObject(), results.get(8));
        serializedRulebase = null;
        resolver = session.getGlobalResolver();
        baos = new ByteArrayOutputStream();
        marshaller = new DefaultMarshaller();
        ruleBase.writeStatefulSession(session, (OutputStream)baos, (Marshaller)marshaller);
        serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
        ruleBase = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
        session = ruleBase.readStatefulSession((InputStream)new ByteArrayInputStream(baos.toByteArray()), (Marshaller)marshaller);
        session.setGlobalResolver(resolver);
        results = (List)session.getGlobal("results");
        InternalFactHandle stilton4 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 50));
        InternalFactHandle brie4 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 50));
        InternalFactHandle bob5 = (InternalFactHandle)session.insert((Object)new Person("bob", 50));
        InternalFactHandle bob6 = (InternalFactHandle)session.insert((Object)new Person("bob", 50));
        InternalFactHandle addr3 = (InternalFactHandle)session.insert((Object)new Address("Tripura"));
        InternalFactHandle addr4 = (InternalFactHandle)session.insert((Object)new Address("Agartala"));
        session.fireAllRules();
        MarshallingTest.assertEquals((int)14, (int)results.size());
        MarshallingTest.assertEquals((Object)stilton4.getObject(), results.get(9));
        MarshallingTest.assertEquals((Object)bob6.getObject(), results.get(10));
        MarshallingTest.assertEquals((Object)bob5.getObject(), results.get(11));
        MarshallingTest.assertEquals((Object)addr4.getObject(), results.get(12));
        MarshallingTest.assertEquals((Object)addr3.getObject(), results.get(13));
        serializedRulebase = null;
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
    }

    public void testSerializeAddRemove_NoClassDefFoundError() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1_0.drl")));
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        ArrayList results = new ArrayList();
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("results", results);
        InternalFactHandle stilton1 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie1 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        session.fireAllRules();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DefaultMarshaller marshaller = new DefaultMarshaller();
        ruleBase.writeStatefulSession(session, (OutputStream)baos, (Marshaller)marshaller);
        byte[] serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
        MarshallingTest.assertEquals((int)1, (int)results.size());
        MarshallingTest.assertEquals((Object)stilton1.getObject(), results.get(0));
        ruleBase = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
        session = ruleBase.readStatefulSession((InputStream)new ByteArrayInputStream(baos.toByteArray()), (Marshaller)marshaller);
        results.clear();
        session.setGlobal("results", results);
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic3_0.drl")));
        pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie2 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle bob1 = (InternalFactHandle)session.insert((Object)new Person("bob", 20));
        InternalFactHandle bob2 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        MarshallingTest.assertEquals((int)3, (int)results.size());
        MarshallingTest.assertEquals((Object)stilton2.getObject(), results.get(0));
        MarshallingTest.assertEquals((Object)bob2.getObject(), results.get(1));
        MarshallingTest.assertEquals((Object)bob1.getObject(), results.get(2));
        serializedRulebase = null;
        baos = new ByteArrayOutputStream();
        marshaller = new DefaultMarshaller();
        ruleBase.writeStatefulSession(session, (OutputStream)baos, (Marshaller)marshaller);
        serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
        ruleBase = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
        session = ruleBase.readStatefulSession((InputStream)new ByteArrayInputStream(baos.toByteArray()), (Marshaller)marshaller);
        results.clear();
        session.setGlobal("results", results);
        ruleBase.removeRule("org.drools.test", "like stilton");
        InternalFactHandle stilton3 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie3 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle bob3 = (InternalFactHandle)session.insert((Object)new Person("bob", 20));
        InternalFactHandle bob4 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        MarshallingTest.assertEquals((int)2, (int)results.size());
        MarshallingTest.assertEquals((Object)bob4.getObject(), results.get(0));
        MarshallingTest.assertEquals((Object)bob3.getObject(), results.get(1));
        ruleBase = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
        session = ruleBase.readStatefulSession((InputStream)new ByteArrayInputStream(baos.toByteArray()), (Marshaller)marshaller);
        results.clear();
        session.setGlobal("results", results);
        ruleBase.removePackage("org.drools.test");
        InternalFactHandle stilton4 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie4 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle bob5 = (InternalFactHandle)session.insert((Object)new Person("bob", 20));
        InternalFactHandle bob6 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        MarshallingTest.assertEquals((int)2, (int)results.size());
        MarshallingTest.assertEquals((Object)bob6.getObject(), results.get(0));
        MarshallingTest.assertEquals((Object)bob5.getObject(), results.get(1));
        Object serializedSession = null;
        serializedRulebase = null;
        baos = new ByteArrayOutputStream();
        marshaller = new DefaultMarshaller();
        ruleBase.writeStatefulSession(session, (OutputStream)baos, (Marshaller)marshaller);
        serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
        ruleBase = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
        session = ruleBase.readStatefulSession((InputStream)new ByteArrayInputStream(baos.toByteArray()), (Marshaller)marshaller);
        results.clear();
        session.setGlobal("results", results);
        InternalFactHandle stilton5 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 30));
        InternalFactHandle brie5 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 30));
        InternalFactHandle bob7 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        InternalFactHandle bob8 = (InternalFactHandle)session.insert((Object)new Person("bob", 40));
        session.fireAllRules();
        MarshallingTest.assertEquals((int)2, (int)results.size());
        MarshallingTest.assertEquals((Object)bob8.getObject(), results.get(0));
        MarshallingTest.assertEquals((Object)bob7.getObject(), results.get(1));
        serializedSession = null;
        serializedRulebase = null;
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
    }

    public void testSerializabilityWithJarFacts() throws Exception {
        MapBackedClassLoader loader = new MapBackedClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        JarInputStream jis = new JarInputStream(((Object)((Object)this)).getClass().getResourceAsStream("/billasurf.jar"));
        JarEntry entry = null;
        byte[] buf = new byte[1024];
        int len = 0;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((len = jis.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
            loader.addResource(entry.getName(), out.toByteArray());
        }
        String drl = "package foo.bar \nimport com.billasurf.Board\nrule 'MyGoodRule' \n dialect 'mvel' \n when Board() then System.err.println(42); \n end\n";
        PackageBuilder builder = new PackageBuilder(new PackageBuilderConfiguration((ClassLoader)loader));
        builder.addPackageFromDrl((Reader)new StringReader(drl));
        MarshallingTest.assertFalse((boolean)builder.hasErrors());
        Package p = builder.getPackage();
        byte[] ser = DroolsStreamUtils.streamOut((Object)p);
        Package p_ = (Package)DroolsStreamUtils.streamIn((byte[])ser, (ClassLoader)loader);
        MarshallingTest.assertNotNull((Object)p_);
    }

    public void testEmptyRule() throws Exception {
        String rule = "package org.test;\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Rule 1\"\n";
        rule = rule + "when\n";
        rule = rule + "then\n";
        rule = rule + "    list.add( \"fired\" );\n";
        rule = rule + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        MarshallingTest.assertTrue((boolean)builder.getErrors().isEmpty());
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        Map nodes = RuleBaseNodes.getNodeMap((InternalRuleBase)((InternalRuleBase)ruleBase));
        MarshallingTest.assertEquals((int)2, (int)nodes.size());
        MarshallingTest.assertEquals((String)"InitialFact", (String)((ClassObjectType)((ObjectTypeNode)nodes.get(3)).getObjectType()).getClassType().getSimpleName());
        MarshallingTest.assertEquals((String)"Rule 1", (String)((RuleTerminalNode)nodes.get(5)).getRule().getName());
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        session = SerializationHelper.getSerialisedStatefulSession(session);
        MarshallingTest.assertEquals((int)1, (int)((List)session.getGlobal("list")).size());
        MarshallingTest.assertEquals((Object)"fired", ((List)session.getGlobal("list")).get(0));
    }

    public void testDynamicEmptyRule() throws Exception {
        String rule1 = "package org.test;\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule \"Rule 1\"\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( \"fired1\" );\n";
        rule1 = rule1 + "end";
        String rule2 = "package org.test;\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule \"Rule 2\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    list.add( \"fired2\" );\n";
        rule2 = rule2 + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule1));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        Map nodes = RuleBaseNodes.getNodeMap((InternalRuleBase)((InternalRuleBase)ruleBase));
        MarshallingTest.assertEquals((int)2, (int)nodes.size());
        MarshallingTest.assertEquals((String)"InitialFact", (String)((ClassObjectType)((ObjectTypeNode)nodes.get(3)).getObjectType()).getClassType().getSimpleName());
        MarshallingTest.assertEquals((String)"Rule 1", (String)((RuleTerminalNode)nodes.get(5)).getRule().getName());
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        StatefulSession session1 = SerializationHelper.getSerialisedStatefulSession(session);
        session1.fireAllRules();
        MarshallingTest.assertEquals((int)1, (int)((List)session1.getGlobal("list")).size());
        StatefulSession session2 = SerializationHelper.getSerialisedStatefulSession(session1, true);
        session.dispose();
        session1.dispose();
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule2));
        pkg = builder.getPackage();
        ruleBase.addPackage(pkg);
        MarshallingTest.assertEquals((int)2, (int)((List)session2.getGlobal("list")).size());
        MarshallingTest.assertEquals((Object)"fired1", ((List)session2.getGlobal("list")).get(0));
        MarshallingTest.assertEquals((Object)"fired2", ((List)session2.getGlobal("list")).get(1));
    }

    public void testSinglePattern() throws Exception {
        String rule = "package org.test;\n";
        rule = rule + "import org.drools.Person\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Rule 1\"\n";
        rule = rule + "when\n";
        rule = rule + "    $p : Person( ) \n";
        rule = rule + "then\n";
        rule = rule + "    list.add( $p );\n";
        rule = rule + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        Map nodes = RuleBaseNodes.getNodeMap((InternalRuleBase)((InternalRuleBase)ruleBase));
        MarshallingTest.assertEquals((int)2, (int)nodes.size());
        MarshallingTest.assertEquals((String)"Person", (String)((ClassObjectType)((ObjectTypeNode)nodes.get(3)).getObjectType()).getClassType().getSimpleName());
        MarshallingTest.assertEquals((String)"Rule 1", (String)((RuleTerminalNode)nodes.get(5)).getRule().getName());
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Person p = new Person("bobba fet", 32);
        session.insert((Object)p);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)1, (int)((List)session.getGlobal("list")).size());
        MarshallingTest.assertEquals((Object)p, ((List)session.getGlobal("list")).get(0));
    }

    public void testSingleRuleSingleJoinNodePattern() throws Exception {
        String rule = "package org.test;\n";
        rule = rule + "import org.drools.Person\n";
        rule = rule + "import org.drools.Cheese\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Rule 1\"\n";
        rule = rule + "when\n";
        rule = rule + "    $c : Cheese( ) \n";
        rule = rule + "    $p : Person( cheese == $c ) \n";
        rule = rule + "then\n";
        rule = rule + "    list.add( $p );\n";
        rule = rule + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        Map nodes = RuleBaseNodes.getNodeMap((InternalRuleBase)((InternalRuleBase)ruleBase));
        MarshallingTest.assertEquals((int)4, (int)nodes.size());
        MarshallingTest.assertEquals((String)"Cheese", (String)((ClassObjectType)((ObjectTypeNode)nodes.get(3)).getObjectType()).getClassType().getSimpleName());
        MarshallingTest.assertEquals((String)"Person", (String)((ClassObjectType)((ObjectTypeNode)nodes.get(6)).getObjectType()).getClassType().getSimpleName());
        MarshallingTest.assertEquals((String)"JoinNode", (String)((BaseNode)nodes.get(7)).getClass().getSimpleName());
        MarshallingTest.assertEquals((String)"Rule 1", (String)((RuleTerminalNode)nodes.get(8)).getRule().getName());
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 25);
        Cheese brie = new Cheese("brie", 49);
        Person bobba = new Person("bobba fet", 32);
        bobba.setCheese(stilton);
        Person vadar = new Person("darth vadar", 32);
        session.insert((Object)stilton);
        session.insert((Object)bobba);
        session.insert((Object)vadar);
        session.insert((Object)brie);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)1, (int)((List)session.getGlobal("list")).size());
        MarshallingTest.assertEquals((Object)bobba, ((List)session.getGlobal("list")).get(0));
        Person c3po = new Person("c3p0", 32);
        c3po.setCheese(stilton);
        session.insert((Object)c3po);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)2, (int)((List)session.getGlobal("list")).size());
        MarshallingTest.assertEquals((Object)c3po, ((List)session.getGlobal("list")).get(1));
        Person r2d2 = new Person("r2d2", 32);
        r2d2.setCheese(brie);
        session.insert((Object)r2d2);
        System.out.println("\n\njointpattern");
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)3, (int)((List)session.getGlobal("list")).size());
        MarshallingTest.assertEquals((Object)r2d2, ((List)session.getGlobal("list")).get(2));
    }

    public void testMultiRuleMultiJoinNodePatternsWithHalt() throws Exception {
        String rule1 = "package org.test;\n";
        rule1 = rule1 + "import org.drools.Person\n";
        rule1 = rule1 + "import org.drools.Cheese\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule \"Rule 1\"\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    $c : Cheese( ) \n";
        rule1 = rule1 + "    $p : Person( cheese == $c ) \n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( $p );\n";
        rule1 = rule1 + "end";
        String rule2 = "package org.test;\n";
        rule2 = rule2 + "import org.drools.Person\n";
        rule2 = rule2 + "import org.drools.Cheese\n";
        rule2 = rule2 + "import org.drools.Cell\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule \"Rule 2\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "    $c : Cheese( ) \n";
        rule2 = rule2 + "    $p : Person( cheese == $c ) \n";
        rule2 = rule2 + "    Cell( value == $p.age ) \n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    list.add( $p );\n";
        rule2 = rule2 + "end";
        String rule3 = "package org.test;\n";
        rule3 = rule3 + "import org.drools.FactA\n";
        rule3 = rule3 + "import org.drools.FactB\n";
        rule3 = rule3 + "import org.drools.FactC\n";
        rule3 = rule3 + "import org.drools.Person\n";
        rule3 = rule3 + "global java.util.List list\n";
        rule3 = rule3 + "rule \"Rule 3\"\n";
        rule3 = rule3 + "when\n";
        rule3 = rule3 + "    $a : FactA( field2 > 10 ) \n";
        rule3 = rule3 + "    $b : FactB( f2 >= $a.field2 ) \n";
        rule3 = rule3 + "    $p : Person( name == \"darth vadar\" ) \n";
        rule3 = rule3 + "    $c : FactC( f2 >= $b.f2 ) \n";
        rule3 = rule3 + "then\n";
        rule3 = rule3 + "    list.add( $c );\n";
        rule3 = rule3 + "    drools.halt();\n";
        rule3 = rule3 + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule1));
        builder.addPackageFromDrl((Reader)new StringReader(rule2));
        builder.addPackageFromDrl((Reader)new StringReader(rule3));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 25);
        Cheese brie = new Cheese("brie", 49);
        Person bobba = new Person("bobba fet", 30);
        bobba.setCheese(stilton);
        Person vadar = new Person("darth vadar", 38);
        Person c3po = new Person("c3p0", 17);
        c3po.setCheese(stilton);
        Person r2d2 = new Person("r2d2", 58);
        r2d2.setCheese(brie);
        session.insert((Object)stilton);
        session.insert((Object)bobba);
        session.insert((Object)vadar);
        session.insert((Object)brie);
        session.insert((Object)c3po);
        session.insert((Object)r2d2);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)3, (int)((List)session.getGlobal("list")).size());
        MarshallingTest.assertEquals((Object)bobba, ((List)session.getGlobal("list")).get(2));
        MarshallingTest.assertEquals((Object)c3po, ((List)session.getGlobal("list")).get(1));
        MarshallingTest.assertEquals((Object)r2d2, ((List)session.getGlobal("list")).get(0));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.insert((Object)new Cell(30));
        session.insert((Object)new Cell(58));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)5, (int)((List)session.getGlobal("list")).size());
        MarshallingTest.assertEquals((Object)r2d2, ((List)session.getGlobal("list")).get(3));
        MarshallingTest.assertEquals((Object)bobba, ((List)session.getGlobal("list")).get(4));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.insert((Object)new FactA(15));
        session.insert((Object)new FactB(20));
        session.insert((Object)new FactC(27));
        session.insert((Object)new FactC(52));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)6, (int)((List)session.getGlobal("list")).size());
        MarshallingTest.assertEquals((Object)new FactC(52), ((List)session.getGlobal("list")).get(5));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)7, (int)((List)session.getGlobal("list")).size());
        MarshallingTest.assertEquals((Object)new FactC(27), ((List)session.getGlobal("list")).get(6));
    }

    public void testNot() throws Exception {
        String header = "package org.drools.test;\n";
        header = header + "import java.util.List;\n";
        header = header + "import org.drools.Person\n";
        header = header + "import org.drools.Cheese\n";
        header = header + "global java.util.List list;\n";
        String rule1 = "rule \"not rule test\"\n";
        rule1 = rule1 + "salience 10\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    Person()\n";
        rule1 = rule1 + "    not Cheese( price >= 5 )\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( new Integer( 5 ) );\n";
        rule1 = rule1 + "end\n";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(header + rule1));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        Person bobba = new Person("bobba fet", 50);
        session.insert((Object)bobba);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)1, (int)list.size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        Person darth = new Person("darth vadar", 200);
        session.insert((Object)darth);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)2, (int)list.size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        Cheese stilton = new Cheese("stilton", 5);
        session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)2, (int)list.size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.retract((FactHandle)session.getFactHandle((Object)stilton));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)4, (int)list.size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        Cheese brie = new Cheese("brie", 18);
        session.insert((Object)brie);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)4, (int)list.size());
        session.retract((FactHandle)session.getFactHandle((Object)stilton));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)4, (int)list.size());
        session.retract((FactHandle)session.getFactHandle((Object)bobba));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)4, (int)list.size());
        session.retract((FactHandle)session.getFactHandle((Object)brie));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)5, (int)list.size());
    }

    public void testExists() throws Exception {
        String header = "package org.drools.test;\n";
        header = header + "import java.util.List;\n";
        header = header + "import org.drools.Person\n";
        header = header + "import org.drools.Cheese\n";
        header = header + "global java.util.List list;\n";
        String rule1 = "rule \"not rule test\"\n";
        rule1 = rule1 + "salience 10\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    Person()\n";
        rule1 = rule1 + "    exists Cheese( price >= 5 )\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( new Integer( 5 ) );\n";
        rule1 = rule1 + "end\n";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(header + rule1));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        Person bobba = new Person("bobba fet", 50);
        session.insert((Object)bobba);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)0, (int)list.size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        Person darth = new Person("darth vadar", 200);
        session.insert((Object)darth);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)0, (int)list.size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        Cheese stilton = new Cheese("stilton", 5);
        session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)2, (int)list.size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.retract((FactHandle)session.getFactHandle((Object)stilton));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)2, (int)list.size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        Cheese brie = new Cheese("brie", 18);
        session.insert((Object)brie);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)4, (int)list.size());
        session.retract((FactHandle)session.getFactHandle((Object)stilton));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)4, (int)list.size());
        session.retract((FactHandle)session.getFactHandle((Object)bobba));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)4, (int)list.size());
        session.retract((FactHandle)session.getFactHandle((Object)brie));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)4, (int)list.size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.insert((Object)stilton);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)5, (int)list.size());
    }

    public void testTruthMaintenance() throws Exception {
        String header = "package org.drools.test;\n";
        header = header + "import java.util.List;\n";
        header = header + "import org.drools.Person\n";
        header = header + "import org.drools.Cheese\n";
        header = header + "global Cheese cheese;\n";
        header = header + "global Person person;\n";
        header = header + "global java.util.List list;\n";
        String rule1 = "rule \"not person then cheese\"\n";
        rule1 = rule1 + "when \n";
        rule1 = rule1 + "    not Person() \n";
        rule1 = rule1 + "then \n";
        rule1 = rule1 + "    if (list.size() < 3) { \n";
        rule1 = rule1 + "        list.add(new Integer(0)); \n";
        rule1 = rule1 + "        insertLogical( cheese ); \n    }\n";
        rule1 = rule1 + "    drools.halt();\nend\n";
        String rule2 = "rule \"if cheese then person\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "    Cheese()\n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    if (list.size() < 3) {\n";
        rule2 = rule2 + "        list.add(new Integer(0));\n";
        rule2 = rule2 + "        insertLogical( person );\n";
        rule2 = rule2 + "    }\n    drools.halt();\n";
        rule2 = rule2 + "end\n";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(header + rule1));
        builder.addPackageFromDrl((Reader)new StringReader(header + rule2));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        Person person = new Person("person");
        Cheese cheese = new Cheese("cheese", 0);
        session.setGlobal("cheese", (Object)cheese);
        session.setGlobal("person", (Object)person);
        session.setGlobal("list", list);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)1, (int)list.size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)2, (int)list.size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)3, (int)list.size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)3, (int)list.size());
    }

    public void testActivationGroups() throws Exception {
        String rule1 = "package org.test;\n";
        rule1 = rule1 + "import org.drools.Cheese\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule \"Rule 1\"\n";
        rule1 = rule1 + "    activation-group \"activation-group-1\"\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    $c : Cheese( ) \n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( \"rule1\" );\n";
        rule1 = rule1 + "    drools.halt();\n";
        rule1 = rule1 + "end";
        String rule2 = "package org.test;\n";
        rule2 = rule2 + "import org.drools.Cheese\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule \"Rule 2\"\n";
        rule2 = rule2 + "    salience 10\n";
        rule2 = rule2 + "    activation-group \"activation-group-1\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "    $c : Cheese( ) \n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    list.add( \"rule2\" );\n";
        rule2 = rule2 + "    drools.halt();\n";
        rule2 = rule2 + "end";
        String rule3 = "package org.test;\n";
        rule3 = rule3 + "import org.drools.Cheese\n";
        rule3 = rule3 + "global java.util.List list\n";
        rule3 = rule3 + "rule \"Rule 3\"\n";
        rule3 = rule3 + "    activation-group \"activation-group-1\"\n";
        rule3 = rule3 + "when\n";
        rule3 = rule3 + "    $c : Cheese( ) \n";
        rule3 = rule3 + "then\n";
        rule3 = rule3 + "    list.add( \"rule3\" );\n";
        rule3 = rule3 + "    drools.halt();\n";
        rule3 = rule3 + "end";
        String rule4 = "package org.test;\n";
        rule4 = rule4 + "import org.drools.Cheese\n";
        rule4 = rule4 + "global java.util.List list\n";
        rule4 = rule4 + "rule \"Rule 4\"\n";
        rule4 = rule4 + "    activation-group \"activation-group-2\"\n";
        rule4 = rule4 + "when\n";
        rule4 = rule4 + "    $c : Cheese( ) \n";
        rule4 = rule4 + "then\n";
        rule4 = rule4 + "    list.add( \"rule4\" );\n";
        rule4 = rule4 + "    drools.halt();\n";
        rule4 = rule4 + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule1));
        builder.addPackageFromDrl((Reader)new StringReader(rule2));
        builder.addPackageFromDrl((Reader)new StringReader(rule3));
        builder.addPackageFromDrl((Reader)new StringReader(rule4));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        session = SerializationHelper.getSerialisedStatefulSession(session);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        session.insert((Object)brie);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)2, (int)list.size());
        MarshallingTest.assertEquals((Object)"rule2", list.get(0));
        MarshallingTest.assertEquals((Object)"rule4", list.get(1));
    }

    public void testAgendaGroups() throws Exception {
        String rule1 = "package org.test;\n";
        rule1 = rule1 + "import org.drools.Cheese\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule \"Rule 1\"\n";
        rule1 = rule1 + "    agenda-group \"agenda-group-1\"\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    $c : Cheese( ) \n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( \"rule1\" );\n";
        rule1 = rule1 + "    drools.halt();\n";
        rule1 = rule1 + "end";
        String rule2 = "package org.test;\n";
        rule2 = rule2 + "import org.drools.Cheese\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule \"Rule 2\"\n";
        rule2 = rule2 + "    salience 10\n";
        rule2 = rule2 + "    agenda-group \"agenda-group-1\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "    $c : Cheese( ) \n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    list.add( \"rule2\" );\n";
        rule2 = rule2 + "    drools.halt();\n";
        rule2 = rule2 + "end";
        String rule3 = "package org.test;\n";
        rule3 = rule3 + "import org.drools.Cheese\n";
        rule3 = rule3 + "global java.util.List list\n";
        rule3 = rule3 + "rule \"Rule 3\"\n";
        rule3 = rule3 + "    salience 10\n";
        rule3 = rule3 + "    agenda-group \"agenda-group-2\"\n";
        rule3 = rule3 + "    activation-group \"activation-group-2\"\n";
        rule3 = rule3 + "when\n";
        rule3 = rule3 + "    $c : Cheese( ) \n";
        rule3 = rule3 + "then\n";
        rule3 = rule3 + "    list.add( \"rule3\" );\n";
        rule3 = rule3 + "    drools.halt();\n";
        rule3 = rule3 + "end";
        String rule4 = "package org.test;\n";
        rule4 = rule4 + "import org.drools.Cheese\n";
        rule4 = rule4 + "global java.util.List list\n";
        rule4 = rule4 + "rule \"Rule 4\"\n";
        rule4 = rule4 + "    agenda-group \"agenda-group-2\"\n";
        rule4 = rule4 + "    activation-group \"activation-group-2\"\n";
        rule4 = rule4 + "when\n";
        rule4 = rule4 + "    $c : Cheese( ) \n";
        rule4 = rule4 + "then\n";
        rule4 = rule4 + "    list.add( \"rule4\" );\n";
        rule4 = rule4 + "    drools.halt();\n";
        rule4 = rule4 + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule1));
        builder.addPackageFromDrl((Reader)new StringReader(rule2));
        builder.addPackageFromDrl((Reader)new StringReader(rule3));
        builder.addPackageFromDrl((Reader)new StringReader(rule4));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        session = SerializationHelper.getSerialisedStatefulSession(session);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        session.insert((Object)brie);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.setFocus("agenda-group-1");
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((Object)"rule2", list.get(0));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.setFocus("agenda-group-2");
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((Object)"rule3", list.get(1));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((Object)"rule1", list.get(2));
    }

    public void testRuleFlowGroups() throws Exception {
        String rule1 = "package org.test;\n";
        rule1 = rule1 + "import org.drools.Cheese\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule \"Rule 1\"\n";
        rule1 = rule1 + "    ruleflow-group \"ruleflow-group-1\"\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    $c : Cheese( ) \n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( \"rule1\" );\n";
        rule1 = rule1 + "    drools.halt();\n";
        rule1 = rule1 + "end";
        String rule2 = "package org.test;\n";
        rule2 = rule2 + "import org.drools.Cheese\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule \"Rule 2\"\n";
        rule2 = rule2 + "    salience 10\n";
        rule2 = rule2 + "    ruleflow-group \"ruleflow-group-1\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "    $c : Cheese( ) \n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    list.add( \"rule2\" );\n";
        rule2 = rule2 + "    drools.halt();\n";
        rule2 = rule2 + "end";
        String rule3 = "package org.test;\n";
        rule3 = rule3 + "import org.drools.Cheese\n";
        rule3 = rule3 + "global java.util.List list\n";
        rule3 = rule3 + "rule \"Rule 3\"\n";
        rule3 = rule3 + "    salience 10\n";
        rule3 = rule3 + "    ruleflow-group \"ruleflow-group-2\"\n";
        rule3 = rule3 + "    activation-group \"activation-group-2\"\n";
        rule3 = rule3 + "when\n";
        rule3 = rule3 + "    $c : Cheese( ) \n";
        rule3 = rule3 + "then\n";
        rule3 = rule3 + "    list.add( \"rule3\" );\n";
        rule3 = rule3 + "    drools.halt();\n";
        rule3 = rule3 + "end";
        String rule4 = "package org.test;\n";
        rule4 = rule4 + "import org.drools.Cheese\n";
        rule4 = rule4 + "global java.util.List list\n";
        rule4 = rule4 + "rule \"Rule 4\"\n";
        rule4 = rule4 + "    ruleflow-group \"ruleflow-group-2\"\n";
        rule4 = rule4 + "    activation-group \"activation-group-2\"\n";
        rule4 = rule4 + "when\n";
        rule4 = rule4 + "    $c : Cheese( ) \n";
        rule4 = rule4 + "then\n";
        rule4 = rule4 + "    list.add( \"rule4\" );\n";
        rule4 = rule4 + "    drools.halt();\n";
        rule4 = rule4 + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule1));
        builder.addPackageFromDrl((Reader)new StringReader(rule2));
        builder.addPackageFromDrl((Reader)new StringReader(rule3));
        builder.addPackageFromDrl((Reader)new StringReader(rule4));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        session = SerializationHelper.getSerialisedStatefulSession(session);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        session.insert((Object)brie);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.getAgenda().activateRuleFlowGroup("ruleflow-group-1");
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((Object)"rule2", list.get(0));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.getAgenda().activateRuleFlowGroup("ruleflow-group-2");
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((Object)"rule3", list.get(1));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        MarshallingTest.assertEquals((Object)"rule1", list.get(2));
    }

    public void testAccumulate() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        StringReader source = new StringReader("package org.drools\n\nimport org.drools.Message\nglobal java.util.List results\n\nrule MyRule\n  when\n    $n : Number( intValue >= 2 ) from accumulate ( m: Message( ), count( m ) )\n  then\n    results.add($n);\nend");
        builder.addPackageFromDrl((Reader)source);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("results", new ArrayList());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.insert((Object)new Message());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        List results = (List)session.getGlobal("results");
        session.insert((Object)new Message());
        session.insert((Object)new Message());
        session.fireAllRules();
        MarshallingTest.assertEquals((int)3, (int)((Number)results.get(0)).intValue());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.insert((Object)new Message());
        session.insert((Object)new Message());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        MarshallingTest.assertEquals((int)1, (int)session.getAgenda().getActivations().length);
        session.fireAllRules();
        MarshallingTest.assertEquals((int)5, (int)((Number)results.get(1)).intValue());
    }

    public void testAccumulate2() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        StringReader source = new StringReader("package org.drools\n\nimport org.drools.Message\n\nrule MyRule\n  when\n    Number( intValue >= 5 ) from accumulate ( m: Message( ), count( m ) )\n  then\n    System.out.println(\"Found messages\");\nend");
        builder.addPackageFromDrl((Reader)source);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        session.fireAllRules();
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.insert((Object)new Message());
        session.insert((Object)new Message());
        session.insert((Object)new Message());
        session.insert((Object)new Message());
        session.insert((Object)new Message());
        MarshallingTest.assertEquals((int)1, (int)session.getAgenda().getActivations().length);
    }

    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(Package pkg) throws Exception {
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        return SerializationHelper.serializeObject(ruleBase);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }
}

