/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.drools.Message;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.DroolsError;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderErrors;
import org.drools.process.instance.ProcessInstance;
import org.drools.rule.Package;
import org.drools.runtime.ObjectFilter;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;

public class ProcessActionTest
extends TestCase {
    public void testOnEntryExit() {
        PackageBuilder builder = new PackageBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-4.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-4.0/process drools-processes-4.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"2\" name=\"HumanTask\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>John Doe</value>\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n      </work>\n      <onEntry>\n        <action type=\"expression\" name=\"Print\" dialect=\"mvel\" >list.add(\"Executing on entry action\");</action>\n      </onEntry>\n      <onExit>\n        <action type=\"expression\" name=\"Print\" dialect=\"java\" >list.add(\"Executing on exit action1\");</action>\n        <action type=\"expression\" name=\"Print\" dialect=\"java\" >list.add(\"Executing on exit action2\");</action>\n      </onExit>\n    </workItem>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        builder.addRuleFlow((Reader)source);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        TestWorkItemHandler handler = new TestWorkItemHandler();
        workingMemory.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        ProcessInstance processInstance = workingMemory.startProcess("org.drools.actions");
        ProcessActionTest.assertEquals((int)1, (int)processInstance.getState());
        WorkItem workItem = handler.getWorkItem();
        ProcessActionTest.assertNotNull((Object)workItem);
        ProcessActionTest.assertEquals((int)1, (int)list.size());
        workingMemory.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        ProcessActionTest.assertEquals((int)3, (int)list.size());
        ProcessActionTest.assertEquals((int)2, (int)processInstance.getState());
    }

    public void testActionContextJava() {
        PackageBuilder builder = new PackageBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-4.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-4.0/process drools-processes-4.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.drools.Message\" />\n    </imports>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n    <variables>\n      <variable name=\"variable\" >\n        <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        <value>SomeText</value>\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <actionNode id=\"2\" name=\"MyActionNode\" >\n      <action type=\"expression\" dialect=\"java\" >System.out.println(\"Triggered\");\nString variable = (String) context.getVariable(\"variable\");\nSystem.out.println(drools.getWorkingMemory());\nlist.add(variable);\nString nodeName = context.getNodeInstance().getNodeName();\nlist.add(nodeName);\ninsert( new Message() );\n</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        builder.addRuleFlow((Reader)source);
        PackageBuilderErrors errors = builder.getErrors();
        if (!errors.isEmpty()) {
            for (DroolsError error : errors.getErrors()) {
                System.err.println(error);
            }
            ProcessActionTest.fail((String)"Errors while building package");
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        ProcessInstance processInstance = workingMemory.startProcess("org.drools.actions");
        ProcessActionTest.assertEquals((int)2, (int)list.size());
        ProcessActionTest.assertEquals((String)"SomeText", (String)((String)list.get(0)));
        ProcessActionTest.assertEquals((String)"MyActionNode", (String)((String)list.get(1)));
        Iterator iterator = workingMemory.iterateObjects(new ObjectFilter(){

            public boolean accept(Object object) {
                return object instanceof Message;
            }
        });
        ProcessActionTest.assertTrue((boolean)iterator.hasNext());
        ProcessActionTest.assertEquals((int)2, (int)processInstance.getState());
    }

    public void testActionContextMVEL() {
        PackageBuilder builder = new PackageBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-4.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-4.0/process drools-processes-4.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.drools.Message\" />\n    </imports>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n    <variables>\n      <variable name=\"variable\" >\n        <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        <value>SomeText</value>\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <actionNode id=\"2\" name=\"MyActionNode\" >\n      <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Triggered\");\nSystem.out.println(drools.getWorkingMemory());\nmyVariable = (String) context.getVariable(\"variable\");\nlist.add(myVariable);\nnodeName = context.getNodeInstance().getNodeName();\nlist.add(nodeName);\ninsert( new Message() );\n</action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        builder.addRuleFlow((Reader)source);
        PackageBuilderErrors errors = builder.getErrors();
        if (!errors.isEmpty()) {
            for (DroolsError error : errors.getErrors()) {
                System.err.println(error);
            }
            ProcessActionTest.fail((String)"Errors while building package");
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        ProcessInstance processInstance = workingMemory.startProcess("org.drools.actions");
        ProcessActionTest.assertEquals((int)2, (int)list.size());
        ProcessActionTest.assertEquals((String)"SomeText", (String)((String)list.get(0)));
        ProcessActionTest.assertEquals((String)"MyActionNode", (String)((String)list.get(1)));
        Iterator iterator = workingMemory.iterateObjects(new ObjectFilter(){

            public boolean accept(Object object) {
                return object instanceof Message;
            }
        });
        ProcessActionTest.assertTrue((boolean)iterator.hasNext());
        ProcessActionTest.assertEquals((int)2, (int)processInstance.getState());
    }

    private static class TestWorkItemHandler
    implements WorkItemHandler {
        private WorkItem workItem;

        private TestWorkItemHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItem = workItem;
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }

        public WorkItem getWorkItem() {
            return this.workItem;
        }
    }
}

