/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.PackageBuilder;
import org.drools.process.instance.ProcessInstance;
import org.drools.rule.Package;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;

public class ProcessHumanTaskTest
extends TestCase {
    public void testHumanTask() {
        PackageBuilder builder = new PackageBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-4.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-4.0/process drools-processes-4.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.humantask\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <humanTask id=\"2\" name=\"HumanTask\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>John Doe</value>\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n      </work>\n    </humanTask>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        builder.addRuleFlow((Reader)source);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        TestWorkItemHandler handler = new TestWorkItemHandler();
        workingMemory.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = workingMemory.startProcess("org.drools.humantask");
        ProcessHumanTaskTest.assertEquals((int)1, (int)processInstance.getState());
        WorkItem workItem = handler.getWorkItem();
        ProcessHumanTaskTest.assertNotNull((Object)workItem);
        workingMemory.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        ProcessHumanTaskTest.assertEquals((int)2, (int)processInstance.getState());
    }

    public void testSwimlane() {
        PackageBuilder builder = new PackageBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-4.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-4.0/process drools-processes-4.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.humantask\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <swimlanes>\n      <swimlane name=\"actor1\" />\n    </swimlanes>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <humanTask id=\"2\" name=\"HumanTask\" swimlane=\"actor1\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>John Doe</value>\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n      </work>\n    </humanTask>\n    <humanTask id=\"3\" name=\"HumanTask\" swimlane=\"actor1\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something else</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n      </work>\n    </humanTask>\n    <end id=\"4\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n  </connections>\n\n</process>");
        builder.addRuleFlow((Reader)source);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        TestWorkItemHandler handler = new TestWorkItemHandler();
        workingMemory.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = workingMemory.startProcess("org.drools.humantask");
        ProcessHumanTaskTest.assertEquals((int)1, (int)processInstance.getState());
        WorkItem workItem = handler.getWorkItem();
        ProcessHumanTaskTest.assertNotNull((Object)workItem);
        ProcessHumanTaskTest.assertEquals((Object)"Do something", (Object)workItem.getParameter("TaskName"));
        ProcessHumanTaskTest.assertEquals((Object)"John Doe", (Object)workItem.getParameter("ActorId"));
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("ActorId", "Jane Doe");
        workingMemory.getWorkItemManager().completeWorkItem(workItem.getId(), results);
        workItem = handler.getWorkItem();
        ProcessHumanTaskTest.assertNotNull((Object)workItem);
        ProcessHumanTaskTest.assertEquals((Object)"Do something else", (Object)workItem.getParameter("TaskName"));
        ProcessHumanTaskTest.assertEquals((Object)"Jane Doe", (Object)workItem.getParameter("ActorId"));
        workingMemory.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        ProcessHumanTaskTest.assertEquals((int)2, (int)processInstance.getState());
    }

    private static class TestWorkItemHandler
    implements WorkItemHandler {
        private WorkItem workItem;

        private TestWorkItemHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItem = workItem;
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }

        public WorkItem getWorkItem() {
            return this.workItem;
        }
    }
}

