/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.compiler.PackageBuilder;
import org.drools.process.instance.ProcessInstance;
import org.drools.rule.Package;
import org.drools.workflow.instance.WorkflowProcessInstanceUpgrader;

public class ProcessUpgradeTest
extends TestCase {
    public void testUpgrade() throws Exception {
        String rule = "package org.test;\n";
        rule = rule + "import org.drools.Person\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Rule 1\"\n";
        rule = rule + "  ruleflow-group \"hello\"\n";
        rule = rule + "when\n";
        rule = rule + "    $p : Person( ) \n";
        rule = rule + "then\n";
        rule = rule + "    list.add( $p );\n";
        rule = rule + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-4.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-4.0/process drools-processes-4.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow\" package-name=\"org.test\" >\n  <header>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <ruleSet id=\"2\" name=\"Hello\" ruleFlowGroup=\"hello\" />\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"3\"/>\n  </connections>\n</process>";
        builder.addProcessFromXml((Reader)new StringReader(process));
        Package pkg = builder.getPackage();
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        config.setRuleBaseUpdateHandler(null);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)config);
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Person p = new Person("bobba fet", 32);
        session.insert((Object)p);
        ProcessInstance processInstance = session.startProcess("org.test.ruleflow");
        ProcessUpgradeTest.assertEquals((int)1, (int)session.getProcessInstances().size());
        String process2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-4.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-4.0/process drools-processes-4.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow2\" package-name=\"org.test\" >\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <ruleSet id=\"2\" name=\"Hello\" ruleFlowGroup=\"hello\" />\n    <actionNode id=\"4\" name=\"Action\" >      <action type=\"expression\" dialect=\"java\">System.out.println();\nlist.add(\"Executed\");</action>/n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"4\"/>\n    <connection from=\"4\" to=\"3\"/>\n  </connections>\n</process>";
        builder = new PackageBuilder();
        builder.addProcessFromXml((Reader)new StringReader(process2));
        pkg = builder.getPackage();
        ruleBase.addPackage(pkg);
        WorkflowProcessInstanceUpgrader.upgradeProcessInstance((WorkingMemory)session, (long)processInstance.getId(), (String)"org.test.ruleflow2", new HashMap());
        ProcessUpgradeTest.assertEquals((String)"org.test.ruleflow2", (String)processInstance.getProcessId());
        session.fireAllRules();
        ProcessUpgradeTest.assertEquals((int)2, (int)list.size());
        ProcessUpgradeTest.assertEquals((int)2, (int)processInstance.getState());
    }
}

