/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.PackageBuilder;
import org.drools.integrationtests.SerializationHelper;
import org.drools.rule.Package;

public class RulebasePartitioningTest
extends TestCase {
    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    public void testDummy() {
        RulebasePartitioningTest.assertEquals((boolean)true, (boolean)true);
    }

    public void FIXMEtestRulebasePartitions1() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_rulebasePartitions1.drl")));
        Package pkg = builder.getPackage();
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        config.setMultithreadEvaluation(true);
        RuleBase ruleBase = this.getRuleBase(config);
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        List result = new ArrayList();
        session.setGlobal("results", result);
        Cheese c1 = new Cheese("stilton");
        Cheese c2 = new Cheese("brie");
        Cheese c3 = new Cheese("cheddar");
        Cheese c4 = new Cheese("stilton");
        Person p1 = new Person("bob");
        Person p2 = new Person("mark");
        Person p3 = new Person("michael");
        Person p4 = new Person("bob");
        session.insert((Object)c1);
        session.insert((Object)c2);
        session.insert((Object)c3);
        session.insert((Object)c4);
        session.insert((Object)p1);
        session.insert((Object)p2);
        session.insert((Object)p3);
        session.insert((Object)p4);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        result = (List)session.getGlobal("results");
        session.fireAllRules();
        RulebasePartitioningTest.assertEquals((int)3, (int)result.size());
        RulebasePartitioningTest.assertEquals((Object)p4, result.get(0));
        RulebasePartitioningTest.assertEquals((Object)p1, result.get(1));
        RulebasePartitioningTest.assertEquals((Object)c3, result.get(2));
        session.dispose();
    }
}

