/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.ClockType;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.SessionConfiguration;
import org.drools.StockTick;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.KnowledgeType;
import org.drools.common.InternalFactHandle;
import org.drools.compiler.DroolsParserException;
import org.drools.integrationtests.SerializationHelper;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;

public class StreamsTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private KnowledgeBase loadKnowledgeBase(Reader reader) throws IOException, DroolsParserException, Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.addResource(reader, KnowledgeType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return SerializationHelper.serializeObject(kbase);
    }

    public void testEventAssertion() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_EntryPoint.drl"));
        KnowledgeBase kbase = this.loadKnowledgeBase(reader);
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulKnowledgeSession session = kbase.newStatefulSession((KnowledgeSessionConfiguration)conf);
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        StockTick tick1 = new StockTick(1L, "DROO", 50.0, System.currentTimeMillis());
        StockTick tick2 = new StockTick(2L, "ACME", 10.0, System.currentTimeMillis());
        StockTick tick3 = new StockTick(3L, "ACME", 10.0, System.currentTimeMillis());
        StockTick tick4 = new StockTick(4L, "DROO", 50.0, System.currentTimeMillis());
        InternalFactHandle handle1 = (InternalFactHandle)session.insert((Object)tick1);
        InternalFactHandle handle2 = (InternalFactHandle)session.insert((Object)tick2);
        InternalFactHandle handle3 = (InternalFactHandle)session.insert((Object)tick3);
        InternalFactHandle handle4 = (InternalFactHandle)session.insert((Object)tick4);
        StreamsTest.assertNotNull((Object)handle1);
        StreamsTest.assertNotNull((Object)handle2);
        StreamsTest.assertNotNull((Object)handle3);
        StreamsTest.assertNotNull((Object)handle4);
        StreamsTest.assertTrue((boolean)handle1.isEvent());
        StreamsTest.assertTrue((boolean)handle2.isEvent());
        StreamsTest.assertTrue((boolean)handle3.isEvent());
        StreamsTest.assertTrue((boolean)handle4.isEvent());
        session.fireAllRules();
        StreamsTest.assertEquals((int)0, (int)results.size());
        StockTick tick5 = new StockTick(5L, "DROO", 50.0, System.currentTimeMillis());
        StockTick tick6 = new StockTick(6L, "ACME", 10.0, System.currentTimeMillis());
        StockTick tick7 = new StockTick(7L, "ACME", 15.0, System.currentTimeMillis());
        StockTick tick8 = new StockTick(8L, "DROO", 50.0, System.currentTimeMillis());
        WorkingMemoryEntryPoint entry = session.getWorkingMemoryEntryPoint("StockStream");
        InternalFactHandle handle5 = (InternalFactHandle)entry.insert((Object)tick5);
        InternalFactHandle handle6 = (InternalFactHandle)entry.insert((Object)tick6);
        InternalFactHandle handle7 = (InternalFactHandle)entry.insert((Object)tick7);
        InternalFactHandle handle8 = (InternalFactHandle)entry.insert((Object)tick8);
        StreamsTest.assertNotNull((Object)handle5);
        StreamsTest.assertNotNull((Object)handle6);
        StreamsTest.assertNotNull((Object)handle7);
        StreamsTest.assertNotNull((Object)handle8);
        StreamsTest.assertTrue((boolean)handle5.isEvent());
        StreamsTest.assertTrue((boolean)handle6.isEvent());
        StreamsTest.assertTrue((boolean)handle7.isEvent());
        StreamsTest.assertTrue((boolean)handle8.isEvent());
        session.fireAllRules();
        StreamsTest.assertEquals((int)1, (int)results.size());
        StreamsTest.assertSame((Object)tick7, results.get(0));
    }
}

