/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import junit.framework.TestCase;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;
import org.drools.compiler.DroolsParserException;
import org.drools.lang.DRLLexer;
import org.drools.lang.DRLParser;
import org.drools.lang.DroolsTreeAdaptor;
import org.drools.lang.dsl.DefaultExpander;

public class ErrorsParserTest
extends TestCase {
    private DRLParser parser;

    protected void setUp() throws Exception {
        super.setUp();
        this.parser = null;
    }

    protected void tearDown() throws Exception {
        this.parser = null;
        super.tearDown();
    }

    public void testPartialAST() throws Exception {
        this.parseResource("pattern_partial.drl");
        Tree object = (Tree)this.parser.compilation_unit().getTree();
        System.out.println(this.getName());
        for (String message : this.parser.getErrorMessages()) {
            System.out.println(message);
        }
        ErrorsParserTest.assertTrue((boolean)this.parser.hasErrors());
    }

    public void testNotBindindShouldBarf() throws Exception {
        DRLParser parser = this.parseResource("not_with_binding_error.drl");
        parser.compilation_unit();
        System.out.println(this.getName());
        for (String message : this.parser.getErrorMessages()) {
            System.out.println(message);
        }
        ErrorsParserTest.assertTrue((boolean)parser.hasErrors());
    }

    public void testExpanderErrorsAfterExpansion() throws Exception {
        String name = "expander_post_errors.dslr";
        DefaultExpander expander = new DefaultExpander();
        String expanded = expander.expand(this.getReader("expander_post_errors.dslr"));
        DRLParser parser = this.parse("expander_post_errors.dslr", expanded);
        parser.compilation_unit();
        ErrorsParserTest.assertTrue((boolean)parser.hasErrors());
        System.out.println(this.getName());
        for (String message : this.parser.getErrorMessages()) {
            System.out.println(message);
        }
        DroolsParserException err = (DroolsParserException)parser.getErrors().get(0);
        ErrorsParserTest.assertEquals((int)1, (int)parser.getErrors().size());
        ErrorsParserTest.assertEquals((int)5, (int)err.getLineNumber());
    }

    public void testInvalidSyntax_Catches() throws Exception {
        this.parseResource("invalid_syntax.drl").compilation_unit();
        System.out.println(this.getName());
        for (String message : this.parser.getErrorMessages()) {
            System.out.println(message);
        }
        ErrorsParserTest.assertTrue((boolean)this.parser.hasErrors());
    }

    public void testMultipleErrors() throws Exception {
        this.parseResource("multiple_errors.drl").compilation_unit();
        System.out.println(this.getName());
        for (String message : this.parser.getErrorMessages()) {
            System.out.println(message);
        }
        ErrorsParserTest.assertTrue((boolean)this.parser.hasErrors());
        ErrorsParserTest.assertEquals((int)2, (int)this.parser.getErrors().size());
    }

    public void testPackageGarbage() throws Exception {
        this.parseResource("package_garbage.drl").compilation_unit();
        System.out.println(this.getName());
        for (String message : this.parser.getErrorMessages()) {
            System.out.println(message);
        }
        ErrorsParserTest.assertTrue((boolean)this.parser.hasErrors());
    }

    public void testEvalWithSemicolon() throws Exception {
        this.parseResource("eval_with_semicolon.drl").compilation_unit();
        System.out.println(this.getName());
        for (String message : this.parser.getErrorMessages()) {
            System.out.println(message);
        }
        ErrorsParserTest.assertTrue((boolean)this.parser.hasErrors());
        ErrorsParserTest.assertEquals((int)1, (int)this.parser.getErrorMessages().size());
        ErrorsParserTest.assertEquals((String)"ERR 108", (String)((DroolsParserException)this.parser.getErrors().get(0)).getErrorCode());
    }

    public void testRuleParseLhs2() throws Exception {
        String text = "Message( Message.HELLO )\n";
        this.parse("Message( Message.HELLO )\n").lhs_pattern();
        System.out.println(this.getName());
        for (String message : this.parser.getErrorMessages()) {
            System.out.println(message);
        }
        ErrorsParserTest.assertTrue((boolean)this.parser.hasErrors());
    }

    public void testErrorMessageForMisplacedParenthesis() throws Exception {
        DRLParser parser = this.parseResource("misplaced_parenthesis.drl");
        parser.compilation_unit();
        System.out.println(this.getName());
        for (String message : this.parser.getErrorMessages()) {
            System.out.println(message);
        }
        ErrorsParserTest.assertTrue((String)"Parser should have raised errors", (boolean)parser.hasErrors());
        ErrorsParserTest.assertEquals((int)2, (int)parser.getErrors().size());
        ErrorsParserTest.assertEquals((String)"ERR 103", (String)((DroolsParserException)parser.getErrors().get(0)).getErrorCode());
        ErrorsParserTest.assertEquals((String)"ERR 101", (String)((DroolsParserException)parser.getErrors().get(1)).getErrorCode());
    }

    public void testNPEOnParser() throws Exception {
        DRLParser parser = this.parseResource("npe_on_parser.drl");
        parser.compilation_unit();
        System.out.println(this.getName());
        for (String message : this.parser.getErrorMessages()) {
            System.out.println(message);
        }
        ErrorsParserTest.assertTrue((String)"Parser should have raised errors", (boolean)parser.hasErrors());
        ErrorsParserTest.assertEquals((int)1, (int)parser.getErrors().size());
        ErrorsParserTest.assertTrue((boolean)((DroolsParserException)parser.getErrors().get(0)).getErrorCode().equals("ERR 103"));
    }

    public void testCommaMisuse() throws Exception {
        DRLParser parser = this.parseResource("comma_misuse.drl");
        try {
            parser.compilation_unit();
            System.out.println(this.getName());
            for (String message : this.parser.getErrorMessages()) {
                System.out.println(message);
            }
            ErrorsParserTest.assertTrue((String)"Parser should have raised errors", (boolean)parser.hasErrors());
            ErrorsParserTest.assertEquals((int)3, (int)parser.getErrors().size());
        }
        catch (NullPointerException npe) {
            ErrorsParserTest.fail((String)"Should not raise NPE");
        }
    }

    private DRLParser parse(String text) throws Exception {
        this.parser = this.newParser(this.newTokenStream((Lexer)this.newLexer(this.newCharStream(text))));
        return this.parser;
    }

    private DRLParser parse(String source, String text) throws Exception {
        this.parser = this.newParser(this.newTokenStream((Lexer)this.newLexer(this.newCharStream(text))));
        return this.parser;
    }

    private Reader getReader(String name) throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        return new InputStreamReader(in);
    }

    private DRLParser parseResource(String name) throws Exception {
        Reader reader = this.getReader(name);
        StringBuffer text = new StringBuffer();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return this.parse(name, text.toString());
    }

    private CharStream newCharStream(String text) {
        return new ANTLRStringStream(text);
    }

    private DRLLexer newLexer(CharStream charStream) {
        return new DRLLexer(charStream);
    }

    private TokenStream newTokenStream(Lexer lexer) {
        return new CommonTokenStream((TokenSource)lexer);
    }

    private DRLParser newParser(TokenStream tokenStream) {
        DRLParser p = new DRLParser(tokenStream);
        p.setTreeAdaptor((TreeAdaptor)new DroolsTreeAdaptor());
        return p;
    }
}

