/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.drools.lang.dsl.DSLMappingEntry;
import org.drools.lang.dsl.DSLMappingFile;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.drools.lang.dsl.DefaultExpander;

public class DSLTokenizedMappingFileTest
extends TestCase {
    private DSLMappingFile file = null;
    private final String filename = "test_metainfo.dsl";

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testParseFile() {
        try {
            InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(this.filename));
            this.file = new DSLTokenizedMappingFile();
            boolean parsingResult = this.file.parseAndLoad((Reader)reader);
            ((Reader)reader).close();
            DSLTokenizedMappingFileTest.assertTrue((String)this.file.getErrors().toString(), (boolean)parsingResult);
            DSLTokenizedMappingFileTest.assertTrue((boolean)this.file.getErrors().isEmpty());
            DSLTokenizedMappingFileTest.assertEquals((int)31, (int)this.file.getMapping().getEntries().size());
        }
        catch (IOException e) {
            e.printStackTrace();
            DSLTokenizedMappingFileTest.fail((String)"Should not raise exception ");
        }
    }

    public void testParseFileWithBrackets() {
        String file = "[when]ATTRIBUTE \"{attr}\" IS IN [{list}]=Attribute( {attr} in ({list}) )";
        try {
            StringReader reader = new StringReader(file);
            this.file = new DSLTokenizedMappingFile();
            boolean parsingResult = this.file.parseAndLoad((Reader)reader);
            ((Reader)reader).close();
            DSLTokenizedMappingFileTest.assertTrue((String)this.file.getErrors().toString(), (boolean)parsingResult);
            DSLTokenizedMappingFileTest.assertTrue((boolean)this.file.getErrors().isEmpty());
            DSLTokenizedMappingFileTest.assertEquals((int)1, (int)this.file.getMapping().getEntries().size());
            DSLMappingEntry entry = (DSLMappingEntry)this.file.getMapping().getEntries().get(0);
            DSLTokenizedMappingFileTest.assertEquals((Object)DSLMappingEntry.CONDITION, (Object)entry.getSection());
            DSLTokenizedMappingFileTest.assertEquals((Object)DSLMappingEntry.EMPTY_METADATA, (Object)entry.getMetaData());
            DSLTokenizedMappingFileTest.assertEquals((String)"(\\W|^)ATTRIBUTE \"(.*?)\" IS IN [(.*?)](\\W|$)", (String)entry.getKeyPattern().toString());
            DSLTokenizedMappingFileTest.assertEquals((String)"$1Attribute( $2 in ($3) ) $4", (String)entry.getValuePattern());
        }
        catch (IOException e) {
            e.printStackTrace();
            DSLTokenizedMappingFileTest.fail((String)"Should not raise exception ");
        }
    }

    public void testParseFileWithEscaptedBrackets() {
        String file = "[when]ATTRIBUTE \"{attr}\" IS IN \\[{list}\\]=Attribute( {attr} in ({list}) )";
        try {
            StringReader reader = new StringReader(file);
            this.file = new DSLTokenizedMappingFile();
            boolean parsingResult = this.file.parseAndLoad((Reader)reader);
            ((Reader)reader).close();
            DSLTokenizedMappingFileTest.assertTrue((String)this.file.getErrors().toString(), (boolean)parsingResult);
            DSLTokenizedMappingFileTest.assertTrue((boolean)this.file.getErrors().isEmpty());
            DSLTokenizedMappingFileTest.assertEquals((int)1, (int)this.file.getMapping().getEntries().size());
            DSLMappingEntry entry = (DSLMappingEntry)this.file.getMapping().getEntries().get(0);
            DSLTokenizedMappingFileTest.assertEquals((Object)DSLMappingEntry.CONDITION, (Object)entry.getSection());
            DSLTokenizedMappingFileTest.assertEquals((Object)DSLMappingEntry.EMPTY_METADATA, (Object)entry.getMetaData());
            DSLTokenizedMappingFileTest.assertEquals((String)"(\\W|^)ATTRIBUTE \"(.*?)\" IS IN \\[(.*?)\\](\\W|$)", (String)entry.getKeyPattern().toString());
            DSLTokenizedMappingFileTest.assertEquals((String)"$1Attribute( $2 in ($3) ) $4", (String)entry.getValuePattern());
        }
        catch (IOException e) {
            e.printStackTrace();
            DSLTokenizedMappingFileTest.fail((String)"Should not raise exception ");
        }
    }

    public void testParseFileWithEscapes() {
        String file = "[then]TEST=System.out.println(\"DO_SOMETHING\");\n[when]code {code1} occurs and sum of all digit not equal \\( {code2} \\+ {code3} \\)=AAAA( cd1 == {code1}, cd2 != ( {code2} + {code3} ))\n[when]code {code1} occurs=BBBB\n";
        try {
            StringReader reader = new StringReader(file);
            this.file = new DSLTokenizedMappingFile();
            boolean parsingResult = this.file.parseAndLoad((Reader)reader);
            ((Reader)reader).close();
            DSLTokenizedMappingFileTest.assertTrue((String)this.file.getErrors().toString(), (boolean)parsingResult);
            DSLTokenizedMappingFileTest.assertTrue((boolean)this.file.getErrors().isEmpty());
            String LHS = "code 1041 occurs and sum of all digit not equal ( 1034 + 1035 )";
            String rule = "rule \"x\"\nwhen\ncode 1041 occurs and sum of all digit not equal ( 1034 + 1035 )\nthen\nTEST\nend";
            DefaultExpander de = new DefaultExpander();
            de.addDSLMapping(this.file.getMapping());
            String ruleAfterExpansion = de.expand("rule \"x\"\nwhen\ncode 1041 occurs and sum of all digit not equal ( 1034 + 1035 )\nthen\nTEST\nend");
            String expected = "rule \"x\"\nwhen\nAAAA( cd1 == 1041, cd2 != ( 1034 + 1035 )) \nthen\nSystem.out.println(\"DO_SOMETHING\"); \nend\n";
            DSLTokenizedMappingFileTest.assertEquals((String)"rule \"x\"\nwhen\nAAAA( cd1 == 1041, cd2 != ( 1034 + 1035 )) \nthen\nSystem.out.println(\"DO_SOMETHING\"); \nend\n", (String)ruleAfterExpansion);
        }
        catch (IOException e) {
            e.printStackTrace();
            DSLTokenizedMappingFileTest.fail((String)"Should not raise exception ");
        }
    }

    public void testParseFileWithEscaptedEquals() {
        String file = "[when]something:\\={value}=Attribute( something == \"{value}\" )";
        try {
            StringReader reader = new StringReader(file);
            this.file = new DSLTokenizedMappingFile();
            boolean parsingResult = this.file.parseAndLoad((Reader)reader);
            ((Reader)reader).close();
            DSLTokenizedMappingFileTest.assertTrue((String)this.file.getErrors().toString(), (boolean)parsingResult);
            DSLTokenizedMappingFileTest.assertTrue((boolean)this.file.getErrors().isEmpty());
            DSLTokenizedMappingFileTest.assertEquals((int)1, (int)this.file.getMapping().getEntries().size());
            DSLMappingEntry entry = (DSLMappingEntry)this.file.getMapping().getEntries().get(0);
            DSLTokenizedMappingFileTest.assertEquals((Object)DSLMappingEntry.CONDITION, (Object)entry.getSection());
            DSLTokenizedMappingFileTest.assertEquals((Object)DSLMappingEntry.EMPTY_METADATA, (Object)entry.getMetaData());
            DSLTokenizedMappingFileTest.assertEquals((String)"(\\W|^)something:\\=(.*?)$", (String)entry.getKeyPattern().toString());
            DSLTokenizedMappingFileTest.assertEquals((String)"$1Attribute( something == \"$2\" ) ", (String)entry.getMappingValue());
        }
        catch (IOException e) {
            e.printStackTrace();
            DSLTokenizedMappingFileTest.fail((String)"Should not raise exception ");
        }
    }
}

