/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.base.DefaultKnowledgeHelper;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.lang.descr.ActionDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.ProcessDescr;
import org.drools.rule.Package;
import org.drools.rule.builder.PackageBuildContext;
import org.drools.rule.builder.ProcessBuildContext;
import org.drools.rule.builder.dialect.java.JavaDialect;
import org.drools.spi.Action;
import org.drools.spi.KnowledgeHelper;
import org.drools.workflow.core.DroolsAction;
import org.drools.workflow.core.impl.DroolsConsequenceAction;
import org.drools.workflow.core.impl.WorkflowProcessImpl;
import org.drools.workflow.core.node.ActionNode;

public class JavaActionBuilderTest
extends TestCase {
    public void setUp() {
    }

    public void testSimpleAction() throws Exception {
        Package pkg = new Package("pkg1");
        ActionDescr actionDescr = new ActionDescr();
        actionDescr.setText("list.add( \"hello world\" );");
        PackageBuilder pkgBuilder = new PackageBuilder(pkg);
        PackageBuilderConfiguration conf = pkgBuilder.getPackageBuilderConfiguration();
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        JavaDialect javaDialect = (JavaDialect)dialectRegistry.getDialect("java");
        ProcessDescr processDescr = new ProcessDescr();
        processDescr.setClassName("Process1");
        processDescr.setName("Process1");
        WorkflowProcessImpl process = new WorkflowProcessImpl();
        process.setName("Process1");
        process.setPackageName("pkg1");
        ProcessBuildContext context = new ProcessBuildContext(pkgBuilder, pkgBuilder.getPackage(), null, (BaseDescr)processDescr, dialectRegistry, (Dialect)javaDialect);
        context.init(pkgBuilder, pkg, null, dialectRegistry, (Dialect)javaDialect, null);
        pkgBuilder.addPackageFromDrl((Reader)new StringReader("package pkg1;\nglobal java.util.List list;\n"));
        ActionNode actionNode = new ActionNode();
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        actionNode.setAction((DroolsAction)action);
        javaDialect.getActionBuilder().build((PackageBuildContext)context, (DroolsAction)action, actionDescr);
        javaDialect.addProcess(context);
        javaDialect.compileAll();
        JavaActionBuilderTest.assertEquals((int)0, (int)javaDialect.getResults().size());
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkgBuilder.getPackage());
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        DefaultKnowledgeHelper knowledgeHelper = new DefaultKnowledgeHelper();
        ((Action)actionNode.getAction().getMetaData("Action")).execute((KnowledgeHelper)knowledgeHelper, (WorkingMemory)wm, null);
        JavaActionBuilderTest.assertEquals((Object)"hello world", list.get(0));
    }
}

