/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.base.ClassTypeResolver;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.DrlParser;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.GroupElement;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.rule.TimeMachine;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleBuilder;

public class RuleBuilderTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBuild() throws Exception {
        DrlParser parser = new DrlParser();
        PackageBuilder pkgBuilder = new PackageBuilder();
        pkgBuilder.addPackage(new PackageDescr("org.drools"));
        Package pkg = pkgBuilder.getPackage();
        PackageDescr pkgDescr = parser.parse((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("nestedConditionalElements.drl")));
        Assert.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
        RuleDescr ruleDescr = (RuleDescr)pkgDescr.getRules().get(0);
        String ruleClassName = "RuleClassName.java";
        ruleDescr.setClassName("RuleClassName.java");
        ruleDescr.addAttribute(new AttributeDescr("dialect", "java"));
        ClassTypeResolver typeResolver = new ClassTypeResolver(new HashSet(), ((Object)((Object)this)).getClass().getClassLoader());
        typeResolver.addImport(pkgDescr.getName() + ".*");
        typeResolver.addImport("java.lang.*");
        RuleBuilder builder = new RuleBuilder();
        PackageBuilderConfiguration conf = pkgBuilder.getPackageBuilderConfiguration();
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        Dialect dialect = dialectRegistry.getDialect("java");
        RuleBuildContext context = new RuleBuildContext(pkgBuilder, ruleDescr, dialectRegistry, pkg, dialect);
        builder.build(context);
        Assert.assertTrue((String)context.getErrors().toString(), (boolean)context.getErrors().isEmpty());
        Rule rule = context.getRule();
        RuleBuilderTest.assertEquals((String)"There should be 2 rule level declarations", (int)2, (int)rule.getDeclarations().length);
        GroupElement not = (GroupElement)rule.getLhs().getChildren().get(1);
        RuleBuilderTest.assertTrue((boolean)not.isNot());
        RuleBuilderTest.assertTrue((boolean)not.getOuterDeclarations().isEmpty());
        RuleBuilderTest.assertEquals((int)1, (int)not.getInnerDeclarations().size());
        RuleBuilderTest.assertTrue((boolean)not.getInnerDeclarations().keySet().contains("$state"));
        GroupElement not2 = (GroupElement)((GroupElement)not.getChildren().get(0)).getChildren().get(1);
        RuleBuilderTest.assertTrue((boolean)not2.isNot());
        RuleBuilderTest.assertTrue((boolean)not2.getOuterDeclarations().isEmpty());
        RuleBuilderTest.assertEquals((int)1, (int)not2.getInnerDeclarations().size());
        RuleBuilderTest.assertTrue((boolean)not2.getInnerDeclarations().keySet().contains("$likes"));
    }

    public void testBuildAttributes() throws Exception {
        Rule rule = new Rule("my rule");
        ArrayList<AttributeDescr> attributes = new ArrayList<AttributeDescr>();
        attributes.add(new AttributeDescr("dialect", "java"));
        attributes.add(new AttributeDescr("no-loop", "true"));
        attributes.add(new AttributeDescr("enabled", "false"));
        attributes.add(new AttributeDescr("ruleflow-group", "mygroup"));
        RuleBuildContext.setAttributes((Rule)rule, null, attributes);
        RuleBuilderTest.assertTrue((boolean)rule.isNoLoop());
        RuleBuilderTest.assertFalse((boolean)rule.isEffective(new TimeMachine(), null, null));
        RuleBuilderTest.assertEquals((String)"mygroup", (String)rule.getRuleFlowGroup());
        attributes = new ArrayList();
        attributes.add(new AttributeDescr("date-effective", "10-Jul-1974"));
        attributes.add(new AttributeDescr("date-expires", "10-Jul-2040"));
        rule = new Rule("myrule");
        RuleBuildContext.setAttributes((Rule)rule, null, attributes);
        Field eff = rule.getClass().getDeclaredField("dateEffective");
        eff.setAccessible(true);
        Calendar effectiveDate = (Calendar)eff.get(rule);
        RuleBuilderTest.assertNotNull((Object)effectiveDate);
        RuleBuilderTest.assertEquals((int)1974, (int)effectiveDate.get(1));
        Field exp = rule.getClass().getDeclaredField("dateExpires");
        exp.setAccessible(true);
        Calendar expiryDate = (Calendar)exp.get(rule);
        RuleBuilderTest.assertEquals((int)2040, (int)expiryDate.get(1));
        RuleBuilderTest.assertNotNull((Object)expiryDate);
    }
}

