/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.base.DefaultKnowledgeHelper;
import org.drools.base.mvel.MVELAction;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.lang.descr.ActionDescr;
import org.drools.rule.Package;
import org.drools.rule.builder.PackageBuildContext;
import org.drools.rule.builder.dialect.mvel.MVELActionBuilder;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.spi.Action;
import org.drools.spi.KnowledgeHelper;
import org.drools.workflow.core.DroolsAction;
import org.drools.workflow.core.impl.DroolsConsequenceAction;
import org.drools.workflow.core.node.ActionNode;

public class MVELActionBuilderTest
extends TestCase {
    public void setUp() {
    }

    public void testSimpleAction() throws Exception {
        Package pkg = new Package("pkg1");
        ActionDescr actionDescr = new ActionDescr();
        actionDescr.setText("list.add( 'hello world' )");
        PackageBuilder pkgBuilder = new PackageBuilder(pkg);
        PackageBuilderConfiguration conf = pkgBuilder.getPackageBuilderConfiguration();
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        MVELDialect mvelDialect = (MVELDialect)dialectRegistry.getDialect("mvel");
        PackageBuildContext context = new PackageBuildContext();
        context.init(pkgBuilder, pkg, null, dialectRegistry, (Dialect)mvelDialect, null);
        pkgBuilder.addPackageFromDrl((Reader)new StringReader("package pkg1;\nglobal java.util.List list;\n"));
        ActionNode actionNode = new ActionNode();
        DroolsConsequenceAction action = new DroolsConsequenceAction("mvel", null);
        actionNode.setAction((DroolsAction)action);
        MVELActionBuilder builder = new MVELActionBuilder();
        builder.build(context, (DroolsAction)action, actionDescr);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkgBuilder.getPackage());
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        ((MVELAction)actionNode.getAction().getMetaData("Action")).compile(Thread.currentThread().getContextClassLoader());
        DefaultKnowledgeHelper knowledgeHelper = new DefaultKnowledgeHelper();
        ((Action)actionNode.getAction().getMetaData("Action")).execute((KnowledgeHelper)knowledgeHelper, (WorkingMemory)wm, null);
        MVELActionBuilderTest.assertEquals((Object)"hello world", list.get(0));
    }
}

