/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.base.ClassObjectType;
import org.drools.base.DefaultKnowledgeHelper;
import org.drools.base.mvel.MVELConsequence;
import org.drools.base.mvel.MVELDebugHandler;
import org.drools.common.AgendaItem;
import org.drools.common.InternalFactHandle;
import org.drools.common.PropagationContextImpl;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.PackageRegistry;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.MockLeftTupleSink;
import org.drools.rule.Declaration;
import org.drools.rule.GroupElement;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleBuilder;
import org.drools.rule.builder.dialect.mvel.InstrumentedBuildContent;
import org.drools.rule.builder.dialect.mvel.InstrumentedDeclarationScopeResolver;
import org.drools.rule.builder.dialect.mvel.MVELConsequenceBuilder;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.spi.Activation;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.ObjectType;
import org.drools.spi.PatternExtractor;
import org.drools.spi.PropagationContext;
import org.drools.spi.Tuple;
import org.mvel2.ParserContext;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExpressionCompiler;
import org.mvel2.debug.DebugTools;

public class MVELConsequenceBuilderTest
extends TestCase {
    public void setUp() {
    }

    public void testSimpleExpression() throws Exception {
        PackageDescr pkgDescr = new PackageDescr("pkg1");
        PackageBuilder pkgBuilder = new PackageBuilder();
        pkgBuilder.addPackage(pkgDescr);
        Package pkg = pkgBuilder.getPackageRegistry("pkg1").getPackage();
        RuleDescr ruleDescr = new RuleDescr("rule 1");
        ruleDescr.setNamespace("pkg1");
        ruleDescr.setConsequence((Object)"modify (cheese) {price = 5 };\nretract (cheese)");
        PackageBuilderConfiguration conf = pkgBuilder.getPackageBuilderConfiguration();
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        MVELDialect mvelDialect = (MVELDialect)dialectRegistry.getDialect("mvel");
        InstrumentedBuildContent context = new InstrumentedBuildContent(pkgBuilder, ruleDescr, dialectRegistry, pkg, (Dialect)mvelDialect);
        InstrumentedDeclarationScopeResolver declarationResolver = new InstrumentedDeclarationScopeResolver();
        ClassObjectType cheeseObjeectType = new ClassObjectType(Cheese.class);
        Pattern pattern = new Pattern(0, (ObjectType)cheeseObjeectType, "cheese");
        GroupElement subrule = new GroupElement(GroupElement.AND);
        subrule.addChild((RuleConditionElement)pattern);
        HashMap<String, Declaration> map = new HashMap<String, Declaration>();
        map.put("cheese", pattern.getDeclaration());
        declarationResolver.setDeclarations(map);
        context.setDeclarationResolver(declarationResolver);
        MVELConsequenceBuilder builder = new MVELConsequenceBuilder();
        builder.build((RuleBuildContext)context);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession wm = ruleBase.newStatefulSession();
        MockLeftTupleSink sink = new MockLeftTupleSink();
        Cheese cheddar = new Cheese("cheddar", 10);
        InternalFactHandle f0 = (InternalFactHandle)wm.insert((Object)cheddar);
        LeftTuple tuple = new LeftTuple(f0, (LeftTupleSink)sink, true);
        AgendaItem item = new AgendaItem(0L, (Tuple)tuple, 10, (PropagationContext)new PropagationContextImpl(1L, 1, null, null, null), context.getRule(), subrule);
        DefaultKnowledgeHelper kbHelper = new DefaultKnowledgeHelper((WorkingMemory)wm);
        kbHelper.setActivation((Activation)item);
        ((MVELConsequence)context.getRule().getConsequence()).compile(Thread.currentThread().getContextClassLoader());
        context.getRule().getConsequence().evaluate((KnowledgeHelper)kbHelper, (WorkingMemory)wm);
        MVELConsequenceBuilderTest.assertEquals((int)5, (int)cheddar.getPrice());
    }

    public void testKnowledgeHelper() {
    }

    public void testImperativeCodeError() throws Exception {
        Package pkg = new Package("pkg1");
        RuleDescr ruleDescr = new RuleDescr("rule 1");
        ruleDescr.setConsequence((Object)"if (cheese.price == 10) { cheese.price = 5; }");
        Properties properties = new Properties();
        properties.setProperty("drools.dialect.default", "mvel");
        PackageBuilderConfiguration cfg1 = new PackageBuilderConfiguration(properties);
        PackageBuilder pkgBuilder = new PackageBuilder(pkg, cfg1);
        PackageBuilderConfiguration conf = pkgBuilder.getPackageBuilderConfiguration();
        PackageRegistry pkgRegistry = pkgBuilder.getPackageRegistry(pkg.getName());
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        MVELDialect mvelDialect = (MVELDialect)dialectRegistry.getDialect(pkgRegistry.getDialect());
        InstrumentedBuildContent context = new InstrumentedBuildContent(pkgBuilder, ruleDescr, dialectRegistry, pkg, (Dialect)mvelDialect);
        InstrumentedDeclarationScopeResolver declarationResolver = new InstrumentedDeclarationScopeResolver();
        ClassObjectType cheeseObjeectType = new ClassObjectType(Cheese.class);
        Pattern pattern = new Pattern(0, (ObjectType)cheeseObjeectType);
        PatternExtractor extractor = new PatternExtractor((ObjectType)cheeseObjeectType);
        Declaration declaration = new Declaration("cheese", (InternalReadAccessor)extractor, pattern);
        HashMap<String, Declaration> map = new HashMap<String, Declaration>();
        map.put("cheese", declaration);
        declarationResolver.setDeclarations(map);
        context.setDeclarationResolver(declarationResolver);
        MVELConsequenceBuilder builder = new MVELConsequenceBuilder();
        builder.build((RuleBuildContext)context);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        StatefulSession wm = ruleBase.newStatefulSession();
        Cheese cheddar = new Cheese("cheddar", 10);
        InternalFactHandle f0 = (InternalFactHandle)wm.insert((Object)cheddar);
        LeftTuple tuple = new LeftTuple(f0, null, true);
        AgendaItem item = new AgendaItem(0L, (Tuple)tuple, 10, null, context.getRule(), null);
        DefaultKnowledgeHelper kbHelper = new DefaultKnowledgeHelper((WorkingMemory)wm);
        kbHelper.setActivation((Activation)item);
        try {
            ((MVELConsequence)context.getRule().getConsequence()).compile(Thread.currentThread().getContextClassLoader());
            context.getRule().getConsequence().evaluate((KnowledgeHelper)kbHelper, (WorkingMemory)wm);
            MVELConsequenceBuilderTest.fail((String)"should throw an exception, as 'if' is not allowed");
        }
        catch (Exception e) {
            // empty catch block
        }
        MVELConsequenceBuilderTest.assertEquals((int)10, (int)cheddar.getPrice());
    }

    public void testLineSpanOptionalSemis() throws Exception {
        String simpleEx = "foo\nbar\nbaz";
        MVELConsequenceBuilder cons = new MVELConsequenceBuilder();
        MVELConsequenceBuilderTest.assertEquals((String)"foo;\nbar;\nbaz", (String)MVELConsequenceBuilder.delimitExpressions((String)simpleEx));
        String ex = "foo (\n bar \n)\nbar;\nyeah;\nman\nbaby";
        MVELConsequenceBuilderTest.assertEquals((String)"foo (\n bar \n);\nbar;\nyeah;\nman;\nbaby", (String)MVELConsequenceBuilder.delimitExpressions((String)ex));
        ex = "foo {\n bar \n}\nbar;   \nyeah;\nman\nbaby";
        MVELConsequenceBuilderTest.assertEquals((String)"foo {\n bar \n};\nbar;   \nyeah;\nman;\nbaby", (String)MVELConsequenceBuilder.delimitExpressions((String)ex));
        ex = "foo [\n bar \n]\nbar;  x\nyeah();\nman[42]\nbaby;ca chiga;\nend";
        MVELConsequenceBuilderTest.assertEquals((String)"foo [\n bar \n];\nbar;  x;\nyeah();\nman[42];\nbaby;ca chiga;\nend", (String)MVELConsequenceBuilder.delimitExpressions((String)ex));
        ex = "   \n\nfoo [\n bar \n]\n\n\nbar;  x\n  \nyeah();\nman[42]\nbaby;ca chiga;\nend";
        MVELConsequenceBuilderTest.assertEquals((String)"   \n\nfoo [\n bar \n];\n\n\nbar;  x;\n  \nyeah();\nman[42];\nbaby;ca chiga;\nend", (String)MVELConsequenceBuilder.delimitExpressions((String)ex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMVELDebugSymbols() throws DroolsParserException {
        MVELDebugHandler.setDebugMode((boolean)true);
        try {
            DrlParser parser = new DrlParser();
            PackageDescr pkgDescr = parser.parse((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("mvel_rule.drl")));
            Assert.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
            Package pkg = new Package("org.drools");
            RuleDescr ruleDescr = (RuleDescr)pkgDescr.getRules().get(0);
            RuleBuilder builder = new RuleBuilder();
            PackageBuilder pkgBuilder = new PackageBuilder(pkg);
            PackageBuilderConfiguration conf = pkgBuilder.getPackageBuilderConfiguration();
            DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
            Dialect dialect = dialectRegistry.getDialect("mvel");
            RuleBuildContext context = new RuleBuildContext(pkgBuilder, ruleDescr, dialectRegistry, pkg, dialect);
            builder.build(context);
            Assert.assertTrue((String)context.getErrors().toString(), (boolean)context.getErrors().isEmpty());
            Rule rule = context.getRule();
            MVELConsequence mvelCons = (MVELConsequence)rule.getConsequence();
            mvelCons.compile(Thread.currentThread().getContextClassLoader());
            String s = DebugTools.decompile((Serializable)mvelCons.getCompExpr());
            int fromIndex = 0;
            int count = 0;
            while ((fromIndex = s.indexOf("DEBUG_SYMBOL", fromIndex + 1)) > -1) {
                ++count;
            }
            MVELConsequenceBuilderTest.assertEquals((int)4, (int)count);
        }
        finally {
            MVELDebugHandler.setDebugMode((boolean)false);
        }
    }

    public void testX() {
        String expr = "System.out.println( \"a1\" );\nSystem.out.println( \"a2\" );\nSystem.out.println( \"a3\" );\nSystem.out.println( \"a4\" );\n";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext context = new ParserContext();
        context.addImport("System", System.class);
        context.setStrictTypeEnforcement(true);
        context.setSourceFile("mysource");
        compiler.setDebugSymbols(true);
        CompiledExpression compiledExpression = compiler.compile(context);
        String s = DebugTools.decompile((Serializable)compiledExpression);
        System.out.println("s " + s);
        int fromIndex = 0;
        int count = 0;
        while ((fromIndex = s.indexOf("DEBUG_SYMBOL", fromIndex + 1)) > -1) {
            ++count;
        }
        MVELConsequenceBuilderTest.assertEquals((int)4, (int)count);
    }
}

