/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.mvel.MVELPredicateExpression;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.compiler.Dialect;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.PackageRegistry;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.MockLeftTupleSink;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.mvel.InstrumentedBuildContent;
import org.drools.rule.builder.dialect.mvel.InstrumentedDeclarationScopeResolver;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.rule.builder.dialect.mvel.MVELPredicateBuilder;
import org.drools.runtime.rule.FactHandle;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;

public class MVELPredicateBuilderTest
extends TestCase {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    protected void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    public void testSimpleExpression() {
        ArrayList list;
        Package pkg = new Package("pkg1");
        RuleDescr ruleDescr = new RuleDescr("rule 1");
        PackageBuilder pkgBuilder = new PackageBuilder(pkg);
        PackageBuilderConfiguration conf = pkgBuilder.getPackageBuilderConfiguration();
        PackageRegistry pkgRegistry = pkgBuilder.getPackageRegistry(pkg.getName());
        MVELDialect mvelDialect = (MVELDialect)pkgRegistry.getDialectCompiletimeRegistry().getDialect("mvel");
        InstrumentedBuildContent context = new InstrumentedBuildContent(pkgBuilder, ruleDescr, pkgRegistry.getDialectCompiletimeRegistry(), pkg, (Dialect)mvelDialect);
        InstrumentedDeclarationScopeResolver declarationResolver = new InstrumentedDeclarationScopeResolver();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "price", ((Object)((Object)this)).getClass().getClassLoader());
        Pattern patternA = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Pattern patternB = new Pattern(1, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration a = new Declaration("a", (InternalReadAccessor)extractor, patternA);
        Declaration b = new Declaration("b", (InternalReadAccessor)extractor, patternB);
        HashMap<String, Declaration> map = new HashMap<String, Declaration>();
        map.put("a", a);
        map.put("b", b);
        declarationResolver.setDeclarations(map);
        context.setDeclarationResolver(declarationResolver);
        PredicateDescr predicateDescr = new PredicateDescr();
        predicateDescr.setContent((Object)"a == b");
        MVELPredicateBuilder builder = new MVELPredicateBuilder();
        List[] usedIdentifiers = new ArrayList[2];
        usedIdentifiers[1] = list = new ArrayList();
        Declaration[] previousDeclarations = new Declaration[]{a};
        Declaration[] localDeclarations = new Declaration[]{b};
        PredicateConstraint predicate = new PredicateConstraint(null, localDeclarations);
        builder.build((RuleBuildContext)context, usedIdentifiers, previousDeclarations, localDeclarations, predicate, predicateDescr);
        ((MVELPredicateExpression)predicate.getPredicateExpression()).compile(Thread.currentThread().getContextClassLoader());
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        InternalWorkingMemory wm = (InternalWorkingMemory)ruleBase.newStatefulSession();
        Cheese stilton = new Cheese("stilton", 10);
        Cheese cheddar = new Cheese("cheddar", 10);
        MockLeftTupleSink sink = new MockLeftTupleSink();
        InternalFactHandle f0 = (InternalFactHandle)wm.insert((Object)cheddar);
        InternalFactHandle f1 = (InternalFactHandle)wm.insert((Object)stilton);
        LeftTuple tuple = new LeftTuple(f0, (LeftTupleSink)sink, true);
        PredicateConstraint.PredicateContextEntry predicateContext = (PredicateConstraint.PredicateContextEntry)predicate.createContextEntry();
        predicateContext.leftTuple = tuple;
        predicateContext.workingMemory = wm;
        MVELPredicateBuilderTest.assertTrue((boolean)predicate.isAllowedCachedLeft((ContextEntry)predicateContext, f1));
        cheddar.setPrice(9);
        wm.update((FactHandle)f0, (Object)cheddar);
        MVELPredicateBuilderTest.assertFalse((boolean)predicate.isAllowedCachedLeft((ContextEntry)predicateContext, f1));
    }
}

