/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testframework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.drools.Cheese;
import org.drools.OuterFact;
import org.drools.Person;
import org.drools.StatefulSession;
import org.drools.base.ClassTypeResolver;
import org.drools.base.TypeResolver;
import org.drools.base.mvel.DroolsMVELFactory;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.guvnor.client.modeldriven.testing.ExecutionTrace;
import org.drools.guvnor.client.modeldriven.testing.Expectation;
import org.drools.guvnor.client.modeldriven.testing.FactData;
import org.drools.guvnor.client.modeldriven.testing.FieldData;
import org.drools.guvnor.client.modeldriven.testing.RetractFact;
import org.drools.guvnor.client.modeldriven.testing.Scenario;
import org.drools.guvnor.client.modeldriven.testing.VerifyFact;
import org.drools.guvnor.client.modeldriven.testing.VerifyField;
import org.drools.guvnor.client.modeldriven.testing.VerifyRuleFired;
import org.drools.guvnor.server.util.ScenarioXMLPersistence;
import org.drools.rule.CompositeClassLoader;
import org.drools.rule.TimeMachine;
import org.drools.testframework.MockWorkingMemory;
import org.drools.testframework.RuleUnit;
import org.drools.testframework.ScenarioRunner;
import org.drools.testframework.TestingEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScenarioRunnerTest
extends RuleUnit {
    public void setUp() {
        DroolsMVELFactory d = new DroolsMVELFactory();
    }

    public void testPopulateFacts() throws Exception {
        Scenario sc = new Scenario();
        List<FactData> facts = this.ls(new FactData("Cheese", "c1", this.ls(new FieldData("type", "cheddar"), new FieldData("price", "42")), false), new FactData("Person", "p1", this.ls(new FieldData("name", "mic"), new FieldData("age", "=30 + 3")), false));
        sc.fixtures.addAll(facts);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.Person");
        ScenarioRunner runner = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)new MockWorkingMemory());
        ScenarioRunnerTest.assertTrue((boolean)runner.populatedData.containsKey("c1"));
        ScenarioRunnerTest.assertTrue((boolean)runner.populatedData.containsKey("p1"));
        Cheese c = (Cheese)runner.populatedData.get("c1");
        ScenarioRunnerTest.assertEquals((String)"cheddar", (String)c.getType());
        ScenarioRunnerTest.assertEquals((int)42, (int)c.getPrice());
        Person p = (Person)runner.populatedData.get("p1");
        ScenarioRunnerTest.assertEquals((String)"mic", (String)p.getName());
        ScenarioRunnerTest.assertEquals((int)33, (int)p.getAge());
    }

    public void testPopulateNested() throws Exception {
        Scenario sc = new Scenario();
        List<FactData> facts = this.ls(new FactData("Cheese", "c1", this.ls(new FieldData("type", "cheddar"), new FieldData("price", "42")), false), new FactData("OuterFact", "p1", this.ls(new FieldData("name", "mic"), new FieldData("innerFact", "=c1")), false));
        sc.fixtures.addAll(facts);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.OuterFact");
        ScenarioRunner runner = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)new MockWorkingMemory());
        ScenarioRunnerTest.assertTrue((boolean)runner.populatedData.containsKey("c1"));
        ScenarioRunnerTest.assertTrue((boolean)runner.populatedData.containsKey("p1"));
        OuterFact o = (OuterFact)runner.populatedData.get("p1");
        ScenarioRunnerTest.assertNotNull((Object)o.getInnerFact());
    }

    public void testPopulateEmpty() throws Exception {
        Scenario sc = new Scenario();
        List<FactData> facts = this.ls(new FactData("Cheese", "c1", new ArrayList(), false));
        sc.fixtures.addAll(facts);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        sc.fixtures.addAll(facts);
        resolver.addImport("org.drools.Cheese");
        ScenarioRunner runner = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)new MockWorkingMemory());
        ScenarioRunnerTest.assertTrue((boolean)runner.populatedData.containsKey("c1"));
        ScenarioRunnerTest.assertTrue((boolean)(runner.populatedData.get("c1") instanceof Cheese));
    }

    public void testDateField() throws Exception {
        Scenario sc = new Scenario();
        List<FactData> facts = this.ls(new FactData("Cheese", "c1", this.ls(new FieldData("type", "cheddar"), new FieldData("usedBy", "10-Jul-2008")), false), new FactData("OuterFact", "p1", this.ls(new FieldData("name", "mic"), new FieldData("innerFact", "=c1")), false));
        sc.fixtures.addAll(facts);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.OuterFact");
        ScenarioRunner runner = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)new MockWorkingMemory());
        ScenarioRunnerTest.assertTrue((boolean)runner.populatedData.containsKey("c1"));
        ScenarioRunnerTest.assertTrue((boolean)runner.populatedData.containsKey("p1"));
        Cheese c = (Cheese)runner.populatedData.get("c1");
        ScenarioRunnerTest.assertNotNull((Object)c.getUsedBy());
    }

    public void testPopulateFactsWithExpressions() throws Exception {
        Scenario sc = new Scenario();
        List<FactData> facts = this.ls(new FactData("Cheese", "c1", this.ls(new FieldData("type", "cheddar"), new FieldData("price", "42")), false), new FactData("Cheese", "c2", this.ls(new FieldData("type", "= c1.type")), false));
        sc.fixtures.addAll(facts);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        ScenarioRunner runner = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)new MockWorkingMemory());
        ScenarioRunnerTest.assertTrue((boolean)runner.populatedData.containsKey("c1"));
        ScenarioRunnerTest.assertTrue((boolean)runner.populatedData.containsKey("c2"));
        Cheese c = (Cheese)runner.populatedData.get("c1");
        ScenarioRunnerTest.assertEquals((String)"cheddar", (String)c.getType());
        ScenarioRunnerTest.assertEquals((int)42, (int)c.getPrice());
        Cheese c2 = (Cheese)runner.populatedData.get("c2");
        ScenarioRunnerTest.assertEquals((String)c.getType(), (String)c2.getType());
    }

    public void testPopulateNoData() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        ScenarioRunner run = new ScenarioRunner(new Scenario(), (TypeResolver)resolver, (InternalWorkingMemory)new MockWorkingMemory());
        run.populatedData.clear();
        Cheese c = new Cheese();
        c.setType("whee");
        c.setPrice(1);
        run.populatedData.put("x", c);
        ScenarioRunnerTest.assertEquals((int)1, (int)c.getPrice());
        FactData fd = new FactData("Cheese", "x", this.ls(new FieldData("type", ""), new FieldData("price", "42")), false);
        run.populateFields(fd, run.populatedData, (Object)c);
        ScenarioRunnerTest.assertEquals((String)"whee", (String)c.getType());
        ScenarioRunnerTest.assertEquals((int)42, (int)c.getPrice());
    }

    public void testVerifyFacts() throws Exception {
        int i;
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)new MockWorkingMemory());
        Cheese f1 = new Cheese("cheddar", 42);
        runner.populatedData.put("f1", f1);
        Person f2 = new Person("michael", 33);
        runner.populatedData.put("f2", f2);
        VerifyFact vf = new VerifyFact();
        vf.name = "f1";
        vf.fieldValues = this.ls(new VerifyField("type", "cheddar", "=="), new VerifyField("price", "42", "=="));
        runner.verify(vf);
        for (i = 0; i < vf.fieldValues.size(); ++i) {
            ScenarioRunnerTest.assertTrue((boolean)((VerifyField)vf.fieldValues.get((int)i)).successResult);
        }
        vf = new VerifyFact();
        vf.name = "f2";
        vf.fieldValues = this.ls(new VerifyField("name", "michael", "=="), new VerifyField("age", "33", "=="));
        runner.verify(vf);
        for (i = 0; i < vf.fieldValues.size(); ++i) {
            ScenarioRunnerTest.assertTrue((boolean)((VerifyField)vf.fieldValues.get((int)i)).successResult);
        }
        vf = new VerifyFact();
        vf.name = "f2";
        vf.fieldValues = this.ls(new VerifyField("name", "mark", "=="), new VerifyField("age", "33", "=="));
        runner.verify(vf);
        ScenarioRunnerTest.assertFalse((boolean)((VerifyField)vf.fieldValues.get((int)0)).successResult);
        ScenarioRunnerTest.assertTrue((boolean)((VerifyField)vf.fieldValues.get((int)1)).successResult);
        ScenarioRunnerTest.assertEquals((String)"michael", (String)((VerifyField)vf.fieldValues.get((int)0)).actualResult);
        ScenarioRunnerTest.assertEquals((String)"mark", (String)((VerifyField)vf.fieldValues.get((int)0)).expected);
        vf = new VerifyFact();
        vf.name = "f2";
        vf.fieldValues = this.ls(new VerifyField("name", "mark", "=="), new VerifyField("age", "32", "=="));
        runner.verify(vf);
        ScenarioRunnerTest.assertFalse((boolean)((VerifyField)vf.fieldValues.get((int)0)).successResult);
        ScenarioRunnerTest.assertFalse((boolean)((VerifyField)vf.fieldValues.get((int)1)).successResult);
        ScenarioRunnerTest.assertEquals((String)"michael", (String)((VerifyField)vf.fieldValues.get((int)0)).actualResult);
        ScenarioRunnerTest.assertEquals((String)"mark", (String)((VerifyField)vf.fieldValues.get((int)0)).expected);
        ScenarioRunnerTest.assertEquals((String)"33", (String)((VerifyField)vf.fieldValues.get((int)1)).actualResult);
        ScenarioRunnerTest.assertEquals((String)"32", (String)((VerifyField)vf.fieldValues.get((int)1)).expected);
    }

    public void testVerifyAnonymousFacts() throws Exception {
        MockWorkingMemory wm = new MockWorkingMemory();
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)wm);
        Cheese c = new Cheese();
        c.setPrice(42);
        c.setType("stilton");
        wm.facts.add(c);
        VerifyFact vf = new VerifyFact("Cheese", new ArrayList(), true);
        vf.fieldValues.add(new VerifyField("price", "42", "=="));
        vf.fieldValues.add(new VerifyField("type", "stilton", "=="));
        runner.verify(vf);
        ScenarioRunnerTest.assertTrue((boolean)vf.wasSuccessful());
        vf = new VerifyFact("Person", new ArrayList(), true);
        vf.fieldValues.add(new VerifyField("age", "42", "=="));
        runner.verify(vf);
        ScenarioRunnerTest.assertFalse((boolean)vf.wasSuccessful());
        vf = new VerifyFact("Cheese", new ArrayList(), true);
        vf.fieldValues.add(new VerifyField("price", "43", "=="));
        vf.fieldValues.add(new VerifyField("type", "stilton", "=="));
        runner.verify(vf);
        ScenarioRunnerTest.assertFalse((boolean)vf.wasSuccessful());
        ScenarioRunnerTest.assertEquals((Object)Boolean.FALSE, (Object)((VerifyField)vf.fieldValues.get((int)0)).successResult);
        vf = new VerifyFact("Cell", new ArrayList(), true);
        vf.fieldValues.add(new VerifyField("value", "43", "=="));
        runner.verify(vf);
        ScenarioRunnerTest.assertFalse((boolean)vf.wasSuccessful());
        ScenarioRunnerTest.assertEquals((Object)Boolean.FALSE, (Object)((VerifyField)vf.fieldValues.get((int)0)).successResult);
    }

    public void testVerifyFactsWithOperator() throws Exception {
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)new MockWorkingMemory());
        Cheese f1 = new Cheese("cheddar", 42);
        runner.populatedData.put("f1", f1);
        VerifyFact vf = new VerifyFact();
        vf.name = "f1";
        vf.fieldValues = this.ls(new VerifyField("type", "cheddar", "=="), new VerifyField("price", "4777", "!="));
        runner.verify(vf);
        for (int i = 0; i < vf.fieldValues.size(); ++i) {
            ScenarioRunnerTest.assertTrue((boolean)((VerifyField)vf.fieldValues.get((int)i)).successResult);
        }
        vf = new VerifyFact();
        vf.name = "f1";
        vf.fieldValues = this.ls(new VerifyField("type", "cheddar", "!="));
        runner.verify(vf);
        ScenarioRunnerTest.assertFalse((boolean)((VerifyField)vf.fieldValues.get((int)0)).successResult);
    }

    public void testVerifyFactsWithExpression() throws Exception {
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)new MockWorkingMemory());
        Cheese f1 = new Cheese("cheddar", 42);
        runner.populatedData.put("f1", f1);
        f1.setPrice(42);
        VerifyFact vf = new VerifyFact();
        vf.name = "f1";
        vf.fieldValues = this.ls(new VerifyField("price", "= 40 + 2", "=="));
        runner.verify(vf);
        ScenarioRunnerTest.assertTrue((boolean)((VerifyField)vf.fieldValues.get((int)0)).successResult);
    }

    public void testVerifyFactExplanation() throws Exception {
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)new MockWorkingMemory());
        Cheese f1 = new Cheese();
        f1.setType(null);
        runner.populatedData.put("f1", f1);
        VerifyFact vf = new VerifyFact();
        vf.name = "f1";
        vf.fieldValues.add(new VerifyField("type", "boo", "!="));
        runner.verify(vf);
        VerifyField vfl = (VerifyField)vf.fieldValues.get(0);
        ScenarioRunnerTest.assertEquals((String)"[f1] field [type] was not [boo].", (String)vfl.explanation);
    }

    public void testVerifyFieldAndActualIsNull() throws Exception {
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)new MockWorkingMemory());
        Cheese f1 = new Cheese();
        f1.setType(null);
        runner.populatedData.put("f1", f1);
        VerifyFact vf = new VerifyFact();
        vf.name = "f1";
        vf.fieldValues.add(new VerifyField("type", "boo", "=="));
        runner.verify(vf);
        VerifyField vfl = (VerifyField)vf.fieldValues.get(0);
        ScenarioRunnerTest.assertEquals((String)"[f1] field [type] was [] expected [boo].", (String)vfl.explanation);
        ScenarioRunnerTest.assertEquals((String)"boo", (String)vfl.expected);
        ScenarioRunnerTest.assertEquals((String)"", (String)vfl.actualResult);
    }

    public void testDummyRunNoRules() throws Exception {
        Scenario sc = new Scenario();
        FactData[] facts = new FactData[]{new FactData("Cheese", "c1", this.ls(new FieldData("type", "cheddar"), new FieldData("price", "42")), false)};
        VerifyFact[] assertions = new VerifyFact[]{new VerifyFact("c1", this.ls(new VerifyField("type", "cheddar", "=="), new VerifyField("price", "42", "==")))};
        sc.fixtures.addAll(Arrays.asList(facts));
        sc.fixtures.addAll(Arrays.asList(assertions));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        MockWorkingMemory wm = new MockWorkingMemory();
        ScenarioRunner runner = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)wm);
        ScenarioRunnerTest.assertEquals((int)1, (int)wm.facts.size());
        ScenarioRunnerTest.assertEquals(runner.populatedData.get("c1"), (Object)wm.facts.get(0));
        ScenarioRunnerTest.assertTrue((boolean)runner.populatedData.containsKey("c1"));
        VerifyFact vf = assertions[0];
        for (int i = 0; i < vf.fieldValues.size(); ++i) {
            ScenarioRunnerTest.assertTrue((boolean)((VerifyField)vf.fieldValues.get((int)i)).successResult);
        }
    }

    public void testCountVerification() throws Exception {
        HashMap<String, Integer> firingCounts = new HashMap<String, Integer>();
        firingCounts.put("foo", 2);
        firingCounts.put("bar", 1);
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)new MockWorkingMemory());
        VerifyRuleFired v = new VerifyRuleFired();
        v.ruleName = "foo";
        v.expectedFire = true;
        runner.verify(v, firingCounts);
        ScenarioRunnerTest.assertTrue((boolean)v.successResult);
        ScenarioRunnerTest.assertEquals((int)2, (int)v.actualResult);
        v = new VerifyRuleFired();
        v.ruleName = "foo";
        v.expectedFire = false;
        runner.verify(v, firingCounts);
        ScenarioRunnerTest.assertFalse((boolean)v.successResult);
        ScenarioRunnerTest.assertEquals((int)2, (int)v.actualResult);
        ScenarioRunnerTest.assertNotNull((Object)v.explanation);
        v = new VerifyRuleFired();
        v.ruleName = "foo";
        v.expectedCount = 2;
        runner.verify(v, firingCounts);
        ScenarioRunnerTest.assertTrue((boolean)v.successResult);
        ScenarioRunnerTest.assertEquals((int)2, (int)v.actualResult);
    }

    public void testTestingEventListener() throws Exception {
        Scenario sc = new Scenario();
        sc.rules.add("foo");
        sc.rules.add("bar");
        ExecutionTrace ext = new ExecutionTrace();
        sc.fixtures.add(ext);
        MockWorkingMemory wm = new MockWorkingMemory();
        ScenarioRunner run = new ScenarioRunner(sc, null, (InternalWorkingMemory)wm);
        ScenarioRunnerTest.assertEquals((Object)wm, (Object)run.workingMemory);
        ScenarioRunnerTest.assertNotNull((Object)wm.agendaEventListener);
        ScenarioRunnerTest.assertTrue((boolean)(wm.agendaEventListener instanceof TestingEventListener));
        TestingEventListener lnr = (TestingEventListener)wm.agendaEventListener;
        ScenarioRunnerTest.assertEquals((int)2, (int)sc.rules.size());
        ScenarioRunnerTest.assertTrue((boolean)sc.rules.contains("foo"));
        ScenarioRunnerTest.assertTrue((boolean)sc.rules.contains("bar"));
    }

    public void testWithGlobals() throws Exception {
        Scenario sc = new Scenario();
        FactData[] facts = new FactData[]{new FactData("Cheese", "c2", this.ls(new FieldData("type", "stilton")), false)};
        sc.globals.add(new FactData("Cheese", "c", this.ls(new FieldData("type", "cheddar")), false));
        sc.fixtures.addAll(Arrays.asList(facts));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        MockWorkingMemory wm = new MockWorkingMemory();
        ScenarioRunner run = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)wm);
        ScenarioRunnerTest.assertEquals((int)1, (int)wm.globals.size());
        ScenarioRunnerTest.assertEquals((int)1, (int)run.globalData.size());
        ScenarioRunnerTest.assertEquals((int)1, (int)run.populatedData.size());
        ScenarioRunnerTest.assertEquals((int)1, (int)wm.facts.size());
        Cheese c = (Cheese)wm.globals.get("c");
        ScenarioRunnerTest.assertEquals((String)"cheddar", (String)c.getType());
        Cheese c2 = (Cheese)wm.facts.get(0);
        ScenarioRunnerTest.assertEquals((String)"stilton", (String)c2.getType());
    }

    public void testSimulatedDate() throws Exception {
        Scenario sc = new Scenario();
        MockWorkingMemory wm = new MockWorkingMemory();
        ScenarioRunner run = new ScenarioRunner(sc, null, (InternalWorkingMemory)wm);
        TimeMachine tm = run.workingMemory.getTimeMachine();
        long time = tm.getNow().getTimeInMillis();
        Thread.sleep(100L);
        long future = tm.getNow().getTimeInMillis();
        ScenarioRunnerTest.assertTrue((future > time ? 1 : 0) != 0);
        ExecutionTrace ext = new ExecutionTrace();
        ext.scenarioSimulatedDate = new Date("10-Jul-1974");
        sc.fixtures.add(ext);
        run = new ScenarioRunner(sc, null, (InternalWorkingMemory)wm);
        tm = run.workingMemory.getTimeMachine();
        long expected = ext.scenarioSimulatedDate.getTime();
        ScenarioRunnerTest.assertEquals((long)expected, (long)tm.getNow().getTimeInMillis());
        Thread.sleep(50L);
        ScenarioRunnerTest.assertEquals((long)expected, (long)tm.getNow().getTimeInMillis());
    }

    public void testVerifyRuleFired() throws Exception {
        ScenarioRunner runner = new ScenarioRunner(new Scenario(), null, (InternalWorkingMemory)new MockWorkingMemory());
        VerifyRuleFired vr = new VerifyRuleFired("qqq", Integer.valueOf(42), null);
        HashMap<String, Integer> f = new HashMap<String, Integer>();
        f.put("qqq", 42);
        f.put("qaz", 1);
        runner.verify(vr, f);
        ScenarioRunnerTest.assertTrue((boolean)vr.wasSuccessful());
        ScenarioRunnerTest.assertEquals((int)42, (int)vr.actualResult);
        vr = new VerifyRuleFired("qqq", Integer.valueOf(41), null);
        runner.verify(vr, f);
        ScenarioRunnerTest.assertFalse((boolean)vr.wasSuccessful());
        ScenarioRunnerTest.assertEquals((int)42, (int)vr.actualResult);
        vr = new VerifyRuleFired("qaz", Integer.valueOf(1), null);
        runner.verify(vr, f);
        ScenarioRunnerTest.assertTrue((boolean)vr.wasSuccessful());
        ScenarioRunnerTest.assertEquals((int)1, (int)vr.actualResult);
        vr = new VerifyRuleFired("XXX", null, Boolean.valueOf(false));
        runner.verify(vr, f);
        ScenarioRunnerTest.assertTrue((boolean)vr.wasSuccessful());
        ScenarioRunnerTest.assertEquals((int)0, (int)vr.actualResult);
        vr = new VerifyRuleFired("qqq", null, Boolean.valueOf(true));
        runner.verify(vr, f);
        ScenarioRunnerTest.assertTrue((boolean)vr.wasSuccessful());
        ScenarioRunnerTest.assertEquals((int)42, (int)vr.actualResult);
        vr = new VerifyRuleFired("qqq", null, Boolean.valueOf(false));
        runner.verify(vr, f);
        ScenarioRunnerTest.assertFalse((boolean)vr.wasSuccessful());
        ScenarioRunnerTest.assertEquals((int)42, (int)vr.actualResult);
    }

    public void testIntegrationWithSuccess() throws Exception {
        Scenario sc = new Scenario();
        FactData[] facts = new FactData[]{new FactData("Cheese", "c1", this.ls(new FieldData("type", "cheddar"), new FieldData("price", "42")), false)};
        sc.globals.add(new FactData("Person", "p", new ArrayList(), false));
        sc.fixtures.addAll(Arrays.asList(facts));
        ExecutionTrace executionTrace = new ExecutionTrace();
        sc.rules.add("rule1");
        sc.rules.add("rule2");
        sc.inclusive = true;
        sc.fixtures.add(executionTrace);
        Expectation[] assertions = new Expectation[]{new VerifyFact("c1", this.ls(new VerifyField("type", "cheddar", "=="))), new VerifyFact("p", this.ls(new VerifyField("name", "rule1", "=="), new VerifyField("status", "rule2", "=="))), new VerifyRuleFired("rule1", Integer.valueOf(1), null), new VerifyRuleFired("rule2", Integer.valueOf(1), null), new VerifyRuleFired("rule3", Integer.valueOf(0), null)};
        sc.fixtures.addAll(Arrays.asList(assertions));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.Person");
        StatefulSession wm = this.getWorkingMemory("test_rules2.drl");
        ScenarioRunner run = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)wm);
        ScenarioRunnerTest.assertEquals((int)2, (int)executionTrace.numberOfRulesFired.intValue());
        ScenarioRunnerTest.assertSame((Object)run.scenario, (Object)sc);
        ScenarioRunnerTest.assertTrue((boolean)sc.wasSuccessful());
        Person p = (Person)run.globalData.get("p");
        ScenarioRunnerTest.assertEquals((String)"rule1", (String)p.getName());
        ScenarioRunnerTest.assertEquals((String)"rule2", (String)p.getStatus());
        ScenarioRunnerTest.assertEquals((int)0, (int)p.getAge());
        Thread.sleep(50L);
        ScenarioRunnerTest.assertTrue((boolean)new Date().after(sc.lastRunResult));
        ScenarioRunnerTest.assertTrue((executionTrace.executionTimeResult != null ? 1 : 0) != 0);
        ScenarioRunnerTest.assertTrue((executionTrace.rulesFired.length > 0 ? 1 : 0) != 0);
    }

    public void testIntegrationInfiniteLoop() throws Exception {
        Scenario sc = new Scenario();
        FactData[] facts = new FactData[]{new FactData("Cheese", "c1", this.ls(new FieldData("type", "cheddar"), new FieldData("price", "42")), false)};
        sc.globals.add(new FactData("Person", "p", new ArrayList(), false));
        sc.fixtures.addAll(Arrays.asList(facts));
        ExecutionTrace executionTrace = new ExecutionTrace();
        sc.rules.add("rule1");
        sc.rules.add("rule2");
        sc.inclusive = true;
        sc.fixtures.add(executionTrace);
        Expectation[] assertions = new Expectation[]{new VerifyFact("c1", this.ls(new VerifyField("type", "cheddar", "=="))), new VerifyFact("p", this.ls(new VerifyField("name", "rule1", "=="), new VerifyField("status", "rule2", "=="))), new VerifyRuleFired("rule1", Integer.valueOf(1), null), new VerifyRuleFired("rule2", Integer.valueOf(1), null), new VerifyRuleFired("rule3", Integer.valueOf(0), null)};
        sc.fixtures.addAll(Arrays.asList(assertions));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.Person");
        StatefulSession wm = this.getWorkingMemory("test_rules_infinite_loop.drl");
        ScenarioRunner run = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)wm);
        ScenarioRunnerTest.assertEquals((int)sc.maxRuleFirings, (int)executionTrace.numberOfRulesFired.intValue());
    }

    public void testIntegrationWithDeclaredTypes() throws Exception {
        Scenario sc = new Scenario();
        FactData[] facts = new FactData[]{new FactData("Coolness", "c", this.ls(new FieldData("num", "42"), new FieldData("name", "mic")), false)};
        sc.fixtures.addAll(Arrays.asList(facts));
        ExecutionTrace executionTrace = new ExecutionTrace();
        sc.rules.add("rule1");
        sc.inclusive = true;
        sc.fixtures.add(executionTrace);
        Expectation[] assertions = new Expectation[]{new VerifyFact("c", this.ls(new VerifyField("num", "42", "=="))), new VerifyRuleFired("rule1", Integer.valueOf(1), null)};
        sc.fixtures.addAll(Arrays.asList(assertions));
        StatefulSession wm = this.getWorkingMemory("test_rules3.drl");
        CompositeClassLoader cl = ((InternalRuleBase)wm.getRuleBase()).getRootClassLoader();
        HashSet<String> imports = new HashSet<String>();
        imports.add("foo.bar.*");
        ClassTypeResolver resolver = new ClassTypeResolver(imports, (ClassLoader)cl);
        Class<?> cls = cl.loadClass("foo.bar.Coolness");
        ScenarioRunnerTest.assertNotNull(cls);
        ClassLoader cl_ = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)cl);
        ScenarioRunner run = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)wm);
        ScenarioRunnerTest.assertEquals((int)1, (int)executionTrace.numberOfRulesFired.intValue());
        ScenarioRunnerTest.assertSame((Object)run.scenario, (Object)sc);
        ScenarioRunnerTest.assertTrue((boolean)sc.wasSuccessful());
        Thread.currentThread().setContextClassLoader(cl_);
    }

    public void testIntgerationStateful() throws Exception {
        Scenario sc = new Scenario();
        sc.fixtures.add(new FactData("Cheese", "c1", this.ls(new FieldData("price", "1")), false));
        ExecutionTrace ex = new ExecutionTrace();
        sc.fixtures.add(ex);
        sc.fixtures.add(new FactData("Cheese", "c2", this.ls(new FieldData("price", "2")), false));
        sc.fixtures.add(new VerifyFact("c1", this.ls(new VerifyField("type", "rule1", "=="))));
        ex = new ExecutionTrace();
        sc.fixtures.add(ex);
        sc.fixtures.add(new VerifyFact("c1", this.ls(new VerifyField("type", "rule2", "=="))));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        StatefulSession wm = this.getWorkingMemory("test_stateful.drl");
        ScenarioRunner run = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)wm);
        Cheese c1 = (Cheese)run.populatedData.get("c1");
        Cheese c2 = (Cheese)run.populatedData.get("c2");
        ScenarioRunnerTest.assertEquals((String)"rule2", (String)c1.getType());
        ScenarioRunnerTest.assertEquals((String)"rule2", (String)c2.getType());
        ScenarioRunnerTest.assertTrue((boolean)sc.wasSuccessful());
    }

    public void testIntegrationWithModify() throws Exception {
        Scenario sc = new Scenario();
        sc.fixtures.add(new FactData("Cheese", "c1", this.ls(new FieldData("price", "1")), false));
        sc.fixtures.add(new ExecutionTrace());
        sc.fixtures.add(new VerifyFact("c1", this.ls(new VerifyField("type", "rule1", "=="))));
        sc.fixtures.add(new FactData("Cheese", "c1", this.ls(new FieldData("price", "42")), true));
        sc.fixtures.add(new ExecutionTrace());
        sc.fixtures.add(new VerifyFact("c1", this.ls(new VerifyField("type", "rule3", "=="))));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        StatefulSession wm = this.getWorkingMemory("test_stateful.drl");
        ScenarioRunner run = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)wm);
        Cheese c1 = (Cheese)run.populatedData.get("c1");
        ScenarioRunnerTest.assertEquals((String)"rule3", (String)c1.getType());
        ScenarioRunnerTest.assertTrue((boolean)sc.wasSuccessful());
    }

    public void testIntegrationWithRetract() throws Exception {
        Scenario sc = new Scenario();
        sc.fixtures.add(new FactData("Cheese", "c1", this.ls(new FieldData("price", "46"), new FieldData("type", "XXX")), false));
        sc.fixtures.add(new FactData("Cheese", "c2", this.ls(new FieldData("price", "42")), false));
        sc.fixtures.add(new ExecutionTrace());
        sc.fixtures.add(new VerifyFact("c1", this.ls(new VerifyField("type", "XXX", "=="))));
        sc.fixtures.add(new RetractFact("c2"));
        sc.fixtures.add(new ExecutionTrace());
        sc.fixtures.add(new VerifyFact("c1", this.ls(new VerifyField("type", "rule4", "=="))));
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        StatefulSession wm = this.getWorkingMemory("test_stateful.drl");
        ScenarioRunner run = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)wm);
        Cheese c1 = (Cheese)run.populatedData.get("c1");
        ScenarioRunnerTest.assertEquals((String)"rule4", (String)c1.getType());
        ScenarioRunnerTest.assertFalse((boolean)run.populatedData.containsKey("c2"));
        ScenarioRunnerTest.assertTrue((boolean)sc.wasSuccessful());
    }

    public void testIntegrationWithFailure() throws Exception {
        Scenario sc = new Scenario();
        Expectation[] assertions = this.populateScenarioForFailure(sc);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.Person");
        StatefulSession wm = this.getWorkingMemory("test_rules2.drl");
        ScenarioRunner run = new ScenarioRunner(sc, (TypeResolver)resolver, (InternalWorkingMemory)wm);
        ScenarioRunnerTest.assertSame((Object)run.scenario, (Object)sc);
        ScenarioRunnerTest.assertFalse((boolean)sc.wasSuccessful());
        VerifyFact vf = (VerifyFact)assertions[1];
        ScenarioRunnerTest.assertFalse((boolean)((VerifyField)vf.fieldValues.get((int)0)).successResult);
        ScenarioRunnerTest.assertEquals((String)"XXX", (String)((VerifyField)vf.fieldValues.get((int)0)).expected);
        ScenarioRunnerTest.assertEquals((String)"rule1", (String)((VerifyField)vf.fieldValues.get((int)0)).actualResult);
        ScenarioRunnerTest.assertNotNull((Object)((VerifyField)vf.fieldValues.get((int)0)).explanation);
        VerifyRuleFired vr = (VerifyRuleFired)assertions[4];
        ScenarioRunnerTest.assertFalse((boolean)vr.successResult);
        ScenarioRunnerTest.assertEquals((int)2, (int)vr.expectedCount);
        ScenarioRunnerTest.assertEquals((int)0, (int)vr.actualResult);
    }

    public void testRunAsString() throws Exception {
        Scenario sc = new Scenario();
        this.populateScenarioForFailure(sc);
        String xml = ScenarioXMLPersistence.getInstance().marshal(sc);
        StatefulSession wm = this.getWorkingMemory("test_rules2.drl");
        ScenarioRunner runner = new ScenarioRunner(xml, wm.getRuleBase());
        ScenarioRunnerTest.assertFalse((boolean)runner.wasSuccess());
        String failures = runner.getReport();
        ScenarioRunnerTest.assertFalse((boolean)"".equals(failures));
        System.err.println(failures);
    }

    private Expectation[] populateScenarioForFailure(Scenario sc) {
        FactData[] facts = new FactData[]{new FactData("Cheese", "c1", this.ls(new FieldData("type", "cheddar"), new FieldData("price", "42")), false)};
        sc.fixtures.addAll(Arrays.asList(facts));
        sc.globals.add(new FactData("Person", "p", new ArrayList(), false));
        ExecutionTrace executionTrace = new ExecutionTrace();
        sc.rules.add("rule1");
        sc.rules.add("rule2");
        sc.inclusive = true;
        sc.fixtures.add(executionTrace);
        Expectation[] assertions = new Expectation[]{new VerifyFact("c1", this.ls(new VerifyField("type", "cheddar", "=="))), new VerifyFact("p", this.ls(new VerifyField("name", "XXX", "=="), new VerifyField("status", "rule2", "=="))), new VerifyRuleFired("rule1", Integer.valueOf(1), null), new VerifyRuleFired("rule2", Integer.valueOf(1), null), new VerifyRuleFired("rule3", Integer.valueOf(2), null)};
        sc.fixtures.addAll(Arrays.asList(assertions));
        return assertions;
    }

    private <T> List<T> ls(T ... objects) {
        return Arrays.asList(objects);
    }

    static {
        try {
            Class.forName("org.drools.base.mvel.MVELCompilationUnit");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

